package com.tolstoy.imagemeister;

import java.awt.*;

/**
This class represents a Panel which contains an icon for a plugin. For a given plugin, subclasses
of this class are returned from the plugin's getIconPanel() method. The icon may be static, or
animated.

Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.
*/

public abstract class IconPanel extends Panel {
	private static final String copyright="ImageMeister Copyright (c) 1998-2002 Samizdat Productions. All Rights Reserved. ImageMeister is a Trademark of Samizdat Productions.";

/**
Start any animation for this icon.
*/

	public abstract void startAnimation();

/**
Stop any animation for this icon.
*/

	public abstract void stopAnimation();

/**
Pause ths animation for this icon at the current frame.
*/

	public abstract void pauseAnimation();

/**
Rewind any animation for this icon to the first frame.
*/

	public abstract void resetAnimation();

/**
Step any animation for this icon to the next frame.
*/

	public abstract void stepAnimation();

/**
Set the animation speed for this icon.
@param s the length of each frame of the animation, where s is in 60ths of a second
*/

	public abstract void setAnimationSpeed( int s );
}

