/*
 * Decompiled with CFR 0.152.
 */
package com.idautomation.linear;

import com.idautomation.linear.BCApplet;
import com.idautomation.linear.BarCode;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IDAutomationServlet
extends HttpServlet {
    private boolean debug = false;

    public void init() throws ServletException {
    }

    private BarCode getChart(HttpServletRequest httpServletRequest) {
        BCApplet bCApplet = new BCApplet();
        bCApplet.isStandalone = true;
        bCApplet.init();
        if (httpServletRequest != null) {
            if (httpServletRequest.getParameter("DEBUG") != null && httpServletRequest.getParameter("DEBUG").toUpperCase().compareTo("ON") == 0) {
                this.debug = true;
            }
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                bCApplet.setParameter(string, httpServletRequest.getParameter(string));
                if (!this.debug) continue;
                System.out.println("PARAM: " + string + "=" + httpServletRequest.getParameter(string));
            }
        }
        return bCApplet.BC;
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "jpeg";
        if (httpServletRequest != null) {
            if (httpServletRequest.getParameter("FORMAT") != null) {
                string = httpServletRequest.getParameter("FORMAT").toLowerCase();
            }
            if (string.compareTo("gif") != 0) {
                string = "jpeg";
            }
        }
        httpServletResponse.setContentType("image/" + string);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        try {
            int n = 200;
            int n2 = 80;
            if (httpServletRequest != null) {
                if (httpServletRequest.getParameter("WIDTH") != null) {
                    n = new Integer(httpServletRequest.getParameter("WIDTH"));
                }
                if (httpServletRequest.getParameter("HEIGHT") != null) {
                    n2 = new Integer(httpServletRequest.getParameter("HEIGHT"));
                }
            }
            BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            BarCode barCode = this.getChart(httpServletRequest);
            if (this.debug) {
                System.out.println("Size: " + n + " " + n2);
            }
            barCode.setSize(n, n2);
            barCode.paint(graphics2D);
            if (string.compareToIgnoreCase("gif") != 0) {
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)servletOutputStream);
                jPEGImageEncoder.encode(bufferedImage);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            this.doGet(httpServletRequest, httpServletResponse);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

