
/*

	 Finger for Windows 95.
	 Copyright (C) 1996  Peter A. Salerno

	 This program is free software; you can redistribute it and/or modify
	 it under the terms of the GNU General Public License as published by
	 the Free Software Foundation; either version 2 of the License, or
	 (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 GNU General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; if not, write to the Free Software
	 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "general.h"

int finger(char *input)
{
  FILE *ofp;
  struct hostent *host;
  struct servent *serv;
  struct sockaddr_in sa;
  char buf[BUFSIZ+1];
  char far *hostname, *username;
  int sock, i, len;

  ofp = fopen("output.tmp", "wt");
  if (ofp == NULL) return(-1);

  if (!cksock())   {fclose(ofp);	return(-2);}

  if (parse(input, &hostname, &username) != 0)
						 {fclose(ofp);	return(-3);}

  host = gethostbyname(hostname);
  if (host==NULL)
	 {
		ckerror(WSAGetLastError());
		fprintf(ofp, "finger: unknown host: %s\n", hostname);
		fclose(ofp);
		return(-4);
	 }

	memcpy((char *)&sa.sin_addr, host->h_addr_list[0], host->h_length);
	sa.sin_family = host->h_addrtype;
	fprintf(ofp, "[%s]\n", host->h_name);

	if((serv = getservbyname("finger", "tcp")) == NULL)
	 {
		fprintf(ofp, "finger: No finger server at host\n");
		fclose(ofp);
		return(-5);
	 }

  sa.sin_port = serv->s_port;

  if((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	 {
		ckerror(WSAGetLastError());
		fclose(ofp);
		return(-6);
	 }


  if ((connect(sock, (struct sockaddr *)&sa, sizeof(sa))) < 0)
	 {
		ckerror(WSAGetLastError());
		fclose(ofp);
		return(-7);
	 }

  /*Append CRLF to end of string.*/
  for(i=0;username[i]!='\0';i++);
  username[i++]=13;username[i++]=10;username[i]='\0';


  if(send(sock, username, strlen(username), 0) != strlen(username))
	 {
		fprintf(ofp, "finger: write error\n");
		fclose(ofp);
		return(-8);
	 }

  while((len = recv(sock, buf, BUFSIZ, 0)) > 0)
	for(i=0;i<len;i++) fprintf(ofp, "%c", buf[i]);

  if (len<0) perror("read");
  closesocket(sock);
  fclose(ofp);

 return(1);
}




int cksock(void)
{
char wVersionRequested;
WSADATA wsaData;
int err;

wVersionRequested = 0x11;

err = WSAStartup( wVersionRequested, &wsaData );
if ( err != 0 ) {
	 /* Tell the user that we couldn't find a useable */
	 /* winsock.dll.                                  */
	 return(-1);
}

if ( LOBYTE( wsaData.wVersion ) != 1 ||
			HIBYTE( wsaData.wVersion ) != 1 )
{
	 WSACleanup( );
	 return(-1);
}

/* The Windows Sockets DLL is acceptable.  Proceed.  */
if (err==0) return(1);
return(-1);
}

