/*
 * Decompiled with CFR 0.152.
 */
package jms.graphics;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.util.Enumeration;
import java.util.Vector;
import jms.graphics.GrayFilter;

public class IconCanvas
extends Canvas
implements MouseListener {
    public static final int BORDER = 4;
    public static final int ACTIVE = 1;
    public static final int INACTIVE = 2;
    public static final int PASSIVE = 3;
    public static final int PRESSED = 4;
    public Image icon;
    public Image passiveIcon;
    public Image inactiveIcon;
    public int mode = 1;
    public Image currentIcon;
    public Vector listeners;

    public IconCanvas(Image img) {
        this.icon = img;
        this.currentIcon = this.passiveIcon = this.createImage(new FilteredImageSource(this.icon.getSource(), new GrayFilter()));
        this.inactiveIcon = this.passiveIcon;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(this.icon, 0);
        tracker.addImage(this.passiveIcon, 1);
        try {
            tracker.waitForID(0);
            tracker.waitForID(1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mode = 3;
        this.addMouseListener(this);
    }

    public void addActionListener(ActionListener al) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        if (!this.listeners.contains(al)) {
            this.listeners.addElement(al);
        }
    }

    public void fireEvent() {
        if (this.listeners == null) {
            return;
        }
        ActionEvent evt = new ActionEvent(this, 0, "");
        ActionListener al = null;
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            al = (ActionListener)e.nextElement();
            al.actionPerformed(evt);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.lightGray);
        g.fillRect(0, 0, d.width, d.height);
        switch (this.mode) {
            case 1: {
                g.setColor(Color.white);
                g.draw3DRect(0, 0, d.width - 1, d.height - 1, true);
                break;
            }
            case 4: {
                g.setColor(Color.white);
                g.draw3DRect(0, 0, d.width - 1, d.height - 1, false);
                break;
            }
        }
        g.drawImage(this.currentIcon, 4, 4, null);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.icon.getWidth(this) + 8, this.icon.getHeight(this) + 8);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Insets getInsets() {
        return new Insets(3, 3, 3, 3);
    }

    public void setMode(int mod) {
        this.mode = mod;
        switch (this.mode) {
            case 1: 
            case 4: {
                this.currentIcon = this.icon;
                break;
            }
            case 2: {
                this.currentIcon = this.inactiveIcon;
                break;
            }
            case 3: {
                this.currentIcon = this.passiveIcon;
                break;
            }
            default: {
                this.currentIcon = this.passiveIcon;
            }
        }
    }

    public boolean isInactive() {
        return this.mode == 2;
    }

    public void setInactive(boolean m) {
        if (m) {
            this.setMode(2);
        } else {
            this.setMode(3);
        }
        this.repaint();
    }

    public void mouseEntered(MouseEvent evt) {
        if (this.isInactive()) {
            return;
        }
        this.setMode(1);
        this.repaint();
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.isInactive()) {
            return;
        }
        this.setMode(1);
        this.repaint();
        this.fireEvent();
    }

    public void mousePressed(MouseEvent evt) {
        if (this.isInactive()) {
            return;
        }
        this.setMode(4);
        this.repaint();
    }

    public void mouseExited(MouseEvent evt) {
        if (this.isInactive()) {
            return;
        }
        this.setMode(3);
        this.repaint();
    }

    public void mouseClicked(MouseEvent evt) {
        if (this.isInactive()) {
            return;
        }
    }
}

