/*

	 Finger for Windows 95.
	 Copyright (C) 1996  Peter A. Salerno

	 This program is free software; you can redistribute it and/or modify
	 it under the terms of the GNU General Public License as published by
	 the Free Software Foundation; either version 2 of the License, or
	 (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 GNU General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; if not, write to the Free Software
	 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <windows.h>

int finger(char *input);
void printmsg(void);

int main(int argc, char *argv[])
{
FILE *ifp;
char far command[150];
int c;

if (argc==1) {printf("Usage: finger [username]@hostname\n"); return(0);}
strcpy(command, argv[1]);

if (strcmp(command, "/?")==0) {printmsg();return(0);}
if((c=finger(command))>0)
{
	if((ifp=fopen("output.tmp", "rt"))==NULL)
		printf("finger: cannot open temp file.\n");
	else
		{
		  while((c=fgetc(ifp))!=EOF)
		  printf("%c", c);
		}

	fclose(ifp);
	remove("output.tmp");
}

return(0);
}


void printmsg(void)
{
printf("\n\n");
printf("Finger Client for Microsoft Windows 95.\n");
printf("Copyright (C) 1996 Peter A. Salerno\n\n");
printf("*******************************************************************\n");
printf("To use this program, put it somewhere in your PATH, such as        \n");
printf("C:\WINDOWS, and type 'finger username@hostname' (or just @hostname)\n");
printf("from the Windows 95 DOS Shell.  You must have an active TCP/IP     \n");
printf("internet connection via winsock.dll.  This program is Email        \n");
printf("messageware.  Please email me if you decide to keep it.            \n\n");

printf("For more information contact Peter Salerno at psalerno@li.net,     \n");
printf("or see http://www.li.net/~psalerno.                                \n");
printf("*******************************************************************\n");
return;
}

