/*
 * Decompiled with CFR 0.152.
 */
package jms.util;

import java.util.Hashtable;
import jms.util.TraceDomain;

public class Trace {
    private static Hashtable domains = new Hashtable();
    private static String path = "log/";

    public static synchronized TraceDomain createDomain(String domain_name, String output) {
        TraceDomain domain = Trace.getDomain(domain_name);
        if (domain == null) {
            domain = new TraceDomain(domain_name, output);
            domains.put(domain_name, domain);
        }
        return domain;
    }

    public static synchronized TraceDomain createDomain(String domain_name, TraceDomain parent_domain) {
        TraceDomain domain = Trace.createDomain(domain_name, "tty");
        domain.makeSubdomainOf(parent_domain);
        return domain;
    }

    public static TraceDomain getDomain(String domain_name) {
        return (TraceDomain)domains.get(domain_name);
    }

    public static void out(String domain_name, String msg) {
        TraceDomain domain = Trace.getDomain(domain_name);
        if (domain != null) {
            domain.out(msg);
        } else {
            System.out.println("WARNING: Can't trace on: " + domain_name + " {\n" + msg + "\n}");
            System.out.println("Ignoring Trace message.");
        }
    }

    public static void out(String domain_name, String msg, Exception e) {
        TraceDomain domain = Trace.getDomain(domain_name);
        if (domain != null) {
            domain.out(msg, e);
        } else {
            System.out.println("WARNING: Can't trace on: " + domain_name + " {\n" + msg + "\n}");
            System.out.println("Ignoring Trace message.");
        }
    }

    public static Hashtable getDomains() {
        return (Hashtable)domains.clone();
    }

    public static synchronized void setPath(String new_path) {
        path = new_path;
    }

    public static synchronized String getPath() {
        return path;
    }
}

