/*
 * Decompiled with CFR 0.152.
 */
package jms.de;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import jms.de.FileFormatPanel;
import jms.de.FilesLoaderObserver;
import jms.de.GetFile;
import jms.graphics.GenericThumbnail;
import jms.graphics.ImageThumbnail;
import jms.graphics.MessageBox;
import jms.graphics.ThumbnailListener;

public class FilesLoader
extends Thread {
    private Vector listOfFiles;
    private FilesLoaderObserver filesLoaderObserver;
    private boolean shouldStop = false;
    private ThumbnailListener thumbnailListener;

    public FilesLoader(Vector list_of_files, FilesLoaderObserver flo, ThumbnailListener tl) {
        this.listOfFiles = list_of_files;
        this.filesLoaderObserver = flo;
        this.thumbnailListener = tl;
    }

    public void shouldStop() {
        this.shouldStop = true;
    }

    public Image loadImage(String image_name) {
        return Toolkit.getDefaultToolkit().getImage(image_name);
    }

    public void run() {
        Object g_thumbnail = null;
        Object thumbnail = null;
        Image img = null;
        String full_file_name = null;
        File file_on_disk = null;
        String file_name = null;
        String path = null;
        Runtime rt = Runtime.getRuntime();
        String vendor = System.getProperty("java.vendor");
        if (vendor != null) {
            vendor = vendor.toLowerCase();
        }
        Enumeration e = this.listOfFiles.elements();
        while (e.hasMoreElements()) {
            if (this.shouldStop) break;
            full_file_name = (String)e.nextElement();
            if (rt.freeMemory() < 10240L && vendor != null && vendor.indexOf("microsoft") == -1) {
                MessageBox mb = new MessageBox("Out of Memory|Cannot load all files!");
                break;
            }
            file_on_disk = new File(full_file_name);
            if (!file_on_disk.exists()) continue;
            file_name = GetFile.getFileNameFromPath(full_file_name);
            path = GetFile.getFilePath(full_file_name);
            if (FileFormatPanel.isImage(full_file_name)) {
                img = this.loadImage(full_file_name);
                this.filesLoaderObserver.update(new ImageThumbnail(this.thumbnailListener, img, file_name, path, file_on_disk.length()));
            } else {
                img = this.loadImage(String.valueOf(this.filesLoaderObserver.getIconPath()) + FileFormatPanel.getIconName(file_name));
                this.filesLoaderObserver.update(new GenericThumbnail(this.thumbnailListener, img, file_name, path, file_on_disk.length()));
            }
            img.flush();
            img = null;
        }
        this.filesLoaderObserver.update(null);
    }
}

