/*
 * Decompiled with CFR 0.152.
 */
package hsplitter;

import hsplitter.JFrameHSplitter_AboutBox;
import hsplitter.control.HSplitLogic;
import hsplitter.model.Config;
import hsplitter.tools.Help;
import hsplitter.tools.Logger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class JFrameHSplitter
extends JFrame
implements HSplitLogic.ProgressEventListener {
    private static final boolean DEBUG = true;
    private static final String productName = "HTMLslicer";
    File htmlFile = null;
    HSplitLogic logic = null;
    Logger logger = null;
    JPanel contentPane;
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenuFile = new JMenu();
    JMenuItem jMenuFileExit = new JMenuItem();
    JMenu jMenuHelp = new JMenu();
    JMenuItem jMenuHelpAbout = new JMenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelStatusBar = new JPanel();
    JLabel jLabelStatusBar = new JLabel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    TitledBorder titledBorder1;
    JTabbedPane jTabbedPane0 = new JTabbedPane();
    JPanel jPanelDropIn = new JPanel();
    JPanel jPanelConfigSplit = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout5 = new BorderLayout();
    JMenuItem jMenuItemOpenHtml = new JMenuItem();
    JMenuItem jMenuItemSplit = new JMenuItem();
    JMenuItem jMenuItemConfigSave = new JMenuItem();
    JMenuItem jMenuItemHelpContent = new JMenuItem();
    JScrollPane jScrollPaneReport = new JScrollPane();
    JTextArea jTextArea1 = new JTextArea();
    JTextArea jTextAreaReport = new JTextArea();
    JPanel jPanelTOC = new JPanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanelSplitAt = new JPanel();
    GridLayout gridLayout1 = new GridLayout();
    JPanel jPanelSplit = new JPanel();
    GridLayout gridLayout2 = new GridLayout();
    JPanel jPanelNaming = new JPanel();
    GridLayout gridLayout3 = new GridLayout();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    Border border2;
    TitledBorder titledBorder2;
    Border border3;
    TitledBorder titledBorder3;
    JPanel jPanel2 = new JPanel();
    GridLayout gridLayout5 = new GridLayout();
    JPanel jPanel6 = new JPanel();
    GridLayout gridLayout6 = new GridLayout();
    JCheckBox jCheckBoxJavaHelp = new JCheckBox();
    ButtonGroup buttonGroupNaming = new ButtonGroup();
    JRadioButton jRadioButtonSplitH1 = new JRadioButton();
    JRadioButton jRadioButtonSplitH2 = new JRadioButton();
    JRadioButton jRadioButtonSplitH3 = new JRadioButton();
    ButtonGroup buttonGroupSplit = new ButtonGroup();
    JPanel jPanelStyle = new JPanel();
    BorderLayout borderLayout7 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel7 = new JPanel();
    GridLayout gridLayout8 = new GridLayout();
    JPanel jPanel1 = new JPanel();
    JCheckBox jCheckBoxTOCCreate = new JCheckBox();
    BorderLayout borderLayout8 = new BorderLayout();
    JTextField jTextFieldTemplateTOCFile = new JTextField();
    BorderLayout borderLayout9 = new BorderLayout();
    JPanel jPanel8 = new JPanel();
    GridLayout gridLayout7 = new GridLayout();
    JTextField jTextFieldTemplateBodyFile = new JTextField();
    JTextField jTextFieldTemplateFooterFile = new JTextField();
    JTextField jTextFieldTemplateHeaderFile = new JTextField();
    TitledBorder titledBorder4;
    Border border4;
    TitledBorder titledBorder5;
    JCheckBox jCheckBoxTemplateBody = new JCheckBox();
    JCheckBox jCheckBoxTemplateHeader = new JCheckBox();
    JCheckBox jCheckBoxTemplateFooter = new JCheckBox();
    JCheckBox jCheckBoxTemplateTransition = new JCheckBox();
    JTextField jTextFieldTemplateTransitionFile = new JTextField();
    JPanel jPanel9 = new JPanel();
    BorderLayout borderLayout10 = new BorderLayout();
    JCheckBox jCheckBoxLowerCase = new JCheckBox();
    JTextField jTextFieldPageExtension = new JTextField();
    BorderLayout borderLayout11 = new BorderLayout();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    static Class class$hsplitter$JFrameHSplitter;

    public JFrameHSplitter() {
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logic = new HSplitLogic();
        this.logic.addProgressEventListener(this);
        this.updateConfigDisplay();
        if (this.logic.isConfigFromFile()) {
            this.jLabelStatusBar.setText("INFO: Configuration from Config.ser file");
        } else {
            this.jLabelStatusBar.setText("WARN: Default configuration created");
        }
    }

    private void jbInit() throws Exception {
        ((Frame)this).setIconImage(Toolkit.getDefaultToolkit().createImage((class$hsplitter$JFrameHSplitter == null ? (class$hsplitter$JFrameHSplitter = JFrameHSplitter.class$("hsplitter.JFrameHSplitter")) : class$hsplitter$JFrameHSplitter).getResource("HTMLslicer32.gif")));
        this.contentPane = (JPanel)this.getContentPane();
        this.border1 = BorderFactory.createEmptyBorder();
        this.titledBorder1 = new TitledBorder(BorderFactory.createEmptyBorder(), "Drop Area and Activity Report");
        this.border2 = BorderFactory.createEmptyBorder();
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(151, 145, 140)), "Slice at");
        this.border3 = BorderFactory.createEtchedBorder(Color.white, new Color(151, 145, 140));
        this.titledBorder3 = new TitledBorder(this.border3, "Naming");
        this.titledBorder4 = new TitledBorder("");
        this.border4 = BorderFactory.createEtchedBorder(Color.white, new Color(151, 145, 140));
        this.titledBorder5 = new TitledBorder(this.border4, "Templates");
        this.contentPane.setLayout(this.borderLayout1);
        ((Component)this).setSize(new Dimension(400, 300));
        this.setTitle(productName);
        this.jMenuFile.setMnemonic('F');
        this.jMenuFile.setText("File");
        this.jMenuFileExit.setMnemonic('X');
        this.jMenuFileExit.setText("Exit");
        this.jMenuFileExit.setAccelerator(KeyStroke.getKeyStroke(88, 2, true));
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrameHSplitter.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jMenuHelp.setMnemonic('H');
        this.jMenuHelp.setText("Help");
        this.jMenuHelpAbout.setMnemonic('A');
        this.jMenuHelpAbout.setText("About ...");
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrameHSplitter.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jLabelStatusBar.setBackground(Color.lightGray);
        this.jLabelStatusBar.setToolTipText("Status line");
        this.jLabelStatusBar.setText(" Status");
        this.jPanelStatusBar.setLayout(this.borderLayout2);
        this.jPanelStatusBar.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelDropIn.setLayout(this.borderLayout4);
        this.jPanelConfigSplit.setLayout(this.borderLayout5);
        this.jMenuItemOpenHtml.setMnemonic('O');
        this.jMenuItemOpenHtml.setText("Open Html ...");
        this.jMenuItemOpenHtml.setAccelerator(KeyStroke.getKeyStroke(79, 2, true));
        this.jMenuItemOpenHtml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrameHSplitter.this.jMenuItemOpenHtml_actionPerformed(e);
            }
        });
        this.jMenuItemSplit.setEnabled(false);
        this.jMenuItemSplit.setMnemonic('H');
        this.jMenuItemSplit.setText("Slice Html");
        this.jMenuItemSplit.setAccelerator(KeyStroke.getKeyStroke(72, 2, true));
        this.jMenuItemSplit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrameHSplitter.this.jMenuItemSplit_actionPerformed(e);
            }
        });
        this.jMenuItemConfigSave.setMnemonic('S');
        this.jMenuItemConfigSave.setText("Save Setup");
        this.jMenuItemConfigSave.setAccelerator(KeyStroke.getKeyStroke(83, 2, true));
        this.jMenuItemConfigSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrameHSplitter.this.jMenuItemConfigSave_actionPerformed(e);
            }
        });
        this.jMenuItemHelpContent.setMnemonic('C');
        this.jMenuItemHelpContent.setText("Content ...");
        this.jMenuItemHelpContent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFrameHSplitter.this.jMenuItemHelpContent_actionPerformed(e);
            }
        });
        this.jTextArea1.setText("jTextArea1");
        this.jPanelDropIn.setBorder(this.titledBorder1);
        this.jPanelTOC.setLayout(this.borderLayout3);
        this.jPanelSplitAt.setLayout(this.gridLayout1);
        this.gridLayout1.setRows(3);
        this.jPanelSplit.setLayout(this.gridLayout2);
        this.gridLayout2.setColumns(2);
        this.gridLayout2.setRows(3);
        this.jPanelNaming.setLayout(this.gridLayout3);
        this.gridLayout3.setRows(3);
        this.jPanel4.setLayout(this.borderLayout6);
        this.jPanel5.setLayout(this.borderLayout11);
        this.jPanelSplit.setBorder(this.titledBorder2);
        this.jPanelNaming.setBorder(this.titledBorder3);
        this.jPanel2.setLayout(this.gridLayout5);
        this.gridLayout5.setRows(2);
        this.jPanel6.setLayout(this.gridLayout6);
        this.gridLayout6.setRows(2);
        this.jCheckBoxJavaHelp.setToolTipText("Generate JavaHelp metadata if it is selected");
        this.jCheckBoxJavaHelp.setText("JavaHelp metadata");
        this.jPanel6.setBorder(BorderFactory.createEtchedBorder());
        this.jRadioButtonSplitH1.setToolTipText("Cleavage point at <H1> tag only");
        this.jRadioButtonSplitH1.setText("<H1> Heading");
        this.jRadioButtonSplitH2.setToolTipText("Cleavage point at <H1> and <H2> tags");
        this.jRadioButtonSplitH2.setText("<H2> Heading");
        this.jRadioButtonSplitH3.setToolTipText("Cleavage point at <H1>, <H2> and <H3> tags");
        this.jRadioButtonSplitH3.setText("<H3> Heading");
        this.jPanelStyle.setLayout(this.borderLayout7);
        this.jPanel3.setLayout(this.borderLayout9);
        this.jPanel7.setLayout(this.gridLayout8);
        this.gridLayout8.setColumns(1);
        this.gridLayout8.setRows(4);
        this.jCheckBoxTOCCreate.setToolTipText("Create a TOC if selected");
        this.jCheckBoxTOCCreate.setText("Create TOC.htm, Template = ");
        this.jPanel1.setLayout(this.borderLayout8);
        this.jPanel8.setLayout(this.gridLayout7);
        this.gridLayout7.setRows(4);
        this.jPanel3.setBorder(this.titledBorder5);
        this.jCheckBoxTemplateBody.setToolTipText("If unselected, the source file template is used");
        this.jCheckBoxTemplateBody.setText("Body Template");
        this.jCheckBoxTemplateHeader.setToolTipText("If unselected, no header is generated");
        this.jCheckBoxTemplateHeader.setText("Header Template     ");
        this.jCheckBoxTemplateFooter.setToolTipText("If unselected, no footer is generated");
        this.jCheckBoxTemplateFooter.setText("Footer Template");
        this.jTextAreaReport.setToolTipText("Drop in the HTML file to be splitted");
        this.jTextFieldTemplateBodyFile.setToolTipText("File Name of the Template, if empty, the default template is used");
        this.jTextFieldTemplateHeaderFile.setToolTipText("File Name of the Template, if empty, the default template is used");
        this.jTextFieldTemplateFooterFile.setToolTipText("File Name of the Template, if empty, the default template is used");
        this.jTextFieldTemplateTOCFile.setToolTipText("File Name of the Template, if empty, the default template is used");
        this.jCheckBoxTemplateTransition.setToolTipText("If unselected, no footer is generated");
        this.jCheckBoxTemplateTransition.setText("Transition Template");
        this.jTextFieldTemplateTransitionFile.setToolTipText("File Name of the Template, if empty, the default template is used");
        this.jPanel9.setLayout(this.borderLayout10);
        this.jCheckBoxLowerCase.setToolTipText("Use lowercase letters for file names of generated web pages");
        this.jCheckBoxLowerCase.setText("Lowercase Names  |  Page Extension = ");
        this.jTextFieldPageExtension.setToolTipText("File extension of generated web pages");
        this.jMenuFile.add(this.jMenuItemOpenHtml);
        this.jMenuFile.add(this.jMenuItemSplit);
        this.jMenuFile.add(this.jMenuItemConfigSave);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuItemHelpContent);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuHelp);
        this.contentPane.add((Component)this.jPanelStatusBar, "South");
        this.jPanelStatusBar.add((Component)this.jLabelStatusBar, "Center");
        this.contentPane.add((Component)this.jTabbedPane0, "Center");
        this.jTabbedPane0.add((Component)this.jPanelDropIn, "Drop In");
        this.jPanelDropIn.add((Component)this.jScrollPaneReport, "Center");
        this.jScrollPaneReport.getViewport().add((Component)this.jTextAreaReport, null);
        this.jTabbedPane0.add((Component)this.jPanelConfigSplit, "Slice Setup");
        this.setJMenuBar(this.jMenuBar1);
        this.jTabbedPane0.add((Component)this.jPanelTOC, "TOC Setup");
        this.jPanelConfigSplit.add((Component)this.jPanelSplitAt, "North");
        this.jPanelSplitAt.add((Component)this.jPanelSplit, null);
        this.jPanelSplit.add((Component)this.jRadioButtonSplitH1, null);
        this.jPanelSplit.add((Component)this.jLabel2, null);
        this.jPanelSplit.add((Component)this.jRadioButtonSplitH2, null);
        this.jPanelSplit.add((Component)this.jLabel1, null);
        this.jPanelSplit.add((Component)this.jRadioButtonSplitH3, null);
        this.jPanelSplitAt.add((Component)this.jPanelNaming, null);
        this.jPanelNaming.add((Component)this.jPanel5, null);
        this.jPanel5.add((Component)this.jCheckBoxLowerCase, "West");
        this.jPanel5.add((Component)this.jTextFieldPageExtension, "Center");
        this.jPanelNaming.add((Component)this.jPanel4, null);
        this.jPanelNaming.add((Component)this.jPanel9, null);
        this.jPanelTOC.add((Component)this.jPanel2, "North");
        this.jPanel2.add((Component)this.jPanel6, null);
        this.jPanel6.add((Component)this.jCheckBoxJavaHelp, null);
        this.jPanel6.add((Component)this.jPanel1, null);
        this.jPanel1.add((Component)this.jCheckBoxTOCCreate, "West");
        this.jPanel1.add((Component)this.jTextFieldTemplateTOCFile, "Center");
        this.jTabbedPane0.add((Component)this.jPanelStyle, "Style Setup");
        this.jPanelStyle.add((Component)this.jPanel3, "North");
        this.jPanel3.add((Component)this.jPanel7, "West");
        this.jPanel7.add((Component)this.jCheckBoxTemplateBody, null);
        this.jPanel7.add((Component)this.jCheckBoxTemplateHeader, null);
        this.jPanel7.add((Component)this.jCheckBoxTemplateFooter, null);
        this.jPanel7.add((Component)this.jCheckBoxTemplateTransition, null);
        this.jPanel3.add((Component)this.jPanel8, "Center");
        this.jPanel8.add((Component)this.jTextFieldTemplateBodyFile, null);
        this.jPanel8.add((Component)this.jTextFieldTemplateHeaderFile, null);
        this.jPanel8.add((Component)this.jTextFieldTemplateFooterFile, null);
        this.jPanel8.add((Component)this.jTextFieldTemplateTransitionFile, null);
        this.jTextAreaReport.setDropTarget(new DropTarget(this.jTextAreaReport, new FileDropTarget(this, this)));
        this.buttonGroupSplit.add(this.jRadioButtonSplitH1);
        this.buttonGroupSplit.add(this.jRadioButtonSplitH2);
        this.buttonGroupSplit.add(this.jRadioButtonSplitH3);
    }

    public void jMenuFileExit_actionPerformed(ActionEvent ee) {
        System.exit(0);
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        JFrameHSplitter_AboutBox dlg = new JFrameHSplitter_AboutBox(this);
        Dimension dlgSize = dlg.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        ((Component)dlg).setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        dlg.setModal(true);
        dlg.show();
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.jMenuFileExit_actionPerformed(null);
        }
    }

    void jMenuItemOpenHtml_actionPerformed(ActionEvent ee) {
        JFileChooser fileChoose = new JFileChooser();
        Frame parent = (Frame)this.getParent();
        int returnVal = fileChoose.showOpenDialog(parent);
        if (returnVal == 0) {
            File filePath = fileChoose.getSelectedFile();
            this.getFile(filePath);
        }
    }

    void jMenuItemSplit_actionPerformed(ActionEvent ee) {
        this.jLabelStatusBar.setText("INFO: Splitting Html");
        this.updateConfig();
        boolean OK = this.logic.splitHtml();
        if (OK) {
            this.jLabelStatusBar.setText("INFO: Splitting Ended");
        } else {
            this.jLabelStatusBar.setText("ERR: Splitting Error");
        }
    }

    void jMenuItemConfigSave_actionPerformed(ActionEvent ee) {
        Config config = this.logic.getConfig();
        this.updateConfig();
        boolean OK = config.save();
        if (OK) {
            this.jLabelStatusBar.setText("INFO: Config Saved");
        } else {
            this.jLabelStatusBar.setText("ERR: Config Error");
        }
    }

    void jMenuItemHelpContent_actionPerformed(ActionEvent ee) {
        Help hp = Help.getHelp(1);
        hp.display("introduction");
    }

    private void getFile(File fil) {
        if (fil == null) {
            this.jLabelStatusBar.setText("ERR: Select only one file");
            this.setTitle(productName);
            this.jMenuItemSplit.setEnabled(false);
        } else if (fil.isDirectory()) {
            this.jLabelStatusBar.setText("ERR: The file should not be a sirectory");
            this.setTitle(productName);
            this.jMenuItemSplit.setEnabled(false);
        } else {
            this.setTitle("HTMLslicer -- ".concat(String.valueOf(String.valueOf(fil.getAbsolutePath()))));
            this.updateConfig();
            int result = this.logic.setAndTestHtmlFile(fil);
            switch (result) {
                case 0: {
                    this.jLabelStatusBar.setText("INFO: Got file = ".concat(String.valueOf(String.valueOf(fil.getName()))));
                    System.out.println("INFO: Got file = ".concat(String.valueOf(String.valueOf(fil.getName()))));
                    this.jMenuItemSplit.setEnabled(true);
                    if (this.logger != null) {
                        this.logger.close();
                    }
                    this.logger = Logger.getLogger(new File(fil.getParent(), "JHSplitterLog.txt"), false);
                    this.logger.open();
                    this.logger.setLogLevel(4);
                    break;
                }
                case 1: {
                    this.jLabelStatusBar.setText("ERR: Not a file = ".concat(String.valueOf(String.valueOf(fil.getName()))));
                    this.jMenuItemSplit.setEnabled(false);
                    break;
                }
                case 2: {
                    this.jLabelStatusBar.setText("ERR: A non-text file = ".concat(String.valueOf(String.valueOf(fil.getName()))));
                    this.jMenuItemSplit.setEnabled(false);
                    break;
                }
                case 3: {
                    this.jLabelStatusBar.setText("ERR: A non-html file = ".concat(String.valueOf(String.valueOf(fil.getName()))));
                    this.jMenuItemSplit.setEnabled(false);
                    break;
                }
                case 4: {
                    this.jLabelStatusBar.setText("WARN: A bad-html file = ".concat(String.valueOf(String.valueOf(fil.getName()))));
                    this.jMenuItemSplit.setEnabled(true);
                }
            }
        }
        this.jTextAreaReport.setText("");
    }

    private void updateConfig() {
        Config config = this.logic.getConfig();
        if (this.jRadioButtonSplitH1.isSelected()) {
            config.splitLevel = 1;
        } else if (this.jRadioButtonSplitH2.isSelected()) {
            config.splitLevel = 2;
        } else if (this.jRadioButtonSplitH3.isSelected()) {
            config.splitLevel = 3;
        }
        config.doTOC = this.jCheckBoxTOCCreate.isSelected();
        config.doJavaHelpMeta = this.jCheckBoxJavaHelp.isSelected();
        config.tocTemplateFileName = this.jTextFieldTemplateTOCFile.getText();
        config.bodyTemplateFileName = this.jTextFieldTemplateBodyFile.getText();
        config.headerTemplateFileName = this.jTextFieldTemplateHeaderFile.getText();
        config.footerTemplateFileName = this.jTextFieldTemplateFooterFile.getText();
        config.transitionTemplateFileName = this.jTextFieldTemplateTransitionFile.getText();
        config.useBodyTemplate = this.jCheckBoxTemplateBody.isSelected();
        config.useHeaderTemplate = this.jCheckBoxTemplateHeader.isSelected();
        config.useFooterTemplate = this.jCheckBoxTemplateFooter.isSelected();
        config.useTransitionTemplate = this.jCheckBoxTemplateTransition.isSelected();
        config.useLowerCaseOnly = this.jCheckBoxLowerCase.isSelected();
        config.pageExtension = this.jTextFieldPageExtension.getText();
    }

    private void updateConfigDisplay() {
        Config config = this.logic.getConfig();
        if (config.splitLevel == 1) {
            this.jRadioButtonSplitH1.setSelected(true);
        } else if (config.splitLevel == 2) {
            this.jRadioButtonSplitH2.setSelected(true);
        } else if (config.splitLevel == 3) {
            this.jRadioButtonSplitH3.setSelected(true);
        }
        this.jCheckBoxTOCCreate.setSelected(config.doTOC);
        if (config.doJavaHelpMeta) {
            this.jCheckBoxJavaHelp.setSelected(true);
        } else {
            this.jCheckBoxJavaHelp.setSelected(false);
        }
        this.jTextFieldTemplateTOCFile.setText(config.tocTemplateFileName);
        this.jTextFieldTemplateBodyFile.setText(config.bodyTemplateFileName);
        this.jTextFieldTemplateHeaderFile.setText(config.headerTemplateFileName);
        this.jTextFieldTemplateFooterFile.setText(config.footerTemplateFileName);
        this.jTextFieldTemplateTransitionFile.setText(config.transitionTemplateFileName);
        this.jCheckBoxTemplateBody.setSelected(config.useBodyTemplate);
        this.jCheckBoxTemplateHeader.setSelected(config.useHeaderTemplate);
        this.jCheckBoxTemplateFooter.setSelected(config.useFooterTemplate);
        this.jCheckBoxTemplateTransition.setSelected(config.useTransitionTemplate);
        this.jCheckBoxLowerCase.setSelected(config.useLowerCaseOnly);
        this.jTextFieldPageExtension.setText(config.pageExtension);
    }

    public void progressReported(HSplitLogic.ProgressEvent ev) {
        String msg = ev.getMessage();
        int action = ev.getAction();
        int nbLines = 0;
        boolean autoScroll = false;
        if (action == 1) {
            nbLines = 0;
            this.jTextAreaReport.setText("STARTED \n");
            if (!msg.equals("")) {
                this.jTextAreaReport.append(String.valueOf(String.valueOf(msg)).concat("\n"));
            }
        } else if (action == 2) {
            this.jTextAreaReport.append("ENDED  \n");
            if (autoScroll) {
                JScrollBar sb = this.jScrollPaneReport.getVerticalScrollBar();
                int max = sb.getMaximum();
                sb.setValue(max);
            }
            this.logger.logASpaceLine();
            this.logger.logInfo("----------------------------------------------------------");
            this.logger.logASpaceLine();
            this.logger.log(4, true, "PROGRESS REPORT");
            this.logger.logInfo(this.jTextAreaReport.getText());
            this.logger.logInfo("==========================================================");
            this.logger.logASpaceLine();
        } else if (action == 3) {
            this.jTextAreaReport.append(String.valueOf(String.valueOf(msg)).concat("\n"));
            if (++nbLines >= 16) {
                this.jTextArea1.setRows(nbLines);
            }
            if (this.jTextAreaReport.getColumns() < msg.length()) {
                this.jTextAreaReport.setColumns(msg.length() + 1);
            }
            this.jTextAreaReport.revalidate();
            if (autoScroll) {
                JScrollBar sb = this.jScrollPaneReport.getVerticalScrollBar();
                int max = sb.getMaximum();
                sb.setValue(max);
            }
        }
    }

    static Class class$(String x$0) {
        try {
            return Class.forName(x$0);
        }
        catch (ClassNotFoundException x$02) {
            throw new NoClassDefFoundError(x$02.getMessage());
        }
    }

    static {
        DEBUG = true;
        productName = productName;
    }

    class FileDropTarget
    implements DropTargetListener {
        JFrameHSplitter cmpt;

        public FileDropTarget(JFrameHSplitter this$0, JFrameHSplitter cmpt) {
            this.cmpt = cmpt;
        }

        public void dragEnter(DropTargetDragEvent e) {
            e.acceptDrag(1);
        }

        public void dragOver(DropTargetDragEvent e) {
            e.acceptDrag(1);
        }

        public void dragExit(DropTargetEvent e) {
        }

        public void drop(DropTargetDropEvent e) {
            DropTargetContext targetContext = e.getDropTargetContext();
            boolean outcome = false;
            boolean isAnArray = false;
            if ((e.getSourceActions() & 1) == 0) {
                e.rejectDrop();
                return;
            }
            e.acceptDrop(1);
            DataFlavor[] dataFlavors = e.getCurrentDataFlavors();
            DataFlavor transferDataFlavor = null;
            for (int i = 0; i < dataFlavors.length; ++i) {
                if (!DataFlavor.javaFileListFlavor.equals(dataFlavors[i])) continue;
                transferDataFlavor = dataFlavors[i];
                isAnArray = true;
                break;
            }
            if (transferDataFlavor != null) {
                Transferable tt = e.getTransferable();
                Object is = null;
                List alist = null;
                Object as = null;
                Object iis = null;
                try {
                    if (isAnArray) {
                        alist = (List)tt.getTransferData(transferDataFlavor);
                        if (alist.size() > 1) {
                            this.cmpt.getFile(null);
                        } else {
                            File fil = new File(alist.get(0).toString());
                            if (fil.isFile()) {
                                this.cmpt.getFile(fil);
                            } else {
                                this.cmpt.getFile(new File(File.separator));
                            }
                        }
                    }
                }
                catch (IOException ioe) {
                    System.err.println(ioe.getMessage());
                    targetContext.dropComplete(false);
                    return;
                }
                catch (UnsupportedFlavorException ufe) {
                    System.err.println(ufe.getMessage());
                    targetContext.dropComplete(false);
                    return;
                }
            }
            targetContext.dropComplete(outcome);
        }

        public void dragScroll(DropTargetDragEvent e) {
        }

        public void dropActionChanged(DropTargetDragEvent e) {
        }
    }
}

