/*
 * Decompiled with CFR 0.152.
 */
package jfr.util;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;
import jfr.util.AlphabetIncompatible;
import jfr.util.AlphabetOutOfRange;
import jfr.util.StackInputStream;

public class Alphabet {
    protected static int max_value = 255;
    protected static int min_value = 0;
    protected static int capacity = max_value - min_value;
    protected static BitSet empty_alphabet = new BitSet(capacity);
    protected static BitSet full_alphabet = new BitSet(capacity);
    protected BitSet buffer;

    public Alphabet() {
        this.buffer = new BitSet(capacity);
    }

    public Alphabet(char c) throws AlphabetOutOfRange {
        char v = c;
        if (v > max_value || v < min_value) {
            throw new AlphabetOutOfRange();
        }
        this.buffer = new BitSet(capacity);
        this.buffer.set(v);
    }

    public Alphabet(char c_start, char c_end) throws AlphabetOutOfRange {
        int i;
        int v_start = c_start;
        int v_end = c_end;
        if (v_start > v_end) {
            i = v_start;
            v_start = v_end;
            v_end = i;
        }
        if (v_start > max_value || v_start < min_value || v_end > max_value) {
            throw new AlphabetOutOfRange();
        }
        this.buffer = new BitSet(capacity);
        i = v_start;
        while (i <= v_end) {
            this.buffer.set(i);
            ++i;
        }
    }

    public Alphabet(String s) throws AlphabetOutOfRange {
        this.buffer = new BitSet(capacity);
        int i = 0;
        while (i < s.length()) {
            char v = s.charAt(i);
            if (v > max_value || v < min_value) {
                throw new AlphabetOutOfRange();
            }
            this.buffer.set(v);
            ++i;
        }
    }

    public Alphabet(Alphabet a) throws AlphabetIncompatible {
        if (min_value != min_value || max_value != max_value) {
            throw new AlphabetIncompatible();
        }
        this.buffer = (BitSet)a.buffer.clone();
    }

    public Alphabet add(char c) throws AlphabetOutOfRange {
        char v = c;
        if (v > max_value || v < min_value) {
            throw new AlphabetOutOfRange();
        }
        this.buffer.set(v);
        return this;
    }

    public Alphabet add(char c_start, char c_end) throws AlphabetOutOfRange {
        int i;
        int v_start = c_start;
        int v_end = c_end;
        if (v_start > v_end) {
            i = v_start;
            v_start = v_end;
            v_end = i;
        }
        if (v_start > max_value || v_start < min_value || v_end > max_value) {
            throw new AlphabetOutOfRange();
        }
        i = v_start;
        while (i <= v_end) {
            this.buffer.set(i);
            ++i;
        }
        return this;
    }

    public Alphabet add(String s) throws AlphabetOutOfRange {
        int i = 0;
        while (i < s.length()) {
            char v = s.charAt(i);
            if (v > max_value || v < min_value) {
                throw new AlphabetOutOfRange();
            }
            this.buffer.set(v);
            ++i;
        }
        return this;
    }

    public Alphabet add(Alphabet a) throws AlphabetIncompatible {
        if (min_value != min_value || max_value != max_value) {
            throw new AlphabetIncompatible();
        }
        this.buffer.or(a.buffer);
        return this;
    }

    public Alphabet sub(char c) throws AlphabetOutOfRange {
        char v = c;
        if (v > max_value || v < min_value) {
            throw new AlphabetOutOfRange();
        }
        this.buffer.clear(v);
        return this;
    }

    public Alphabet sub(char c_start, char c_end) throws AlphabetOutOfRange {
        int i;
        int v_start = c_start;
        int v_end = c_end;
        if (v_start > v_end) {
            i = v_start;
            v_start = v_end;
            v_end = i;
        }
        if (v_start > max_value || v_start < min_value || v_end > max_value) {
            throw new AlphabetOutOfRange();
        }
        i = v_start;
        while (i <= v_end) {
            this.buffer.clear(i);
            ++i;
        }
        return this;
    }

    public Alphabet sub(String s) throws AlphabetOutOfRange {
        int i = 0;
        while (i < s.length()) {
            char v = s.charAt(i);
            if (v > max_value || v < min_value) {
                throw new AlphabetOutOfRange();
            }
            this.buffer.clear(v);
            ++i;
        }
        return this;
    }

    public Alphabet sub(Alphabet a) throws AlphabetIncompatible {
        if (min_value != min_value || max_value != max_value) {
            throw new AlphabetIncompatible();
        }
        Alphabet a_inv = new Alphabet(a);
        a_inv.invert();
        this.buffer.and(a_inv.buffer);
        return this;
    }

    public boolean contains(char c) {
        char v = c;
        if (v > max_value || v < min_value) {
            return false;
        }
        return this.buffer.get(v);
    }

    public boolean contains(char c_start, char c_end) {
        int i;
        int v_start = c_start;
        int v_end = c_end;
        if (v_start > v_end) {
            i = v_start;
            v_start = v_end;
            v_end = i;
        }
        if (v_start > max_value || v_start < min_value || v_end > max_value) {
            return false;
        }
        i = v_start;
        while (i <= v_end) {
            if (!this.buffer.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(String s) {
        int i = 0;
        while (i < s.length()) {
            char v = s.charAt(i);
            if (v > max_value || v < min_value || !this.buffer.get(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean contains(Alphabet a) throws AlphabetIncompatible {
        if (min_value != min_value || max_value != max_value) {
            throw new AlphabetIncompatible();
        }
        int i = min_value;
        while (i <= max_value) {
            if (a.buffer.get(i) && !this.buffer.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean disjointed(String s) {
        int i = 0;
        while (i < s.length()) {
            char v = s.charAt(i);
            if (v <= max_value && v >= min_value && this.buffer.get(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Alphabet clear() {
        this.buffer.and(empty_alphabet);
        return this;
    }

    public Alphabet invert() {
        this.buffer.xor(full_alphabet);
        return this;
    }

    public String span(StackInputStream in, DataOutputStream out) throws IOException {
        StringBuffer result = new StringBuffer();
        int v = in.read();
        char c = (char)v;
        while (v != -1 && this.contains(c)) {
            result.append(c);
            v = in.read();
            c = (char)v;
        }
        in.pushBack(v);
        String result_string = result.toString();
        if (out != null) {
            out.writeBytes(result_string);
        }
        return result_string;
    }

    public String span(StackInputStream in) throws IOException {
        return this.span(in, null);
    }

    public String span(String source) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (!this.contains(c)) break;
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public String spanBackAndRemove(StringBuffer source) {
        if (source == null) {
            return "";
        }
        int source_length = source.length();
        if (source_length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int i = source_length - 1;
        while (i >= 0) {
            char c = source.charAt(i);
            if (!this.contains(c)) break;
            result.append(c);
            --i;
        }
        if (result.length() > 0) {
            source.setLength(source_length - result.length());
        }
        return result.toString();
    }

    public int skip(StackInputStream in, DataOutputStream out) throws IOException {
        int v = in.read();
        char c = (char)v;
        while (v != -1 && this.contains(c)) {
            if (out != null) {
                out.writeByte(v);
            }
            v = in.read();
            c = (char)v;
        }
        in.pushBack(v);
        return v;
    }

    public int skip(StackInputStream in) throws IOException {
        return this.skip(in, null);
    }

    public int skipBack(StringBuffer in, DataOutputStream out) throws IOException {
        int v = Alphabet.readFromEnd(in);
        char c = (char)v;
        while (v != -1 && this.contains(c)) {
            if (out != null) {
                out.writeByte(v);
            }
            v = Alphabet.readFromEnd(in);
            c = (char)v;
        }
        in.append(c);
        return v;
    }

    public int skipBack(StringBuffer in) throws IOException {
        return this.skipBack(in, null);
    }

    public String trimLeft(String source) {
        int i = 0;
        while (i < source.length()) {
            if (!this.contains(source.charAt(i))) {
                return source.substring(i);
            }
            ++i;
        }
        return "";
    }

    public String trimRight(String source) {
        int source_length = source.length();
        if (source_length == 0) {
            return source;
        }
        int i = source.length() - 1;
        while (i >= 0) {
            if (!this.contains(source.charAt(i))) {
                return source.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }

    public String trim(String source) {
        int source_length = source.length();
        if (source_length == 0) {
            return source;
        }
        int start_index = 0;
        int i = 0;
        while (i < source.length()) {
            if (!this.contains(source.charAt(i))) {
                start_index = i;
                break;
            }
            ++i;
        }
        int end_index = 0;
        i = source.length() - 1;
        while (i >= 0) {
            if (!this.contains(source.charAt(i))) {
                end_index = i + 1;
                break;
            }
            --i;
        }
        return end_index <= start_index ? "" : source.substring(start_index, end_index);
    }

    public String clean(String source) {
        StringBuffer result = new StringBuffer();
        int source_length = source.length();
        int i = 0;
        while (i < source_length) {
            char c = source.charAt(i);
            if (!this.contains(c)) {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public String clean(String source, char replacement) {
        StringBuffer result = new StringBuffer();
        int source_length = source.length();
        int i = 0;
        while (i < source_length) {
            char c = source.charAt(i);
            if (this.contains(c)) {
                c = replacement;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }

    public static int readFromEnd(StringBuffer str) {
        int str_length = str.length();
        if (str_length <= 0) {
            return -1;
        }
        char c = str.charAt(str_length - 1);
        str.setLength(str_length - 1);
        return c;
    }

    static {
        int i = min_value;
        while (i < max_value) {
            full_alphabet.set(i);
            ++i;
        }
    }
}

