#include "defn.h"

/*
 * line3d was dervied from DigitalLine.c published as "Digital Line Drawing"
 * by Paul Heckbert from "Graphics Gems", Academic Press, 1990
 *
 * 3D modifications by Bob Pendleton. The original source code was in the public
 * domain, the author of the 3D version places his modifications in the
 * public domain as well.
 *
 * line3d uses Bresenham's algorithm to generate the 3 dimensional points on a
 * line from (x1, y1, z1) to (x2, y2, z2)
 *
 */

 //microstepping with SMC800/SNC1500 Conrad card
const unsigned char motor_array[16] = {0x27,0x2E,0x2D,0x35,0x1C,0x15,0x0D,0x0E,0x03,0x0A,0x09,0x11,0x38,0x31,0x29,0x2A};
//normalstepping with SMC800/SMC1500 Conrad card
//const unsigned char motor_array[8] = {0x27,0x2D,0x1C,0x0D,0x03,0x09,0x38,0x29};
//normal sequence like in conrad smcmot.c example

/* find maximum of a and b */
#define MAX(a,b) (((a)>(b))?(a):(b))

/* absolute value of a */
#define ABS(a) (((a)<0) ? -(a) : (a))

/* take sign of a, either -1, 0, or 1 */
#define ZSGN(a) (((a)<0) ? -1 : (a)>0 ? 1 : 0)

point3d(long x, long y, long z)
{
if((inp(0x64)&32)==0){      // ps2 mouse error check if this is a mouse or keyboard
   if((inp(0x60))==1){      // 1 = escape key pressed
		step_output=0;	
		MTButtonSetActivationStatus(toggle_output_onoff,0);
   }
}
   


if(step_output==1){				//stepoutput toggle/checkbox is on
	
	

/*************************************/
/*      SMC800/1500 Control          */
/*************************************/
	if(output_type==0){    		
		MpointerX=MpointerX+(x-point3doldX);   	// mpointerx +1 or 0 or -1 depending of direction
		if (MpointerX > 15)MpointerX = 0;      	// the array = 16 so mpointer must be 0 to 15
		if (MpointerX < 0)MpointerX = 15;

		MpointerY=MpointerY+(y-point3doldY);   	// mpointery +1 or 0 or -1 depending of direction
		if (MpointerY > 15)MpointerY = 0;      	// the array = 16 so mpointer must be 0 to 15
		if (MpointerY < 0)MpointerY = 15;

		if(x< hardwarelimitx/tableresX){       	// clipping if product-plotscale is bigger as tablelimits
			outp(_LPT,motor_array[MpointerX]);
			Wait_Time(55/*119*/);   			// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
											// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
			outp(_LPT+2, 1);  					// strobe data ubername/perform
			outp(_LPT+2, 0);  					// strobe data ubername/perform
		}
		if(y<hardwarelimity/tableresY){        	// clipping if product-plotscale is bigger as tablelimits
			outp(_LPT,motor_array[MpointerY]+64);
			Wait_Time(55/*119*/);   			// Impulsbreite delay = 100 s (1/(18.3*65536)) * 119 = 100 uS
							 				// 8253 timer 1,1931182Mhz counts (18.3*65536) each second=1.199.309 tics each second
			outp(_LPT+2, 1);  					// strobe data ubername/perform
			outp(_LPT+2, 0);  					// strobe data ubername/perform
		}

	}
	


/*************************/
/*    Phase Control      */
/*************************/
	if(output_type==1){        					// 1=phase control like uln2803 example
		//HALFSTEP SEQUENCE
		const unsigned char x_motor_array[8]={1,3,2,6,4,12,8,9};          // for phase control uln2803 example
		const unsigned char y_motor_array[8]={16,48,32,96,64,192,128,144};// This is a halfstep sequence
		const unsigned char z_motor_array[8]={1,3,2,6,4,12,8,9};          // for phase control uln2803 example
		//FULLSTEP SEQUENCE
		//const unsigned char x_motor_array[4]={1,2,4,8};
		//const unsigned char y_motor_array[4]={16,32,64,128};
		//const unsigned char z_motor_array[4]={1,2,4,8};
		//FULLSTEP DOUBLE COIL SEQUENCE
		//const unsigned char x_motor_array[4]={3,6,12,9};
		//const unsigned char y_motor_array[4]={48,96,192,144};
		//const unsigned char z_motor_array[4]={3,6,12,9};

		MpointerX=MpointerX+(x-point3doldX);   						// mpointerx +1 or 0 or -1 depending of direction
		if (MpointerX > 7)MpointerX = 0;
		if (MpointerX < 0)MpointerX = 7;

		MpointerY=MpointerY+(y-point3doldY);   						// mpointery +1 or 0 or-1 depending of direction
		if (MpointerY > 7)MpointerY = 0;
		if (MpointerY < 0)MpointerY = 7;

		if(x< hardwarelimitx/tableresX)outxval=x_motor_array[MpointerX];	// clipping if product-plotscale is bigger as tablelimits
		if(y< hardwarelimity/tableresY)outyval=y_motor_array[MpointerY];	// clipping if product-plotscale is bigger as tablelimits

		outp(_LPT,outxval + outyval);

	}





/************************************/
/*      Pulse&Direction Control     */
/************************************/
	if(output_type==2){       										// pulse and direction output type
 
		if(x-point3doldX==1) xdirection=xdirval;  else xdirection=0;
		if(y-point3doldY==1) ydirection=ydirval;  else ydirection=0;

		outp(_LPT, xdirection+ydirection);
		Wait_Time(2);   			

		if(x-point3doldX==1 || x-point3doldX==-1)xstep=xstepval;  else xstep=0;
		if(y-point3doldY==1 || y-point3doldY==-1)ystep=ystepval;  else ystep=0;

																// x and y whitin limit 
  																// clipping if product-plotscale is bigger as tablelimits
          if((x<hardwarelimitx/tableresX)&&(y<hardwarelimity/tableresY)){    
			outp(_LPT, xdirection+xstep+ydirection+ystep);
			Wait_Time(2);   		
			outp(_LPT, xdirection+ydirection);
		}
																// x outside limit  
																// clipping if product-plotscale is bigger as tablelimits
		if((x>hardwarelimitx/tableresX)&&(y<hardwarelimity/tableresY)){    
			outp(_LPT, ydirection+ystep);
			Wait_Time(2);   			
			outp(_LPT, xdirection+ydirection);
		}
																// y outside limit 	
																// clipping if product-plotscale is bigger as tablelimits
          if((x<hardwarelimitx/tableresX)&&(y>hardwarelimity/tableresY)){     
			outp(_LPT, xdirection+xstep );
			Wait_Time(2);   			
			outp(_LPT, xdirection+ydirection);
		}
	
	}   





		// next is a simple RAMPUP-RAMPDOWN accelerate-deccelerate
		if (abs(newX - point3doldX) >= abs(newY - point3doldY)){  	// x relative is bigger
		   if (abs(newX - point3doldX) <= 250) goto rampdown;     	// if x togo smaller as 250 then slowdown
		}
		if (abs(newX - point3doldX) <= abs(newY - point3doldY)){  	// y relative is bigger
		   if (abs(newY - point3doldY) <= 250) goto rampdown;    		// if y togo smaller as 250 then slowdown
		}

		if(x >= ((hardwarelimitx / tableresX) - 250)) goto rampdown;	// rampdown before reaching tablelimit x
		if(y >= ((hardwarelimity / tableresY) - 250)) goto rampdown;	// rampdown before reaching tablelimit y

		goto rampup;    										// if above is not treu do not perform rampdown

		rampdown:
			stepdelay+=4;				   						// speeddown rampdown

			if (stepdelay>startdelay)stepdelay=startdelay;
			goto jumpoverrampup;

		rampup:
		if (stepdelay > enddelay){			   					// rampup
			stepdelay-=3;  				   					// speed up
								   							// if startdelay greater as enddelay
			if(stepdelay < enddelay)stepdelay=enddelay;				// not faster as enddelay
		}
		jumpoverrampup:

		// Perform rampup or rampdown or run delaytime
		Wait_Time(stepdelay);



}//end if stepoutput is on




		if((x>hardwarelimitx/tableresX) || (y>hardwarelimity/tableresY)){
			stepdelay=startdelay=pendownstartdelay;     			// when within limits again start with a low startspeed
			pencolor=red;
		}else if(PENDOWN){
			pencolor=blue;
		}else if(!PENDOWN){
			pencolor=gray;
		}

		if(PENDOWN){
			MDrawPoint(drawarea,(x*tableresX)*screenscale,maxy-(y*tableresY)*screenscale,pencolor); //draw a pixel on screen at current xy location Pendowncolor
		}
		else{
			if(penuplines==1)MDrawPoint(drawarea,(x*tableresX)*screenscale,maxy-(y*tableresY)*screenscale,pencolor);   //draw a pixel on screen at current xy location PenUpcolor
		}

		point3doldX=x;
		point3doldY=y;


}




/*******************************/
/*            LINE3D           */
/*******************************/
line3d(long x1, long y1, long x2, long y2, long z1, long z2)
{
	 long xd, yd, zd;
	 long x, y, z;
	 long ax, ay, az;
	 int sx, sy, sz;
	 long dx, dy, dz;

	 dx = x2 - x1;
	 dy = y2 - y1;
	 dz = z2 - z1;

	 ax = ABS(dx) << 1;
	 ay = ABS(dy) << 1;
	 az = ABS(dz) << 1;

	 sx = ZSGN(dx);
	 sy = ZSGN(dy);
	 sz = ZSGN(dz);

	 x = x1;
	 y = y1;
	 z = z1;

	 if (ax >= MAX(ay, az))            /* x dominant */
	 {
		  yd = ay - (ax >> 1);
		  zd = az - (ax >> 1);
		  for (;;)
		  {
				point3d(x, y, z);		//doit

				if (x == x2)
				{
					 return;
				}

				if (yd >= 0)
				{
					 y += sy;     	//y +1 or 0 or -1
					 yd -= ax;
				}

				if (zd >= 0)
				{
					 z += sz;   	//z +1 or 0 or -1
					 zd -= ax;
				}

				x += sx;          	//x +1 or 0 or -1
				yd += ay;
				zd += az;
		  }
	 }
	 else if (ay >= MAX(ax, az))            /* y dominant */
	 {
		  xd = ax - (ay >> 1);
		  zd = az - (ay >> 1);
		  for (;;)
		  {
				point3d(x, y, z);  //doit

				if (y == y2)
				{
					 return;
				}

				if (xd >= 0)
				{
					 x += sx;   	//x +1 or 0 or -1
					 xd -= ay;

				}

				if (zd >= 0)
				{
					 z += sz;       //z +1 or 0 or -1
					 zd -= ay;
				}

				y += sy;    	       	//y +1 or 0 or -1
				xd += ax;
				zd += az;
		  }
	 }
	 else if (az >= MAX(ax, ay))            /* z dominant */
	 {
		  xd = ax - (az >> 1);
		  yd = ay - (az >> 1);
		  for (;;)
		  {
				point3d(x, y, z);	  //doit

				if (z == z2)
				{
					 return;
				}

				if (xd >= 0)
				{
					 x += sx; 	//x +1 or 0 or -1
					 xd -= az;
				}

				if (yd >= 0)
				{
					 y += sy;  	//y +1 or 0 or -1
					 yd -= az;
				}

				z += sz;             	//z +1 or 0 or -1
				xd += ax;
				yd += ay;
		  }
	 }
}



