/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.image.png;

import com.sixlegs.image.png.Chunk;
import com.sixlegs.image.png.PngException;
import com.sixlegs.image.png.PngExceptionSoft;
import java.io.IOException;

final class Chunk_sBIT
extends Chunk {
    protected boolean multipleOK() {
        return false;
    }

    protected boolean beforeIDAT() {
        return true;
    }

    protected void readData() throws IOException {
        byte[] byArray = null;
        if (this.img.data.palette != null) {
            throw new PngException("sBIT chunk must precede PLTE chunk");
        }
        int n = this.img.data.header.depth;
        switch (this.img.data.header.colorType) {
            case 0: {
                byArray = new byte[3];
                byArray[1] = byArray[2] = this.in_data.readByte();
                byArray[0] = byArray[2];
                break;
            }
            case 3: {
                n = 8;
            }
            case 2: {
                byArray = new byte[]{this.in_data.readByte(), this.in_data.readByte(), this.in_data.readByte()};
                break;
            }
            case 4: {
                byArray = new byte[4];
                byArray[1] = byArray[2] = this.in_data.readByte();
                byArray[0] = byArray[2];
                byArray[3] = this.in_data.readByte();
                break;
            }
            case 6: {
                byArray = new byte[]{this.in_data.readByte(), this.in_data.readByte(), this.in_data.readByte(), this.in_data.readByte()};
                break;
            }
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] <= 0 || byArray[n2] > n) {
                throw new PngExceptionSoft("Illegal sBIT component depth");
            }
            ++n2;
        }
        this.img.data.properties.put("significant bits", byArray);
    }

    Chunk_sBIT() {
        super(1933723988);
    }
}

