/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import com.l2fprod.util.ZipResourceLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipResourceLoader {
    Hashtable resources = new Hashtable();
    URLStreamHandler handler = new 1(this);

    public InputStream getResourceAsStream(String name) throws MalformedURLException, IOException {
        return this.getResource(name).openStream();
    }

    public URL getResource(String name) throws MalformedURLException {
        if (this.resources.get(name) == null) {
            return null;
        }
        return new URL("ziploader", null, -1, name, this.handler);
    }

    public ZipResource getZipResource(String name) {
        return new ZipResource(name);
    }

    public ZipResource getZipResource(URL name) {
        return this.getZipResource(name.getFile());
    }

    public Enumeration entries() {
        return this.resources.keys();
    }

    public void dump() {
        Enumeration e = this.resources.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.out.println(name + " size = " + ((byte[])this.resources.get(name)).length);
        }
    }

    public void release() {
        this.resources.clear();
        this.resources = null;
    }

    private final byte[] getURLContent(String name) {
        byte[] data = (byte[])this.resources.get(name);
        if (data == null && name.startsWith("/")) {
            data = (byte[])this.resources.get(name.substring(1));
        }
        return data;
    }

    public static void main(String[] args) throws Exception {
        ZipResourceLoader loader = new ZipResourceLoader(new File(args[0]).toURL());
        Enumeration e = loader.entries();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            System.out.println(name);
            URL url = loader.getResource(name);
            System.out.println(url);
            System.out.println(url.openStream());
            System.out.println(loader.getZipResource(name).getInputStream());
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZipResourceLoader(URL p_JarUrl) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(p_JarUrl.openStream());
        ZipInputStream input = new ZipInputStream(bis);
        ZipEntry entry = null;
        while ((entry = input.getNextEntry()) != null) {
            int read;
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
            while ((read = ((InflaterInputStream)input).read()) != -1) {
                void var6_6;
                outBuffer.write((int)var6_6);
            }
            this.resources.put(entry.getName(), outBuffer.toByteArray());
        }
    }

    public class ZipResource {
        String m_Name;

        public URL getURL() throws MalformedURLException {
            return new URL("http", null, -1, this.m_Name);
        }

        public InputStream getInputStream() {
            ByteArrayInputStream input = new ByteArrayInputStream(ZipResourceLoader.this.getURLContent(this.m_Name));
            return input;
        }

        public byte[] getURLContent() {
            return ZipResourceLoader.this.getURLContent(this.m_Name);
        }

        public ZipResource(String p_Name) {
            this.m_Name = p_Name;
        }
    }

    class ZipURLConnection
    extends URLConnection {
        public InputStream getInputStream() throws IOException {
            ByteArrayInputStream input = new ByteArrayInputStream((byte[])ZipResourceLoader.this.resources.get(this.getURL().getFile()));
            return input;
        }

        public void connect() throws IOException {
            if (ZipResourceLoader.this.resources == null || ZipResourceLoader.this.resources.get(this.getURL().getFile()) == null) {
                throw new IOException("No data for " + this.getURL());
            }
        }

        public ZipURLConnection(URL p_Url) {
            super(p_Url);
        }
    }
}

