void __fastcall TDesignForm::cmdDeleteClick(TObject*) {
  if (Tree->IsEditing()) return;
  TTreeNode* Node = Tree->Selected;
  if (!Node) return;
  char buf[512];
  sprintf(buf, "%s - %s", RMClassName(Node->Data),
                          RMName     (Node->Data));
  if (Application->MessageBox(buf, "Delete",
     MB_OKCANCEL | MB_ICONQUESTION | MB_APPLMODAL) != IDOK)
  return;
  cmdPasteRef->Enabled  = false;
  cmdPasteCopy->Enabled = false;
  MaterialForm->Manage(NULL);
  WrapForm->Manage(NULL);
  TextureForm->Manage(NULL);
  AssociativeDelete(Node);
  D3dView->Render();
  Changed();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdCopyClick(TObject*) {
  if (Tree->IsEditing()) return;
  CutMode = false;
  ClipboardNode = Tree->Selected;
  cmdPasteRef->Enabled  = true;
  //    :
  cmdPasteCopy->Enabled = !IsTexture(ClipboardNode->Data);
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdCutClick(TObject*) {
  if (Tree->IsEditing()) return;
  Tree->Selected->Cut = !Tree->Selected->Cut;
  CutMode = Tree->Selected->Cut;
  if (Tree->Selected->Cut) {
     ClipboardNode = Tree->Selected;
     cmdPasteCopy->Enabled = true;
  } else {
     ClipboardNode = NULL;
     cmdPasteCopy->Enabled = false;
  }
  cmdPasteRef->Enabled = false;
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdPasteCopyClick(TObject *) {
  if (Tree->IsEditing()) return;
  CloneMode = true;
  if (CutMode) PasteCut();
  else PasteCopied();
}//---------------------------------------------------------
void __fastcall TDesignForm::cmdPasteRefClick(TObject *) {
  if (Tree->IsEditing()) return;
  CloneMode = false;
  PasteCopied();
}//---------------------------------------------------------
void __fastcall TDesignForm::PasteCut() {
  if (!ClipboardNode) return;
  TTreeNode *DestNode = CurrentFrameNode();
  if (!DestNode) return;

  LPDIRECT3DRMFRAME IDstFrame = ASFRAME(DestNode->Data);

  if (IsFrame(ClipboardNode->Data)) {
     LPDIRECT3DRMFRAME Isf = ASFRAME(ClipboardNode->Data);
     TRY(IDstFrame->AddChild(Isf));
  }
  else
  if (IsLight(ClipboardNode->Data)) {
     LPDIRECT3DRMLIGHT Ilt = ASLIGHT(ClipboardNode->Data);
     TRY(IDstFrame->AddLight(Ilt));
  }
  else
  if (IsVisual(ClipboardNode->Data)) {
     LPDIRECT3DRMFRAME Isf =
                       ASFRAME(ClipboardNode->Parent->Data);
     LPDIRECT3DRMVISUAL Ivi = ASVISUAL(ClipboardNode->Data);
     if (Isf && Ivi) {
        TRY(IDstFrame->AddVisual(Ivi));
        TRY(Isf->DeleteVisual(Ivi));
     }
  }
  //    :
  ClipboardNode->MoveTo(DestNode, naAddChild);
  D3dView->Render();
  Changed();
}//---------------------------------------------------------
void __fastcall TDesignForm::PasteCopied() {
  if (!ClipboardNode) return;
  TTreeNode *DestNode = CurrentFrameNode();
  if (!DestNode) return;

  LPDIRECT3DRMFRAME IDstFrame = ASFRAME(DestNode->Data);

  AnsiString src_class = RMClassName(ClipboardNode->Data);
  if (src_class == "Frame") {
     LPDIRECT3DRMFRAME Isf = ASFRAME(ClipboardNode->Data);
     CopyFrame(IDstFrame, Isf, CloneMode);
     RebuildTree(this);
     D3dView->Render();
  }
  else
  if (IsVisual(ClipboardNode->Data)) {
     LPDIRECT3DRMVISUAL Ivis =ASVISUAL(ClipboardNode->Data);
     if (!CloneMode) {
        TRY(IDstFrame->AddVisual(Ivis)); //  
        Tree->Items->AddChildObject(DestNode,
                                 ClipboardNode->Text, Ivis);
     }
     else if (IsBuilder(Ivis)) {
        //  :
        LPDIRECT3DRMVISUAL Inewvis = NULL;
        Ivis->Clone(0, IID_IDirect3DRMVisual,
                                        (void **) &Inewvis);
        if (Inewvis) {
           //   :
           AnsiString newname = RMName(Ivis);
           newname += "_clone";
           Inewvis->SetName(newname.c_str());
           IDstFrame->AddVisual(Inewvis);
           Tree->Items->AddChildObject(DestNode, newname,
                                                   Inewvis);
           Ivis->Release();
        } // if (Ivis)
     } // if (CloneMode)
  } // if (IsVisual)
  D3dView->Render();
  Changed();
}//---------------------------------------------------------
