// DlgWinResize.cpp : implementation file
//

#include "stdafx.h"
#include "Win3DZ.h"
#include "DlgWinResize.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// DlgWinResize dialog


DlgWinResize::DlgWinResize(CWnd* pParent /*=NULL*/)
	: CDialog(DlgWinResize::IDD, pParent)
{
	//{{AFX_DATA_INIT(DlgWinResize)
	m_CustomCols = 640;
	m_CustomRows = 480;
	//}}AFX_DATA_INIT
	m_SizeMode = SIZE_CUSTOM;
	m_WinCols = 640;
	m_WinRows = 480;
}


void DlgWinResize::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(DlgWinResize)
	DDX_Text(pDX, IDC_EDIT_WINCOLS, m_CustomCols);
	DDX_Text(pDX, IDC_EDIT_WINROWS, m_CustomRows);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(DlgWinResize, CDialog)
	//{{AFX_MSG_MAP(DlgWinResize)
	ON_BN_CLICKED(IDC_RADIO_1024x768, OnRADIO1024x768)
	ON_BN_CLICKED(IDC_RADIO_1280x1024, OnRADIO1280x1024)
	ON_BN_CLICKED(IDC_RADIO_640x480, OnRADIO640x480)
	ON_BN_CLICKED(IDC_RADIO_800x600, OnRADIO800x600)
	ON_BN_CLICKED(IDC_RADIO_CUSTOM, OnRadioCustom)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// DlgWinResize message handlers

void DlgWinResize::OnRADIO640x480() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_640x480;
	m_WinCols = 640;
	m_WinRows = 480;
}

void DlgWinResize::OnRADIO800x600() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_800x600;
	m_WinCols = 800;
	m_WinRows = 600;
}

void DlgWinResize::OnRADIO1024x768() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_1024x768;
	m_WinCols = 1024;
	m_WinRows = 768;
}

void DlgWinResize::OnRADIO1280x1024() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_1280x1024;
	m_WinCols = 1280;
	m_WinRows = 1024;
}

void DlgWinResize::OnRadioCustom() 
{
	UpdateData(FALSE);
	m_SizeMode = SIZE_CUSTOM;
	// The rows/cols is not necessarily valid at this time
}

void DlgWinResize::OnOK() 
{
	UpdateData(TRUE);
	if (m_SizeMode == SIZE_CUSTOM)
	{
		m_WinCols = m_CustomCols;
		m_WinRows = m_CustomRows;
	}
	CDialog::OnOK();
}

BOOL DlgWinResize::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CButton	*pBtn;
	// cube range
	pBtn = (CButton *)GetDlgItem(IDC_RADIO_CUSTOM);
	if (pBtn) pBtn->SetCheck(1);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
