// <><><><><><><><><><><><><>  Plot3D.cpp  <><><><><><><><><><><><><><>
//
// ----------------------------------------------------
// (C) Copyright Clark Dailey, Inc. 1999
//
// C++ Class Name:
//    Plot3D
//
// Purpose:
//    Used as a base class for several Plot3D classes
//
// ----------------------------------------------------

#include "stdafx.h"	// precompiled header
#include "plot3d.h"

// ------------------------------------------------------------------------------------------
void Plot3D::Dump()
{
	unsigned i;
	DBGPLOT("------------------ Plot3D Dump Begin -----------------------\n");
	DBGPLOT("Inputs:\n");
	DBGPLOT("  Xmin=%10.4f Xmax=%10.4f\n", m_xmin, m_xmax);
	DBGPLOT("  Ymin=%10.4f Ymax=%10.4f\n", m_ymin, m_ymax);
	DBGPLOT("  Zmin=%10.4f Zmax=%10.4f\n", m_zmin, m_zmax);
	DBGPLOT("  Xytilt=%10.4f Zrotate=%10.4f\n",m_xytilt, m_zrotate);
	DBGPLOT("  Xvmin=%d  Xvmax=%d\n", m_xvmin, m_xvmax);
	DBGPLOT("  Yvmin=%d  Yvmax=%d\n", m_yvmin, m_yvmax);
	DBGPLOT("  Scale=%10.4f\n",m_scale);

	DBGPLOT("Transformation Matrix:\n");
	DBGPLOT("  [0,0]=%10.4f  [0,1]=%10.4f  [0,2]=%10.4f\n", tm[0][0],tm[0][1],tm[0][2]);
	DBGPLOT("  [1,0]=%10.4f  [1,1]=%10.4f  [1,2]=%10.4f\n", tm[1][0],tm[1][1],tm[1][2]);
	DBGPLOT("  [2,0]=%10.4f  [2,1]=%10.4f  [2,2]=%10.4f\n", tm[2][0],tm[2][1],tm[2][2]);

	DBGPLOT("Mins/Mids/Maxs:\n");
	DBGPLOT("  xpmin=%10.4f xpmid=%10.4f xpmax=%10.4f\n", m_xpmin,m_xpmid,m_xpmax);
	DBGPLOT("  ypmin=%10.4f ypmid=%10.4f ypmax=%10.4f\n", m_ypmin,m_ypmid,m_ypmax);
	DBGPLOT("  zpmin=%10.4f zpmid=%10.4f zpmax=%10.4f\n", m_zpmin,m_zpmid,m_zpmax);
	DBGPLOT("  xvmid=%10d   yvmid=%10d   p2v  =%10.4f\n", m_xvmid,m_yvmid,m_p2v);

	DBGPLOT("Pen Location:\n");
	DBGPLOT("  Yv=%d  Yvx=%d  Color=%ld\n", m_xv_cur, m_yv_cur, m_color_cur);
	DBGPLOT("  PendMoveTo=%d  ToPlot=%d\n", m_pending_moveto, m_to_plotter);

	DBGPLOT("Corners:\n");
	for (i=0;i<8;i++)
	{
		DBGPLOT("  [%d] xp=%10.4f  yp=%10.4f  zp=%10.4f\n", i,m_xpcorner[i],m_ypcorner[i],m_zpcorner[i]);
	}
	DBGPLOT("------------------- Plot3D Dump End ------------------------\n");
}

// ------------------------------------------------------------------------------------------
// calculate projections of corners
void Plot3D::CalcCorners()
{
	double xc[2], yc[2], zc[2];
	double x,y,z,d;
	unsigned ix,iy,iz,ic;

	xc[0] = m_xmin;
	xc[1] = m_xmax;
	yc[0] = m_ymin;
	yc[1] = m_ymax;
	zc[0] = m_zmin;
	zc[1] = m_zmax;

	for (ic=0,iz=0;iz<2;iz++)
	{
		z = zc[iz];
		for (iy=0;iy<2;iy++)
		{
			y = yc[iy];
			for (ix=0;ix<2;ix++)
			{
				// corner values
				m_xcorner[ic] = x = xc[ix];
				m_ycorner[ic] = y;
				m_zcorner[ic] = z;
				// projection of corners
				m_xpcorner[ic] = xpf(x,y,z);
				m_ypcorner[ic] = ypf(x,y,z);
				m_zpcorner[ic] = zpf(x,y,z);
				ic++;
			} // for ix
		} // for iy
	} // for iz

	// find min,max plot coordinates 
	m_xpmin = m_xpmax = m_xpcorner[0];
	m_ypmin = m_ypmax = m_ypcorner[0];
	m_zpmin = m_zpmax = m_zpcorner[0];
	for (unsigned i=1;i<8;i++)
	{
		if (m_xpcorner[i]<m_xpmin) m_xpmin = m_xpcorner[i];
		if (m_xpcorner[i]>m_xpmax) m_xpmax = m_xpcorner[i];
		if (m_ypcorner[i]<m_ypmin) m_ypmin = m_ypcorner[i];
		if (m_ypcorner[i]>m_ypmax) m_ypmax = m_ypcorner[i];
		if (m_zpcorner[i]<m_zpmin) m_zpmin = m_zpcorner[i];
		if (m_zpcorner[i]>m_zpmax) m_zpmax = m_zpcorner[i];
	}
	m_xpmid = (m_xpmin + m_xpmax)/2.;
	m_ypmid = (m_ypmin + m_ypmax)/2.;
	m_zpmid = (m_zpmin + m_zpmax)/2.;

	// calc plot to video scaling
	m_p2v = (m_scale * (double)(m_xvmax - m_xvmin)) / (double)(m_xpmax - m_xpmin);
	d     = (m_scale * (double)(m_yvmax - m_yvmin)) / (double)(m_ypmax - m_ypmin);
	if (d < m_p2v)
		m_p2v = d;
}

/*	<><><><><><><><><><><><><>  Plot3D.cpp  <><><><><><><><><><><><><><> */



