#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "dislin.h"
#ifdef __cplusplus
}
#endif

#define MAX_CB 100
static char *cbray[MAX_CB];
static int icbray[MAX_CB];
static int ncbray = 0;
static char cbfunc[132], cbmypr[132];

void dis_callbck (int id)
{ int i;

  dSP;
  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(id)));
  PUTBACK;
  
  for (i = 0; i < ncbray; i++)
  { if (id == icbray[i])
    { perl_call_pv (cbray[i], G_DISCARD);
      break;
    }
  }
}

void dis_callbck2 (float *x, float *y)
{ 
  dSP;
  SV* xp;
  SV* yp;

  xp = newSVnv ((double) *x);
  yp = newSVnv ((double) *y);
 
  PUSHMARK(sp);
  XPUSHs(sv_2mortal(xp));
  XPUSHs(sv_2mortal(yp));
  PUTBACK;
  
  perl_call_pv (cbmypr, G_DISCARD);

  *x =  (float) SvNV (xp);
  *y =  (float) SvNV (yp);
}

float dis_funcbck (float x, float y, int iopt)
{ 
  dSP;
  int icount;
  float xret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSVnv((double) x)));
  XPUSHs(sv_2mortal(newSVnv((double) y)));
  XPUSHs(sv_2mortal(newSViv(iopt)));
  PUTBACK;

  icount = perl_call_pv (cbfunc, G_SCALAR);

  SPAGAIN;
  xret = (float) POPn;
  PUTBACK;  
  FREETMPS;
  LEAVE;
  return xret;
}

float dis_func2bck (float x, float y)
{ 
  dSP;
  int icount;
  float xret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSVnv((double) x)));
  XPUSHs(sv_2mortal(newSVnv((double) y)));
  PUTBACK;

  icount = perl_call_pv (cbfunc, G_SCALAR);

  SPAGAIN;
  xret = (float) POPn;
  PUTBACK;  
  FREETMPS;
  LEAVE;
  return xret;
}

MODULE = Dislin		PACKAGE = Dislin	PREFIX = Dislin_

void
Dislin_abs3pt (x, y, z, xp, yp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
        CODE:
        float xpt, ypt;
        abs3pt (x, y, z, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_addlab (s1, v, i, s2)
	int i;
	char *s1;
	char *s2;
        double v;
	CODE:
	addlab (s1, v, i, s2);

void 
Dislin_angle  (ngrad)
	int ngrad;
        CODE:
        angle (ngrad);

void
Dislin_arcell (i1, i2, i3, i4, x1, x2, x3)
	int i1;
        int i2;
        int i3;
	int i4;
	double x1;
	double x2;
	double x3;
	CODE:
        arcell (i1, i2, i3, i4, x1, x2, x3);

void
Dislin_areaf (n1ray, n2ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        int *p1, *p2;
        n1 = (int) av_len (n1ray) + 1;
        n2 = (int) av_len (n2ray) + 1;
        New (1, p1, n1, int);
        New (1, p2, n2, int);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (int) SvIV(*av_fetch(n2ray,i,0));

        areaf (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_autres (i1, i2)
	int i1;
        int i2;
	CODE:
        autres (i1, i2);

void 
Dislin_ax2grf ()
	CODE:
	ax2grf ();
        
void 
Dislin_ax3len (nxl, nyl, nzl)
	int nxl;
	int nyl;
	int nzl;
	CODE:
	ax3len (nxl, nyl, nzl);

void
Dislin_axclrs (i, s1, s2)
	int i;
	char *s1;
	char *s2;
	CODE:
	axclrs (i, s1, s2);

void
Dislin_axends (s1, s2)
	char *s1;
	char *s2;
	CODE:
	axends (s1, s2);

void
Dislin_axgit ()
	CODE:
	axgit ();

void
Dislin_axis3d (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
        axis3d (x1, x2, x3);

void
Dislin_axsbgd (i)
	int i;
	CODE:
	axsbgd (i);

void
Dislin_axslen (nxl, nyl)
	int nxl;
	int nyl;
	CODE:
	axslen (nxl, nyl);

void
Dislin_axsorg (i1, i2)
	int i1;
	int i2;
	CODE:
	axsorg (i1, i2);

void
Dislin_axspos (i1, i2)
	int i1;
	int i2;
	CODE:
	axspos (i1, i2);

void
Dislin_axsscl (s1, s2)
	char *s1;
	char *s2;
	CODE:
	axsscl (s1, s2);

void
Dislin_axstyp (s)
	char *s;
	CODE:
	axstyp (s);

void
Dislin_barbor (n)
        int n;
	CODE:
	barbor (n);

void
Dislin_barclr (i1, i2, i3)
	int i1;
	int i2;
	int i3;
	CODE:
	barclr (i1, i2, i3);
      
void
Dislin_bargrp (i, x)
	int i;
	double x;
	CODE:
	bargrp (i, x);

void
Dislin_barmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	barmod (s1, s2);

void
Dislin_baropt (x1, x2)
	double x1;
	double x2;
	CODE:
	baropt (x1, x2);

void
Dislin_barpos (s)
	char *s;
	CODE:
	barpos (s);

void
Dislin_bars (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1, n2, n3;
        float *p1, *p2, *p3;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));

        bars (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_bars3d (x1ray, x2ray, x3ray, x4ray, x5ray, x6ray, n1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
	AV * x5ray = (AV *)SvRV(ST(4));
	AV * x6ray = (AV *)SvRV(ST(5));
	AV * n1ray = (AV *)SvRV(ST(6));
        int n;
        CODE:
        int i, n1, n2, n3, n4, n5, n6, n7, *p7;
        float *p1, *p2, *p3, *p4, *p5, *p6;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (x4ray) + 1;
        n5 = (int) av_len (x5ray) + 1;
        n6 = (int) av_len (x6ray) + 1;
        n7 = (int) av_len (n1ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, float);
        New (1, p5, n5, float);
        New (1, p6, n6, float);
        New (1, p7, n7, int);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (float) SvNV(*av_fetch(x4ray,i,0));
        for (i = 0; i < n5; i++)
          p5[i] = (float) SvNV(*av_fetch(x5ray,i,0));
        for (i = 0; i < n3; i++)
          p6[i] = (float) SvNV(*av_fetch(x6ray,i,0));
        for (i = 0; i < n1; i++)
          p7[i] = (int) SvIV(*av_fetch(n1ray,i,0));

        bars3d (p1, p2, p3, p4, p5, p6, p7, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);

void
Dislin_bartyp (s)
	char *s;
	CODE:
	bartyp (s);

void
Dislin_barwth (x)
	double x;
	CODE:
	barwth (x);

void
Dislin_basalf (s)
	char *s;
	CODE:
	basalf (s);

void
Dislin_basdat (i1, i2, i3)
	int i1;
        int i2;
        int i3;
	CODE:
        basdat (i1, i2, i3);

void
Dislin_bezier (x1ray, x2ray, n, x3ray, x4ray, npt)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * x3ray = (AV *)SvRV(ST(3));
	AV * x4ray = (AV *)SvRV(ST(4));
	int npt;
        CODE:
        int i, n1, n2;
        float *p1, *p2, *p3, *p4;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, npt, float);
        New (1, p4, npt, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        av_extend (x3ray, npt);
        av_extend (x4ray, npt);
        bezier (p1, p2, n, p3, p4, npt);
        for (i = 0; i < npt; i++)
        { av_store(x3ray,i,newSVnv ((double) p3[i]));
          av_store(x4ray,i,newSVnv ((double) p4[i]));
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

short
Dislin_bitsi2 (i1, i2, i3, i4, i5)
	int i1;
	short i2;
	int i3;
	short i4;
	int i5;
        CODE:
        RETVAL = bitsi2 (i1, i2, i3, i4, i5);
        OUTPUT:
        RETVAL

int
Dislin_bitsi4 (i1, i2, i3, i4, i5)
	int i1;
	int i2;
	int i3;
	int i4;
	int i5;
        CODE:
        RETVAL = bitsi4 (i1, i2, i3, i4, i5);
        OUTPUT:
        RETVAL

void
Dislin_box2d ()
	CODE:
	box2d ();

void
Dislin_box3d ()
	CODE:
	box3d ();

void
Dislin_center ()
	CODE:
	center ();

void
Dislin_cgmbgd (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	cgmbgd (x1, x2, x3);

void
Dislin_cgmpic (s)
	char *s;
	CODE:
	cgmpic (s);

void
Dislin_cgmver (i)
	int i;
	CODE:
	cgmver (i);

void
Dislin_chaang (x)
	double x;
	CODE:
	chaang (x);

void
Dislin_chacod (s)
	char *s;
	CODE:
	chacod (s);

void
Dislin_chaspc (x)
	double x;
	CODE:
	chaspc (x);

void
Dislin_chawth (x)
	double x;
	CODE:
	chawth (x);

void
Dislin_chnatt ()
	CODE:
	chnatt ();

void
Dislin_chncrv (s)
	char *s;
	CODE:
	chncrv (s);

void
Dislin_chndot ()
	CODE:
	chndot ();

void
Dislin_chndsh ()
	CODE:
	chndsh ();

void
Dislin_chnbar (s)
	char *s;
	CODE:
	chnbar (s);

void
Dislin_chnpie (s)
	char *s;
	CODE:
	chnpie (s);

void
Dislin_circle (i1, i2, i3)
	int i1;
	int i2;
	int i3;
	CODE:
	circle (i1, i2, i3);

void
Dislin_circsp (i)
	int i;
	CODE:
	circsp (i);

void
Dislin_clip3d (s)
	char *s;
	CODE:
	clip3d (s);

int
Dislin_closfl (i)
	int i;
        CODE:
        RETVAL = closfl (i);
        OUTPUT:
        RETVAL

void
Dislin_clpbor (s)
	char *s;
	CODE:
	clpbor (s);

void
Dislin_clpmod (s)
	char *s;
	CODE:
	clpmod (s);

void
Dislin_clpwin (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        clpwin (i1, i2, i3, i4);

void
Dislin_clrcyc (i1, i2)
	int i1;
	int i2;
	CODE:
	clrcyc (i1, i2);

void
Dislin_clrmod (s)
	char *s;
	CODE:
	clrmod (s);

void
Dislin_clswin (i)
	int i;
	CODE:
	clswin (i);

void
Dislin_color (s)
	char *s;
	CODE:
	color (s);

void
Dislin_colran (i1, i2)
	int i1;
	int i2;
	CODE:
	colran (i1, i2);

void
Dislin_colray (x1ray, n1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * n1ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1;
        float *p1;
        int *p2;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n,  int);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        colray (p1, p2, n);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p2[i]));

        Safefree (p1);
        Safefree (p2);

void 
Dislin_complx ()
	CODE:
        complx ();

void
Dislin_circ3p (x1, y1, x2, y2, x3, y3, xm, ym, r)
	double x1;
	double y1;
	double x2;
	double y2;
	double x3;
	double y3;
	double xm;
	double ym;
        double r;
        CODE:
        float xxm, yym, rr;
        circ3p (x1, y1, x2, y2, x3, y3, &xxm, &yym, &rr);
        xm = xxm;
        ym = yym;
        r  = rr;
        OUTPUT:
        xm
        ym
        r

void
Dislin_conclr (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int i, n1;
        int *p1;
        n1 = (int) av_len (n1ray) + 1;
        New (1, p1, n1, int);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

        conclr (p1, n);
        Safefree (p1);

void
Dislin_concrv (x1ray, x2ray, n, zlev)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        double zlev;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        concrv (p1, p2, n, zlev);
        Safefree (p1);
        Safefree (p2);

void
Dislin_confll (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri, x4ray, nlev)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
	AV * x4ray = (AV *)SvRV(ST(8));
        int nlev;
        CODE:
        int i, n1, n2, n3, n4, n5, n6, n7;
        float *p1, *p2, *p3, *p7;
        int *p4, *p5, *p6;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (n1ray) + 1;
        n5 = (int) av_len (n2ray) + 1;
        n6 = (int) av_len (n3ray) + 1;
        n7 = (int) av_len (x4ray) + 1;

        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, int);
        New (1, p5, n5, int);
        New (1, p6, n6, int);
        New (1, p7, n7, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n5; i++)
          p5[i] = (int) SvIV(*av_fetch(n2ray,i,0));
        for (i = 0; i < n6; i++)
          p6[i] = (int) SvIV(*av_fetch(n3ray,i,0));
        for (i = 0; i < n7; i++)
          p7[i] = (float) SvNV(*av_fetch(x4ray,i,0));

        confll (p1, p2, p3, n, p4, p5, p6, ntri, p7, nlev);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);

void
Dislin_congap (x)
	double x;
	CODE:
	congap (x);

void
Dislin_conlab (s)
	char *s;
	CODE:
	conlab (s);

void
Dislin_conmat (x1ray, nx, ny, zlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
	double zlev;
        CODE:
        int i, ii, j, n1;
        float *p1;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, nx * ny, float);

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(x1ray,i,0));
          for (j = 0; j < ny; j++)
            p1[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        conmat (p1, nx, ny, zlev);
        Safefree (p1);

void
Dislin_conmod (x1, x2)
	double x1;
	double x2;
	CODE:
	conmod (x1, x2);

void
Dislin_conn3d (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	conn3d (x1, x2, x3);

void
Dislin_connpt (x1, x2)
	double x1;
	double x2;
	CODE:
	connpt (x1, x2);

int
Dislin_conpts (x1ray, nx, x2ray, ny, xmat, zlev, xpts, ypts, maxpts, nray, maxray)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
        double zlev;
	AV * xpts = (AV *)SvRV(ST(6));
	AV * ypts = (AV *)SvRV(ST(7));
        int maxpts;
	AV * nray = (AV *)SvRV(ST(9));
        int maxray;
        CODE:
        int i, n, ii, j, n1, n2, *p6, nlins;
        float *p1, *p2, *p3, *p4, *p5;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, nx * ny, float);
        New (1, p4, maxpts, float);
        New (1, p5, maxpts, float);
        New (1, p6, maxray, int);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(xmat,i,0));
          for (j = 0; j < ny; j++)
            p3[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        conpts (p1, nx, p2, ny, p3, zlev, p4, p5, maxpts, p6, 
                maxray, &nlins);
        n = 0; 
        for (i = 0; i < nlins; i++)
           n += p6[i];
 
        av_extend (xpts, n);
        av_extend (ypts, n);
        av_extend (nray, nlins);
        for (i = 0; i < n; i++)
        { av_store(xpts,i,newSVnv ((double) p4[i]));
          av_store(ypts,i,newSVnv ((double) p5[i]));
        }
        for (i = 0; i < nlins; i++)
          av_store(nray,i,newSViv ((int) p6[i]));

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        RETVAL = nlins;
        OUTPUT:
        RETVAL

void
Dislin_conshd (x1ray, nx, x2ray, ny, xmat, zlev, nlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
	AV * zlray = (AV *)SvRV(ST(5));
        int nlev;
        CODE:
        int i, ii, j, n1, n2, n4;
        float *p1, *p2, *p3, *p4;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n4 = (int) av_len (zlray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, nx * ny, float);
        New (1, p4, n4, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (float) SvNV(*av_fetch(zlray,i,0));

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(xmat,i,0));
          for (j = 0; j < ny; j++)
            p3[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        conshd (p1, nx, p2, ny, p3, p4, nlev);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_contri (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri, zlev)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
        double zlev;
        CODE:
        int i, n1, n2, n3, n4, n5, n6;
        float *p1, *p2, *p3;
        int *p4, *p5, *p6;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (n1ray) + 1;
        n5 = (int) av_len (n2ray) + 1;
        n6 = (int) av_len (n3ray) + 1;

        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, int);
        New (1, p5, n5, int);
        New (1, p6, n6, int);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n5; i++)
          p5[i] = (int) SvIV(*av_fetch(n2ray,i,0));
        for (i = 0; i < n5; i++)
          p6[i] = (int) SvIV(*av_fetch(n3ray,i,0));

        contri (p1, p2, p3, n, p4, p5, p6, ntri, zlev);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_contur (x1ray, nx, x2ray, ny, xmat, zlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
        double zlev;
        CODE:
        int i, ii, j, n1, n2;
        float *p1, *p2, *p3;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, nx * ny, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(xmat,i,0));
          for (j = 0; j < ny; j++)
            p3[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        contur (p1, nx, p2, ny, p3, zlev);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_cross ()
	CODE:
	cross ();

void
Dislin_crvmat (x1ray, nx, ny, ixpts, iypts)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
	int ixpts;
	int iypts;
        CODE:
        int i, ii, j, n1;
        float *p1;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, nx * ny, float);

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(x1ray,i,0));
          for (j = 0; j < ny; j++)
            p1[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        crvmat (p1, nx, ny, ixpts, iypts);
        Safefree (p1);

void
Dislin_crvtri (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
        CODE:
        int i, n1, n2, n3, n4, n5, n6;
        float *p1, *p2, *p3;
        int *p4, *p5, *p6;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (n1ray) + 1;
        n5 = (int) av_len (n2ray) + 1;
        n6 = (int) av_len (n3ray) + 1;

        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, int);
        New (1, p5, n5, int);
        New (1, p6, n6, int);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n5; i++)
          p5[i] = (int) SvIV(*av_fetch(n2ray,i,0));
        for (i = 0; i < n5; i++)
          p6[i] = (int) SvIV(*av_fetch(n3ray,i,0));

        crvtri (p1, p2, p3, n, p4, p5, p6, ntri);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_csrmov (n1ray, n2ray, nmax, n, iret)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int nmax;
        int n;
        int iret;
        CODE:
        int i, nn, irr;
        int *p1, *p2;
        New (1, p1, nmax, int);
        New (1, p2, nmax, int);

        csrmov (p1, p2, nmax, &nn, &irr);
        for (i = 0; i < nn; i++)
        { av_store(n1ray,i,newSViv ((int) p1[i]));
          av_store(n2ray,i,newSViv ((int) p2[i]));
        }

        Safefree (p1);
        Safefree (p2);
        n = nn;
        iret = irr;
        OUTPUT:
        n
        iret
       

void
Dislin_csrpt1 (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        csrpt1 (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_csrpts (n1ray, n2ray, nmax, n, iret)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int nmax;
        int n;
        int iret;
        CODE:
        int i, nn, irr;
        int *p1, *p2;
        New (1, p1, nmax, int);
        New (1, p2, nmax, int);

        csrpts (p1, p2, nmax, &nn, &irr);
        for (i = 0; i < nn; i++)
        { av_store(n1ray,i,newSViv ((int) p1[i]));
          av_store(n2ray,i,newSViv ((int) p2[i]));
        }

        Safefree (p1);
        Safefree (p2);
        n = nn;
        iret = irr;
        OUTPUT:
        n
        iret
       
void
Dislin_csruni (s)
	char *s;
	CODE:
	csruni (s);

void
Dislin_curv3d (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1, n2, n3;
        float *p1, *p2, *p3;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));

        curv3d (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_curve (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        curve (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_curve3 (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1, n2, n3;
        float *p1, *p2, *p3;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));

        curve3 (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_curvmp (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        curvmp (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_curvx3 (x1ray, y, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
        double y;
	AV * x2ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        curvx3 (p1, y, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_curvy3 (x, x1ray, x2ray, n)
	double x;
	AV * x1ray = (AV *)SvRV(ST(1));
	AV * x2ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        curvy3 (x, p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_dash ()
	CODE:
	dash ();

void
Dislin_dashl ()
	CODE:
	dashl ();

void
Dislin_dashm ()
	CODE:
	dashm ();

void
Dislin_dattim (s1, s2)
	char *s1;
	char *s2;
        CODE:
        dattim (s1, s2);
        OUTPUT:
        s1
        s2

void
Dislin_digits (i, s)
	int i;
	char *s;
	CODE:
	digits (i, s);

void
Dislin_disalf ()
	CODE:
	disalf ();

void
Dislin_disfin ()
	CODE:
        disfin ();      

void
Dislin_disini ()
	CODE:
        lsechk ("off");
        disini ();      

void
Dislin_dot ()
	CODE:
	dot ();

void
Dislin_dotl ()
	CODE:
	dotl ();

void
Dislin_duplx ()
	CODE:
	duplx ();

int
Dislin_dwgbut (s, i)
	char *s;
	int i;
        CODE:
        RETVAL = dwgbut (s, i);
        OUTPUT:
        RETVAL

char *
Dislin_dwgfil (s1, s2, s3)
	char *s1;
	char *s2;
	char *s3;
        CODE:
        RETVAL = dwgfil (s1, s2, s3);
        OUTPUT:
        RETVAL

int
Dislin_dwglis (s1, s2, i)
	char *s1;
	char *s2;
	int i;
        CODE:
        RETVAL = dwglis (s1, s2, i);
        OUTPUT:
        RETVAL

void
Dislin_dwgmsg (s)
	char *s;
	CODE:
	dwgmsg (s);

char *
Dislin_dwgtxt (s1, s2)
	char *s1;
	char *s2;
        CODE:
        RETVAL = dwgtxt (s1, s2);
        OUTPUT:
        RETVAL

void
Dislin_ellips (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        ellips (i1, i2, i3, i4);

void
Dislin_endgrf ()
	CODE:
	endgrf ();

void
Dislin_erase ()
	CODE:
	erase ();

void
Dislin_errbar (x1ray, x2ray, x3ray, x4ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
        int n;
        CODE:
        int i, n1, n2, n3, n4;
        float *p1, *p2, *p3, *p4;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (x4ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (float) SvNV(*av_fetch(x4ray,i,0));

        errbar (p1, p2, p3, p4, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_errdev (s)
	char *s;
	CODE:
	errdev (s);

void
Dislin_errfil (s)
	char *s;
	CODE:
	errfil (s);

void
Dislin_errmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	errmod (s1, s2);

void
Dislin_eushft (s1, s2)
	char *s1;
	char *s2;
	CODE:
	eushft (s1, s2);

void
Dislin_expzlb (s)
	char *s;
	CODE:
	expzlb (s);

char *
Dislin_fcha (x, i)
	double x;
	int i;
        CODE:
        int n;
	char s[41];
        n = fcha (x, i, s);
        RETVAL = s;
        OUTPUT:
        RETVAL

void
Dislin_field (x1ray, x2ray, x3ray, x4ray, n, ivec)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(3));
	AV * x4ray = (AV *)SvRV(ST(4));
        int n;
        int ivec;
        CODE:
        int i, n1, n2, n3, n4;
        float *p1, *p2, *p3, *p4;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (x4ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (float) SvNV(*av_fetch(x4ray,i,0));

        field (p1, p2, p3, p4, n, ivec);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_filbox (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        filbox (i1, i2, i3, i4);

void
Dislin_filclr (s)
	char *s;
	CODE:
	filclr (s);

void
Dislin_filmod (s)
	char *s;
	CODE:
	filmod (s);

void
Dislin_fixspc (x)
	double x;
	CODE:
	fixspc (x);

void
Dislin_flab3d ()
	CODE:
	flab3d ();

int
Dislin_flen (x, i)
	double x;
	int i;
        CODE:
        RETVAL = flen (x, i);
        OUTPUT:
        RETVAL

void
Dislin_frame (i)
	int i;
	CODE:
	frame (i);

void
Dislin_frmclr (i)
	int i;
	CODE:
	frmclr (i);

void
Dislin_frmess (i)
	int i;
	CODE:
	frmess (i);

void
Dislin_gapcrv (x)
	double x;
	CODE:
	gapcrv (x);

char *
Dislin_getalf ()
        CODE:
        RETVAL = getalf ();
        OUTPUT:
        RETVAL

int
Dislin_getang ()
        CODE:
        RETVAL = getang ();
        OUTPUT:
        RETVAL

int
Dislin_getbpp ()
        CODE:
        RETVAL = getbpp ();
        OUTPUT:
        RETVAL

int
Dislin_getclr ()
        CODE:
        RETVAL = getclr ();
        OUTPUT:
        RETVAL

void
Dislin_getclp (i1, i2, i3, i4)
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int j1, j2, j3, j4;
        getclp (&j1, &j2, &j3, &j4);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        i4 = j4;
        OUTPUT:
        i1
        i2
        i3
        i4

void
Dislin_getdig (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getdig (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

char *
Dislin_getdsp ()
        CODE:
        RETVAL = getdsp ();
        OUTPUT:
        RETVAL

char *
Dislin_getfil ()
        CODE:
        RETVAL = getfil ();
        OUTPUT:
        RETVAL

void
Dislin_getgrf (x1, x2, x3, x4, s)
	double x1;
	double x2;
	double x3;
	double x4;
	char  *s;
        CODE:
        float y1, y2, y3, y4;
        getgrf (&y1, &y2, &y3, &y4, s);
        x1 = y1;
        x2 = y2;
        x3 = y3;
        x4 = y4;
        OUTPUT:
        x1
        x2
        x3
        x4

int
Dislin_gethgt ()
        CODE:
        RETVAL = gethgt ();
        OUTPUT:
        RETVAL

void
Dislin_getind (i, x1, x2, x3)
	int    i;
	double x1;
	double x2;
	double x3;
        CODE:
        float y1, y2, y3;
        getind (i, &y1, &y2, &y3);
        x1 = y1;
        x2 = y2;
        x3 = y3;
        OUTPUT:
        x1
        x2
        x3

void
Dislin_getlab (s1, s2, s3)
	char *s1;
	char *s2;
	char *s3;
        CODE:
        char t1[5], t2[5], t3[5];
        getlab (t1, t2, t3);
        sv_setpv((SV *) ST(0), t1);
        sv_setpv((SV *) ST(1), t2);
        sv_setpv((SV *) ST(2), t3);

void
Dislin_getlen (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getlen (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

int
Dislin_getlev ()
        CODE:
        RETVAL = getlev ();
        OUTPUT:
        RETVAL

int
Dislin_getlin ()
        CODE:
        RETVAL = getlin ();
        OUTPUT:
        RETVAL

int
Dislin_getlit (xp, yp, zp, xn, yn, zn)
        double xp;
        double yp;
        double zp;
        double xn;
        double yn;
        double zn;
        CODE:
        RETVAL = getlit (xp, yp, zp, xn, yn, zn);
        OUTPUT:
        RETVAL

void
Dislin_getmat (x1ray, x2ray, x3ray, n, xmat, nx, ny, zval)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * xmat = (AV *)SvRV(ST(4));
	int nx;
        int ny;
        double zval;
        CODE:
        AV *p;
        int i, j, ii, n1, n2, n3, *p5;
        float *p1, *p2, *p3, *p4, *p6;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, nx * ny, float);
        New (1, p5, nx * ny, int);
        New (1, p6, nx * ny, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));

        getmat (p1, p2, p3, n, p4, nx, ny, zval, p5, p6);

        av_extend (xmat, nx * ny);
        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(xmat,i,0));
          for (j = 0; j < ny; j++)
            av_store (p,j, newSVnv ((double) p4[j+ii]));
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

char *
Dislin_getmfl ()
        CODE:
        RETVAL = getmfl ();
        OUTPUT:
        RETVAL

char *
Dislin_getmix (s)
        char *s;
        CODE:
        RETVAL = getmix (s);
        OUTPUT:
        RETVAL

void
Dislin_getor (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getor (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_getpag (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getpag (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

int
Dislin_getpat ()
        CODE:
        RETVAL = getpat ();
        OUTPUT:
        RETVAL

int
Dislin_getplv ()
        CODE:
        RETVAL = getplv ();
        OUTPUT:
        RETVAL

void
Dislin_getpos (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getpos (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_getran (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getran (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_getres (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getres (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_getrgb (xr, xg, xb)
	double xr;
	double xg;
	double xb;
        CODE:
        float xrr, xgg, xbb;
        getrgb (&xrr, &xgg, &xbb);
        xr = xrr;
        xg = xgg;
        xb = xbb;
        OUTPUT:
        xr
        xg
        xb

void
Dislin_getscl (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getscl (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

void
Dislin_getscr (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getscr (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

char *
Dislin_getshf (s)
        char *s;
        CODE:
        RETVAL = getshf (s);
        OUTPUT:
        RETVAL

void
Dislin_getsp1 (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getsp1 (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

void
Dislin_getsp2 (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getsp2 (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

void
Dislin_getsym (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getsym (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_gettcl (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        gettcl (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_gettic (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        gettic (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

int
Dislin_gettyp ()
        CODE:
        RETVAL = gettyp ();
        OUTPUT:
        RETVAL

int
Dislin_getuni ()
        CODE:
        FILE *fp;
        fp = (FILE *) getuni ();
        if (fp == NULL)
          RETVAL = 0;
        else 
          RETVAL = 6;  
        OUTPUT:
        RETVAL

double
Dislin_getver ()
        CODE:
        RETVAL = getver ();
        OUTPUT:
        RETVAL

void
Dislin_getvk (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getvk (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

char *
Dislin_getvlt ()
        CODE:
        RETVAL = getvlt ();
        OUTPUT:
        RETVAL

int
Dislin_getwid ()
        CODE:
        RETVAL = getwid ();
        OUTPUT:
        RETVAL

void
Dislin_getwin (i1, i2, i3, i4)
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int j1, j2, j3, j4;
        getwin (&j1, &j2, &j3, &j4);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        i4 = j4;
        OUTPUT:
        i1
        i2
        i3
        i4

int
Dislin_getxid (s)
	char *s;
        CODE:
        RETVAL = getxid (s);
        OUTPUT:
        RETVAL

int
Dislin_gmxalf (s1, s2, s3)
	char *s1;
	char *s2;
	char *s3;
        CODE:
        char t1[5], t2[5];
        RETVAL = gmxalf (s1, t1, t2);
        sv_setpv((SV *) ST(1), t1);
        sv_setpv((SV *) ST(2), t2);
        OUTPUT:
        RETVAL

void
Dislin_grace (i)
	int i;
	CODE:
	grace (i);

void
Dislin_graf (xa, xe, xor, xstp, ya, ye, yor, ystp)
        double xa;
        double xe;
        double xor;
        double xstp;
        double ya;
        double ye;
        double yor;
        double ystp;
        CODE:
        graf (xa, xe, xor, xstp, ya, ye, yor, ystp);

void
Dislin_graf3 (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp)
        double xa;
        double xe;
        double xor;
        double xstp;
        double ya;
        double ye;
        double yor;
        double ystp;
        double za;
        double ze;
        double zor;
        double zstp;
        CODE:
        graf3 (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp);

void
Dislin_graf3d (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp)
        double xa;
        double xe;
        double xor;
        double xstp;
        double ya;
        double ye;
        double yor;
        double ystp;
        double za;
        double ze;
        double zor;
        double zstp;
        CODE:
        graf3d (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp);

void
Dislin_grafmp (xa, xe, xor, xstp, ya, ye, yor, ystp)
        double xa;
        double xe;
        double xor;
        double xstp;
        double ya;
        double ye;
        double yor;
        double ystp;
        CODE:
        grafmp (xa, xe, xor, xstp, ya, ye, yor, ystp);

void
Dislin_grffin ()
	CODE:
	grffin ();

void
Dislin_grfini (x1, y1, z1, x2, y2, z2, x3, y3, z3)
	double x1;
	double y1;
	double z1;
	double x2;
	double y2;
	double z2;
	double x3;
	double y3;
	double z3;
	CODE:
        grfini (x1, y1, z1, x2, y2, z2, x3, y3, z3);

void
Dislin_grdpol (i1, i2)
	int i1;
	int i2;
	CODE:
	grdpol (i1, i2);

void
Dislin_grid (i1, i2)
	int i1;
	int i2;
	CODE:
	grid (i1, i2);

void
Dislin_grid3d (i1, i2, s)
	int i1;
	int i2;
	char *s;
	CODE:
	grid3d (i1, i2, s);

void
Dislin_gridmp (i1, i2)
	int i1;
	int i2;
	CODE:
	gridmp (i1, i2);

int
Dislin_gwgatt (i, s)
	int i;
        char *s;
        CODE:
        RETVAL = gwgatt (i, s);
        OUTPUT:
        RETVAL

int
Dislin_gwgbox (i)
	int i;
        CODE:
        RETVAL = gwgbox (i);
        OUTPUT:
        RETVAL

int
Dislin_gwgbut (i)
	int i;
        CODE:
        RETVAL = gwgbut (i);
        OUTPUT:
        RETVAL

char *
Dislin_gwgfil (i)
	int i;
        CODE:
        char cstr[133];
        gwgfil (i, cstr);
        RETVAL = cstr;
        OUTPUT:
        RETVAL

int
Dislin_gwglis (i)
	int i;
        CODE:
        RETVAL = gwglis (i);
        OUTPUT:
        RETVAL

double
Dislin_gwgscl (i)
	int i;
        CODE:
        RETVAL = gwgscl (i);
        OUTPUT:
        RETVAL

char *
Dislin_gwgtxt (i)
	int i;
        CODE:
        char cstr[513];
        gwgtxt (i, cstr);
        RETVAL = cstr;
        OUTPUT:
        RETVAL

int
Dislin_gwgxid (i)
	int i;
        CODE:
        RETVAL = gwgxid (i);
        OUTPUT:
        RETVAL

void
Dislin_height (i)
	int i;
	CODE:
	height (i);

void
Dislin_helve ()
	CODE:
	helve ();

void
Dislin_helves ()
	CODE:
	helves ();

int
Dislin_histog (x1ray, n, x2ray, x3ray)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	AV * x2ray = (AV *)SvRV(ST(2));
	AV * x3ray = (AV *)SvRV(ST(3));
        CODE:
        int i, n1, npt;
        float *p1, *p2, *p3;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n1, float);
        New (1, p3, n1, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        histog (p1, n, p2, p3, &npt);
        av_extend (x2ray, npt);
        av_extend (x3ray, npt);
        for (i = 0; i < npt; i++)
        { av_store(x2ray,i,newSVnv ((double) p2[i]));
          av_store(x3ray,i,newSVnv ((double) p3[i]));
        }
        RETVAL = npt;
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        OUTPUT:
        RETVAL

void
Dislin_hname (i)
	int i;
	CODE:
	hname (i);

void
Dislin_hsvrgb (x, y, z, xp, yp, zp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
	double zp;
        CODE:
        float xpt, ypt, zpt;
        hsvrgb (x, y, z, &xpt, &ypt, &zpt);
        xp = xpt;
        yp = ypt;
        zp = zpt;
        OUTPUT:
        xp
        yp
        zp

void
Dislin_hsymbl (i)
	int i;
	CODE:
	hsymbl (i);

void
Dislin_htitle (i)
	int i;
	CODE:
	htitle (i);

void
Dislin_hwfont ()
	CODE:
	hwfont ();

void
Dislin_hworig (i1, i2)
	int i1;
	int i2;
	CODE:
	hworig (i1, i2);

void
Dislin_hwpage (i1, i2)
	int i1;
	int i2;
	CODE:
	hwpage (i1, i2);

void
Dislin_imgbox (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        imgbox (i1, i2, i3, i4);

void
Dislin_imgfin ()
	CODE:
	imgfin ();

void
Dislin_imgfmt (s)
	char *s;
	CODE:
	imgfmt (s);

void
Dislin_imgini ()
	CODE:
	imgini ();

void
Dislin_imgmod (s)
	char *s;
	CODE:
	imgmod (s);

void
Dislin_imgsiz (i1, i2)
	int i1;
	int i2;
	CODE:
	imgsiz (i1, i2);

void
Dislin_inccrv (i)
	int i;
	CODE:
	inccrv (i);

int
Dislin_incdat (i1, i2, i3)
	int i1;
        int i2;
        int i3;
        CODE:
        RETVAL = incdat (i1, i2, i3);
        OUTPUT:
        RETVAL


void
Dislin_incfil (s)
	char *s;
	CODE:
	incfil (s);

void
Dislin_incmrk (i)
	int i;
	CODE:
	incmrk (i);

void
Dislin_intax ()
	CODE:
	intax ();

char *
Dislin_intcha (i)
	int i;
        CODE:
        char s[21];
        int n;
        n = intcha (i, s);
        RETVAL = s;
        OUTPUT:
        RETVAL

int
Dislin_intlen (i)
	int i;
        CODE:
        RETVAL = intlen (i);
        OUTPUT:
        RETVAL

char *
Dislin_itmcat (s1, s2)
	char *s1;
	char *s2;
        CODE:
        int n1, n2;
        char *p;
        n1 = strlen (s1);
        n2 = strlen (s2);
        New (1, p, n1 + n2 + 2, char);
        strcpy (p, s1);
        itmcat (p, s2);
        RETVAL = p;
        Safefree (p);
        OUTPUT:
        RETVAL
        
int
Dislin_itmcnt (s)
	char *s;
        CODE:
        RETVAL = itmcnt (s);
        OUTPUT:
        RETVAL

char *
Dislin_itmstr (s, i)
	char *s;
	int i;
        CODE:
        RETVAL = itmstr (s, i);
        OUTPUT:
        RETVAL

void
Dislin_labclr (i, s)
	int i;
	char *s;
	CODE:
	labclr (i, s);

void
Dislin_labdig (i, s)
	int i;
	char *s;
	CODE:
	labdig (i, s);

void
Dislin_labdis (i, s)
	int i;
	char *s;
	CODE:
	labdis (i, s);

void
Dislin_labels (s1, s2)
	char *s1;
	char *s2;
	CODE:
	labels (s1, s2);

void
Dislin_labjus (s1, s2)
	char *s1;
	char *s2;
	CODE:
	labjus (s1, s2);

void
Dislin_labl3d (s1)
	char *s1;
	CODE:
	labl3d (s1);

void
Dislin_labmod (s1, s2, s3)
	char *s1;
	char *s2;
	char *s3;
	CODE:
	labmod (s1, s2, s3);

void
Dislin_labpos (s1, s2)
	char *s1;
	char *s2;
	CODE:
	labpos (s1, s2);

void
Dislin_labtyp (s1, s2)
	char *s1;
	char *s2;
	CODE:
	labtyp (s1, s2);

void
Dislin_legclr ()
	CODE:
	legclr ();

void
Dislin_legend (s, i)
	char *s;
	int i;
	CODE:
	legend (s, i);

void
Dislin_legini (s, i1, i2)
	char *s;
	int i1;
	int i2;
	CODE:
        int n;
        char *p;
        n = i1 * i2 + 1;
        New (1, p, n, char);
	legini (p, i1, i2);
        sv_setpvn((SV *) ST(0), p, n);
        Safefree (p);

void
Dislin_leglin (s1, s2, i)
	char *s1;
	char *s2;
	int i;
	CODE:
	leglin (s1, s2, i);
        OUTPUT:
        s1

void
Dislin_legopt (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	legopt (x1, x2, x3);

void
Dislin_legpat (i1, i2, i3, i4, i5, i6)
	int i1;
	int i2;
	int i3;
	int i4;
	int i5;
	int i6;
	CODE:
	legpat (i1, i2, i3, i4, i5, i6);

void
Dislin_legpos (i1, i2)
	int i1;
	int i2;
	CODE:
	legpos (i1, i2);

void
Dislin_legtit (s)
	char *s;
	CODE:
	legtit (s);

void
Dislin_lfttit ()
	CODE:
	lfttit ();

void
Dislin_light (s)
	char *s;
	CODE:
	light (s);

void
Dislin_lincyc (i1, i2)
	int i1;
	int i2;
	CODE:
	lincyc (i1, i2);

void
Dislin_line (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        line (i1, i2, i3, i4);

void
Dislin_linesp (x)
	double x;
	CODE:
	linesp (x);

void
Dislin_lintyp (i)
	int i;
	CODE:
	lintyp (i);

void
Dislin_linwid (i)
	int i;
	CODE:
	linwid (i);

void
Dislin_litmod (i, s)
        int i;
	char *s;
	CODE:
	litmod (i, s);

void
Dislin_litopt (i, x, s)
        int i;
        double x;
	char *s;
	CODE:
	litopt(i, x, s);

void
Dislin_litpos (i, x, y, z, s)
        int i;
        double x;
        double y;
        double z;
	char *s;
	CODE:
	litpos (i, x, y, z, s);

void
Dislin_lncap (s)
	char *s;
	CODE:
	lncap (s);

void
Dislin_lnjoin (s)
	char *s;
	CODE:
	lnjoin (s);

void
Dislin_lnmlt (x)
	double x;
	CODE:
	lnmlt (x);

void
Dislin_logtic (s)
	char *s;
	CODE:
	logtic (s);

void
Dislin_mapbas (s)
	char *s;
	CODE:
	mapbas (s);

void
Dislin_mapfil (s1, s2)
	char *s1;
	char *s2;
	CODE:
	mapfil (s1, s2);

void
Dislin_maplev (s)
	char *s;
	CODE:
	maplev (s);

void
Dislin_mapmod (s)
	char *s;
	CODE:
	mapmod (s);

void
Dislin_mappol (x1, x2)
	double x1;
	double x2;
	CODE:
	mappol (x1, x2);

void
Dislin_mapref (x1, x2)
	double x1;
	double x2;
	CODE:
	mapref (x1, x2);

void
Dislin_mapsph (x)
	double x;
	CODE:
	mapsph (x);

void
Dislin_marker (i)
	int i;
	CODE:
	marker (i);

void
Dislin_matopt (x, s)
        double x;
	char *s;
	CODE:
	matopt (x, s);

void
Dislin_mdfmat (i1, i2, x)
	int i1;
	int i2;
	double x;
	CODE:
	mdfmat (i1, i2, x);

void
Dislin_messag (cstr, nx, ny)
	char *cstr;
	int  nx;
	int  ny;
	CODE:
	messag (cstr, nx, ny);

void 
Dislin_metafl (s)
	char *s;
	CODE:
        metafl (s);

void
Dislin_mixalf ()
	CODE:
	mixalf ();

void
Dislin_mixleg ()
	CODE:
	mixleg ();

double
Dislin_moment (x1ray, n, s)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	char *s;
        CODE:
        int i, n1;
        float *p1;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        RETVAL=moment (p1, n, s);
        Safefree (p1);
        OUTPUT:
        RETVAL

void
Dislin_mpaepl (i)
	int i;
	CODE:
	mpaepl (i);

void
Dislin_mplang (x)
	double x;
	CODE:
	mplang (x);

void
Dislin_mplclr (i1, i2)
	int i1;
	int i2;
	CODE:
	mplclr (i1, i2);

void
Dislin_mplpos (i1, i2)
	int i1;
	int i2;
	CODE:
	mplpos (i1, i2);

void
Dislin_mplsiz (i)
	int i;
	CODE:
	mplsiz (i);

void
Dislin_msgbox (s)
	char *s;
	CODE:
	msgbox (s);

void
Dislin_mshclr (i)
	int i;
	CODE:
	mshclr (i);

void
Dislin_mylab (s1, i, s2)
	char *s1;
	int i;
	char *s2;
	CODE:
	mylab (s1, i, s2);

void
Dislin_myline (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int i, n1;
        int *p1;
        n1 = (int) av_len (n1ray) + 1;
        New (1, p1, n1, int);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

        myline (p1, n);
        Safefree (p1);

void
Dislin_mypat (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        mypat (i1, i2, i3, i4);

void
Dislin_mysymb (x1ray, x2ray, n, isym, iflag)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        int isym;
        int iflag; 
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        mysymb (p1, p2, n, isym, iflag);
        Safefree (p1);
        Safefree (p2);

void
Dislin_myvlt (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1, n2, n3;
        float *p1, *p2, *p3;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));

        myvlt (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_namdis (i, s)
	int i;
	char *s;
	CODE:
	namdis (i, s);

void
Dislin_name (s1, s2)
	char *s1;
	char *s2;
	CODE:
	name (s1, s2);

void
Dislin_namjus (s1, s2)
	char *s1;
	char *s2;
	CODE:
	namjus (s1, s2);

void
Dislin_neglog (x)
	double x;
	CODE:
	neglog (x);

void
Dislin_newmix ()
	CODE:
	newmix ();

void
Dislin_newpag ()
	CODE:
	newpag ();

int
Dislin_nlmess (s)
	char *s;
        CODE:
        RETVAL = nlmess (s);
        OUTPUT:
        RETVAL

int
Dislin_nlnumb (x, i)
	double x;
        int i;
        CODE:
        RETVAL = nlnumb (x, i);
        OUTPUT:
        RETVAL

void
Dislin_noarln ()
	CODE:
	noarln ();

void
Dislin_nobar ()
	CODE:
	nobar ();

void
Dislin_nobgd ()
	CODE:
	nobgd ();

void
Dislin_nochek ()
	CODE:
	nochek ();

void
Dislin_noclip ()
	CODE:
	noclip ();

void
Dislin_nofill ()
	CODE:
	nofill ();

void
Dislin_nograf ()
	CODE:
	nograf ();

void
Dislin_nohide ()
	CODE:
	nohide ();

void
Dislin_noline (s)
	char *s;
	CODE:
	noline (s);

void
Dislin_number (x, i1, i2, i3)
	double x;
	int i1;
	int i2;
	int i3;
	CODE:
	number (x, i1, i2, i3);

void
Dislin_numfmt (s)
	char *s;
	CODE:
	numfmt (s);

void
Dislin_numode (s1, s2, s3, s4)
	char *s1;
	char *s2;
	char *s3;
	char *s4;
	CODE:
	numode (s1, s2, s3, s4);

int
Dislin_nwkday (i1, i2, i3)
	int i1;
        int i2;
        int i3;
        CODE:
        RETVAL = nwkday (i1, i2, i3);
        OUTPUT:
        RETVAL

int
Dislin_nxlegn (s)
	char *s;
        CODE:
        RETVAL = nxlegn (s);
        OUTPUT:
        RETVAL

int
Dislin_nxposn (x)
	double x;
        CODE:
        RETVAL = nxposn (x);
        OUTPUT:
        RETVAL

int
Dislin_nylegn (s)
	char *s;
        CODE:
        RETVAL = nylegn (s);
        OUTPUT:
        RETVAL

int
Dislin_nyposn (x)
	double x;
        CODE:
        RETVAL = nyposn (x);
        OUTPUT:
        RETVAL

int
Dislin_nzposn (x)
	double x;
        CODE:
        RETVAL = nzposn (x);
        OUTPUT:
        RETVAL

int
Dislin_openfl (s, i1, i2)
	char *s;
	int i1;
	int i2;
        CODE:
        RETVAL = openfl (s, i1, i2);
        OUTPUT:
        RETVAL

void
Dislin_opnwin (i)
	int i;
	CODE:
	opnwin (i);

void
Dislin_origin (i1, i2)
	int i1;
	int i2;
	CODE:
	origin (i1, i2);

void
Dislin_page (i1, i2)
	int i1;
	int i2;
	CODE:
	page (i1, i2);

void
Dislin_pagera ()
	CODE:
        pagera ();

void
Dislin_pagfll (i)
	int i;
	CODE:
	pagfll (i);

void
Dislin_paghdr (s1, s2, i1, i2)
	char *s1;
	char *s2;
	int i1;
	int i2;
	CODE:
	paghdr (s1, s2, i1, i2);

void
Dislin_pagmod (s)
	char *s;
	CODE:
	pagmod (s);

void
Dislin_pagorg (s)
	char *s;
	CODE:
	pagorg (s);

void
Dislin_patcyc (i1, i2)
	int i1;
	int i2;
	CODE:
	patcyc (i1, i2);

int
Dislin_pdfbuf (s, nmax)
	char *s;
        int nmax;
        CODE:
        char *p;
        int n;

        if (nmax != 0)
        { New (1, p, nmax, char);
        }

        n = pdfbuf (p, nmax);
        RETVAL = n;
        if (nmax != 0 && n > 0)
        { sv_setpvn ((SV*) ST(0), p, n);
        }  
        if (nmax != 0) Safefree (p);
        OUTPUT:
        RETVAL

void
Dislin_pdfmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	pdfmod (s1, s2);

void
Dislin_penwid (x)
	double x;
	CODE:
	penwid (x);

void
Dislin_pie (i1, i2, i3, x1, x2)
	int i1;
	int i2;
	int i3;
	double x1;
	double x2;
	CODE:
	pie (i1, i2, i3, x1, x2);

void
Dislin_piebor (n)
        int n;
	CODE:
	piebor (n);

void
Dislin_pieclr (n1ray, n2ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        int *p1, *p2;
        n1 = (int) av_len (n1ray) + 1;
        n2 = (int) av_len (n2ray) + 1;
        New (1, p1, n1, int);
        New (1, p2, n2, int);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (int) SvIV(*av_fetch(n2ray,i,0));

        pieclr (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_pieexp ()
	CODE:
	pieexp ();

void
Dislin_piegrf (s, nlin, x1ray, n)
	char *s;
	int nlin;
	AV * x1ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1;
        float *p1;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        piegrf (s, nlin, p1, n);
        Safefree (p1);

void
Dislin_pielab (s1, s2)
	char *s1;
	char *s2;
	CODE:
	pielab (s1, s2);

void
Dislin_pieopt (x1, x2)
	double x1;
	double x2;
	CODE:
	pieopt (x1, x2);

void
Dislin_pietyp (s)
	char *s;
	CODE:
	pietyp (s);

void
Dislin_pievec (i, s)
	int i;
	char *s;
	CODE:
	pievec (i, s);

void
Dislin_pngmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	pngmod (s1, s2);

void
Dislin_point (i1, i2, i3, i4, i5)
	int i1;
        int i2;
        int i3;
        int i4;
	int i5;
	CODE:
        point (i1, i2, i3, i4, i5);

void
Dislin_polar (xe, xor, xstp, yor, ystp)
        double xe;
        double xor;
        double xstp;
        double yor;
        double ystp;
        CODE:
        polar (xe, xor, xstp, yor, ystp);

void
Dislin_polcrv (s)
	char *s;
	CODE:
	polcrv (s);

void
Dislin_polmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	polmod (s1, s2);

void
Dislin_pos2pt (x, y, xp, yp)
	double x;
	double y;
	double xp;
	double yp;
        CODE:
        float xpt, ypt;
        pos2pt (x, y, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_pos3pt (x, y, z, xp, yp, zp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
	double zp;
        CODE:
        float xpt, ypt, zpt;
        pos3pt (x, y, z, &xpt, &ypt, &zpt);
        xp = xpt;
        yp = ypt;
        zp = zpt;
        OUTPUT:
        xp
        yp
        zp

int
Dislin_posifl (i1, i2)
	int i1;
	int i2;
        CODE:
        RETVAL = posifl (i1, i2);
        OUTPUT:
        RETVAL

void
Dislin_projct (s)
	char *s;
	CODE:
	projct (s);

void
Dislin_psfont (s)
	char *s;
	CODE:
	psfont (s);

void
Dislin_qplbar (x1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int i, n1;
        float *p1;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        qplbar (p1, n);
        Safefree (p1);

void
Dislin_qplclr (x1ray, nx, ny)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
        CODE:
        int i, ii, j, n1;
        float *p1;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, nx * ny, float);

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(x1ray,i,0));
          for (j = 0; j < ny; j++)
            p1[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        qplclr (p1, nx, ny);
        Safefree (p1);

void
Dislin_qplcon (x1ray, nx, ny, nlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
        int nlev; 
        CODE:
        int i, ii, j, n1;
        float *p1;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, nx * ny, float);

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(x1ray,i,0));
          for (j = 0; j < ny; j++)
            p1[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        qplcon (p1, nx, ny, nlev);
        Safefree (p1);

void
Dislin_qplot (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        qplot (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_qplpie (x1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int i, n1;
        float *p1;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        qplpie (p1, n);
        Safefree (p1);

void
Dislin_qplsca (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        qplsca (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_qplsur (x1ray, nx, ny)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
        CODE:
        int i, ii, j, n1;
        float *p1;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, nx * ny, float);

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(x1ray,i,0));
          for (j = 0; j < ny; j++)
            p1[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        qplsur (p1, nx, ny);
        Safefree (p1);

void
Dislin_rbmp (s)
	char *s;
	CODE:
	rbmp (s);

int
Dislin_rbfpng (s, nmax)
	char *s;
        int nmax;
        CODE:
        char *p;
        int n;

        if (nmax != 0)
        { New (1, p, nmax, char);
        }

        n = rbfpng (p, nmax);
        RETVAL = n;
        if (nmax != 0 && n > 0)
        { sv_setpvn ((SV*) ST(0), p, n);
        }  
        if (nmax != 0) Safefree (p);
        OUTPUT:
        RETVAL

int
Dislin_readfl (nu, n1ray, nbyte)
	AV * n1ray = (AV *)SvRV(ST(0));
        int nu;
	int nbyte;
        CODE:
        char *p1;
        int n1; 
        int i;
        New (1, p1, nbyte, char);
        n1 = readfl (nu, (unsigned char *) p1, nbyte);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));
        Safefree (p1);

        RETVAL=n1;
        OUTPUT:
        RETVAL

void
Dislin_reawgt ()
	CODE:
        reawgt ();      

void
Dislin_recfll (i1, i2, i3, i4, i5)
	int i1;
        int i2;
        int i3;
        int i4;
	int i5;
	CODE:
        recfll (i1, i2, i3, i4, i5);

void
Dislin_rectan (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        rectan (i1, i2, i3, i4);

void
Dislin_rel3pt (x, y, z, xp, yp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
        CODE:
        float xpt, ypt;
        rel3pt (x, y, z, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_resatt ()
	CODE:
	resatt ();

void
Dislin_reset (s)
	char *s;
	CODE:
	reset (s);

void
Dislin_revscr ()
	CODE:
	revscr ();

void
Dislin_rgbhsv (x, y, z, xp, yp, zp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
	double zp;
        CODE:
        float xpt, ypt, zpt;
        rgbhsv (x, y, z, &xpt, &ypt, &zpt);
        xp = xpt;
        yp = ypt;
        zp = zpt;
        OUTPUT:
        xp
        yp
        zp

void
Dislin_rgtlab ()
	CODE:
	rgtlab ();

void
Dislin_rimage (s)
	char *s;
	CODE:
	rimage (s);

void
Dislin_rlarc (x1, x2, x3, x4, x5, x6, x7)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	double x6;
	double x7;
	CODE:
	rlarc (x1, x2, x3, x4, x5, x6, x7);

void
Dislin_rlarea (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        rlarea (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_rlcirc (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	rlcirc (x1, x2, x3);

void
Dislin_rlconn (x1, x2)
	double x1;
	double x2;
	CODE:
	rlconn (x1, x2);

void
Dislin_rlell (x1, x2, x3, x4)
	double x1;
	double x2;
	double x3;
	double x4;
	CODE:
	rlell (x1, x2, x3, x4);

void
Dislin_rline (x1, x2, x3, x4)
	double x1;
	double x2;
	double x3;
	double x4;
	CODE:
	rline (x1, x2, x3, x4);

void
Dislin_rlmess (s, x1, x2)
	char *s;
	double x1;
	double x2;
	CODE:
	rlmess (s, x1, x2);

void
Dislin_rlnumb (x1, i, x2, x3)
	double x1;
	int i;
	double x2;
	double x3;
	CODE:
	rlnumb (x1, i, x2, x3);

void
Dislin_rlpie (x1, x2, x3, x4, x5)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	CODE:
	rlpie (x1, x2, x3, x4, x5);

void
Dislin_rlpoin (x1, x2, i1, i2, i3)
	double x1;
	double x2;
	int i1;
	int i2;
	int i3;
	CODE:
	rlpoin (x1, x2, i1, i2, i3);

void
Dislin_rlrec (x1, x2, x3, x4)
	double x1;
	double x2;
	double x3;
	double x4;
	CODE:
	rlrec (x1, x2, x3, x4);

void
Dislin_rlrnd (x1, x2, x3, x4, i)
	double x1;
	double x2;
	double x3;
	double x4;
	int i;
	CODE:
	rlrnd (x1, x2, x3, x4, i);

void
Dislin_rlsec (x1, x2, x3, x4, x5, x6, i)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	double x6;
	int i;
	CODE:
	rlsec (x1, x2, x3, x4, x5, x6, i);

void
Dislin_rlstrt (x1, x2)
	double x1;
	double x2;
	CODE:
	rlstrt (x1, x2);

void
Dislin_rlsymb (i, x1, x2)
	int i;
	double x1;
	double x2;
	CODE:
	rlsymb (i, x1, x2);

void
Dislin_rlvec (x1, x2, x3, x4, i)
	double x1;
	double x2;
	double x3;
	double x4;
	int i;
	CODE:
	rlvec (x1, x2, x3, x4, i);

void
Dislin_rlwind (x1, x2, x3, i1, x4)
        double x1;
        double x2;
        double x3;
	int i1;
        double x4; 
	CODE:
        rlwind (x1, x2, x3, i1, x4);

void
Dislin_rndrec (i1, i2, i3, i4, i5)
	int i1;
        int i2;
        int i3;
        int i4;
	int i5;
	CODE:
        rndrec (i1, i2, i3, i4, i5);

int
Dislin_rpixel (i1, i2)
	int i1;
	int i2;
        CODE:
        int iclr;
        rpixel (i1, i2, &iclr);
        RETVAL = iclr;
        OUTPUT:
        RETVAL

void
Dislin_rpixls (n1ray, i1, i2, i3, i4)
	AV * n1ray = (AV *)SvRV(ST(0));
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int i, n1, n;
        char *p1;
        n1 = i3 * i4;
        New (1, p1, n1, char);
	rpixls ((unsigned char *) p1, i1, i2, i3, i4);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));
        Safefree (p1);

void
Dislin_rpng (s)
	char *s;
	CODE:
	rpng (s);

void
Dislin_rppm (s)
	char *s;
	CODE:
	rppm (s);

void
Dislin_rpxrow (n1ray, i1, i2, i3)
	AV * n1ray = (AV *)SvRV(ST(0));
	int i1;
	int i2;
	int i3;
	CODE:
        int i, n1;
        char *p1;
        n1 = i3;
        New (1, p1, n1, char);
	rpxrow ((unsigned char *) p1, i1, i2, i3);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));
        Safefree (p1);

void
Dislin_rtiff (s)
	char *s;
	CODE:
	rtiff (s);

void
Dislin_rvynam ()
	CODE:
	rvynam ();

void
Dislin_scale (s1, s2)
	char *s1;
	char *s2;
	CODE:
	scale (s1, s2);

void
Dislin_sclfac (x)
	double x;
	CODE:
	sclfac (x);

void
Dislin_sclmod (s)
	char *s;
	CODE:
	sclmod (s);

void
Dislin_scrmod (s)
	char *s;
	CODE:
	scrmod (s);

void
Dislin_sector (i1, i2, i3, i4, x1, x2, i5)
	int i1;
        int i2;
        int i3;
	int i4;
	double x1;
	double x2;
	int i5;
	CODE:
        sector (i1, i2, i3, i4, x1, x2, i5);

void
Dislin_selwin (i)
	int i;
	CODE:
	selwin (i);

void
Dislin_sendbf ()
	CODE:
	sendbf ();

void
Dislin_sendmb ()
	CODE:
	sendmb ();

void
Dislin_sendok ()
	CODE:
	sendok ();


void
Dislin_serif ()
	CODE:
	serif ();

void
Dislin_setbas (x)
	double x;
	CODE:
	setbas (x);

void
Dislin_setcbk (s1, s2)
	char *s1;
        char *s2;
	CODE:
        strcpy (cbmypr, s1);
        setcbk (dis_callbck2, s2);

void
Dislin_setclr (i)
	int i;
	CODE:
	setclr (i);

void
Dislin_setexp (x)
	double x;
	CODE:
	setexp (x);

void
Dislin_setfil (s)
	char *s;
	CODE:
	setfil (s);

void
Dislin_setgrf (s1, s2, s3, s4)
	char *s1;
	char *s2;
	char *s3;
	char *s4;
	CODE:
	setgrf (s1, s2, s3, s4);

void
Dislin_setind (i, x1, x2, x3)
	int i;
	double x1;
	double x2;
	double x3;
	CODE:
	setind (i, x1, x2, x3);

void
Dislin_setmix (s1, s2)
	char *s1;
	char *s2;
	CODE:
	setmix (s1, s2);

void
Dislin_setpag (s)
	char *s;
	CODE:
	setpag (s);

void
Dislin_setres (i1, i2)
	int i1;
	int i2;
	CODE:
	setres (i1, i2);

void
Dislin_setrgb (xr, xg, xb)
	double xr;
	double xg;
	double xb;
	CODE:
	setrgb (xr, xg, xb);

void
Dislin_setscl (x1ray, n, s)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	char *s;
        CODE:
        int i, n1;
        float *p1;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        setscl (p1, n, s);
        Safefree (p1);

void
Dislin_setvlt (s)
	char *s;
	CODE:
	setvlt (s);

void
Dislin_setxid (i, s)
	int i;
	char *s;
	CODE:
	setxid (i, s);

void
Dislin_shdcha ()
	CODE:
	shdcha ();

void
Dislin_shdcrv (x1ray, x2ray, n, x3ray, x4ray, m)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * x3ray = (AV *)SvRV(ST(3));
	AV * x4ray = (AV *)SvRV(ST(4));
        int m;
        CODE:
        int i, n1, n2, n3, n4;
        float *p1, *p2, *p3, *p4;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (x4ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (float) SvNV(*av_fetch(x4ray,i,0));

        shdcrv (p1, p2, n, p3, p4, m);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_shdeur (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1, n2, n3;
        int *p1, *p3;
        long *p2;
        n1 = (int) av_len (n1ray) + 1;
        n2 = (int) av_len (n2ray) + 1;
        n3 = (int) av_len (n3ray) + 1;
        New (1, p1, n1, int);
        New (1, p2, n2, long);
        New (1, p3, n3, int);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (long) SvIV(*av_fetch(n2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (int) SvIV(*av_fetch(n3ray,i,0));

        shdeur (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shdmap (s)
	char *s;
	CODE:
	shdmap (s);

void
Dislin_shdmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	shdmod (s1, s2);

void
Dislin_shdpat (i)
	int i;
	CODE:
	shdpat (i);

void
Dislin_shdusa (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int i, n1, n2, n3;
        int *p1, *p3;
        long *p2;
        n1 = (int) av_len (n1ray) + 1;
        n2 = (int) av_len (n2ray) + 1;
        n3 = (int) av_len (n3ray) + 1;
        New (1, p1, n1, int);
        New (1, p2, n2, long);
        New (1, p3, n3, int);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (long) SvIV(*av_fetch(n2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (int) SvIV(*av_fetch(n3ray,i,0));

        shdusa (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shield (s1, s2)
	char *s1;
	char *s2;
	CODE:
	shield (s1, s2);

void
Dislin_shlcir (i1, i2, i3)
	int i1;
        int i2;
        int i3;
	CODE:
        shlcir (i1, i2, i3);

void
Dislin_shldel (i)
	int i;
	CODE:
	shldel (i);

void
Dislin_shlell (i1, i2, i3, i4, x)
	int i1;
        int i2;
        int i3;
        int i4;
	double x;
	CODE:
        shlell (i1, i2, i3, i4, x);

int
Dislin_shlind ()
        CODE:
        RETVAL = shlind ();
        OUTPUT:
        RETVAL

void
Dislin_shlpie (i1, i2, i3, x1, x2)
	int i1;
        int i2;
        int i3;
        double x1;
	double x2;
	CODE:
        shlpie (i1, i2, i3, x1, x2);

void
Dislin_shlpol (n1ray, n2ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        int *p1, *p2;
        n1 = (int) av_len (n1ray) + 1;
        n2 = (int) av_len (n2ray) + 1;
        New (1, p1, n1, int);
        New (1, p2, n2, int);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (int) SvIV(*av_fetch(n2ray,i,0));

        shlpol (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_shlrct (i1, i2, i3, i4, x)
	int i1;
        int i2;
        int i3;
        int i4;
	double x;
	CODE:
        shlrct (i1, i2, i3, i4, x);

void
Dislin_shlrec (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        shlrec (i1, i2, i3, i4);

void
Dislin_shlres (i)
	int i;
	CODE:
	shlres (i);

void
Dislin_shlsur ()
	CODE:
	shlsur ();

void
Dislin_shlvis (i, s)
	int i;
	char *s;
	CODE:
	shlvis (i, s);

void
Dislin_simplx ()
	CODE:
	simplx ();

int
Dislin_skipfl (i1, i2)
	int i1;
	int i2;
        CODE:
        RETVAL = skipfl (i1, i2);
        OUTPUT:
        RETVAL
 
void
Dislin_smxalf (s1, s2, s3, i)
	char *s1;
	char *s2;
	char *s3;
	int i;
	CODE:
	smxalf (s1, s2, s3, i);

void
Dislin_solid ()
	CODE:
	solid ();

void
Dislin_sortr1 (x1ray, n, s)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	char *s;
        CODE:
        int i, n1;
        float *p1;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        sortr1 (p1, n, s);
        for (i = 0; i < n1; i++)
          av_store(x1ray,i,newSVnv ((double) p1[i]));

        Safefree (p1);

void
Dislin_sortr2 (x1ray, x2ray, n, s)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	char *s;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        sortr2 (p1, p2, n, s);
        for (i = 0; i < n1; i++)
          av_store(x1ray,i,newSVnv ((double) p1[i]));
        for (i = 0; i < n2; i++)
          av_store(x2ray,i,newSVnv ((double) p2[i]));

        Safefree (p1);
        Safefree (p2);

void
Dislin_sphe3d (x1, x2, x3, x4, i1, i2)
	double x1;
	double x2;
	double x3;
	double x4;
        int i1;
        int i2;
	CODE:
	sphe3d (x1, x2, x3, x4, i1, i2);

int
Dislin_spline (x1ray, x2ray, n, x3ray, x4ray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * x3ray = (AV *)SvRV(ST(3));
	AV * x4ray = (AV *)SvRV(ST(4));
        CODE:
        int i, n1, n2, n3 = 10000, npt;
        float *p1, *p2, *p3, *p4;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n3, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        spline (p1, p2, n, p3, p4, &npt);
        av_extend (x3ray, npt);
        av_extend (x4ray, npt);
        for (i = 0; i < npt; i++)
        { av_store(x3ray,i,newSVnv ((double) p3[i]));
          av_store(x4ray,i,newSVnv ((double) p4[i]));
        }

        RETVAL = npt;
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        OUTPUT:
        RETVAL

void
Dislin_splmod (i1, i2)
	int i1;
	int i2;
	CODE:
	splmod (i1, i2);

void
Dislin_strt3d (x1, x2, x3)
	double x1;
	double x2;
        double x3;
	CODE:
	strt3d (x1, x2, x3);

void
Dislin_strtpt (x1, x2)
	double x1;
	double x2;
	CODE:
	strtpt (x1, x2);

void
Dislin_surclr (i1, i2)
	int i1;
	int i2;
	CODE:
	surclr (i1, i2);

void
Dislin_surfce (x1ray, nx, x2ray, ny, xmat)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
        CODE:
        int i, ii, j, n1, n2;
        float *p1, *p2, *p3;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, nx * ny, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(xmat,i,0));
          for (j = 0; j < ny; j++)
            p3[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        surfce (p1, nx, p2, ny, p3);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_surfcp (s, a1, a2, a3, b1, b2, b3)
	char *s;
        double a1;
        double a2;
        double a3;
        double b1;
        double b2;
        double b3;
	CODE:
        strcpy (cbfunc, s);
        surfcp (dis_funcbck, a1, a2, a3, b1, b2, b3);

void
Dislin_surfun (s, i1, a1, i2, a2)
	char *s;
        int i1;
        double a1;
        int i2;
        double a2;
	CODE:
        strcpy (cbfunc, s);
        surfun (dis_func2bck, i1, a1, i2, a2);

void
Dislin_suriso (x1ray, nx, x2ray, ny, x3ray, nz, wmat, wlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * x3ray = (AV *)SvRV(ST(4));
	int nz;
	AV * wmat = (AV *)SvRV(ST(6));
        double wlev;
        CODE:
        int i, ii, j, k, kk, n1, n2, n3;
        float *p1, *p2, *p3, *p4;
        AV *p, *pp;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, nx * ny * nz, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));

        kk = 0;
        for (i = 0; i < nx; i++)
        { p = (AV *) SvIV(*av_fetch(wmat,i,0));
          for (j = 0; j < ny; j++)
          { pp = (AV *) SvIV(*av_fetch(p,j,0));
            for (k = 0; k < nz; k++)
            { p4[kk] = (float) SvNV(*av_fetch(pp,k,0));
              kk++;
            }
          }
        }

        suriso (p1, nx, p2, ny, p3, nz, p4, wlev);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_surmat (x1ray, nx, ny, ixpts, iypts)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
	int ixpts;
	int iypts;
        CODE:
        int i, ii, j, n1;
        float *p1;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, nx * ny, float);

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(x1ray,i,0));
          for (j = 0; j < ny; j++)
            p1[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        surmat (p1, nx, ny, ixpts, iypts);
        Safefree (p1);

void
Dislin_surtri (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
        CODE:
        int i, n1, n2, n3, n4, n5, n6;
        float *p1, *p2, *p3;
        int *p4, *p5, *p6;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (n1ray) + 1;
        n5 = (int) av_len (n2ray) + 1;
        n6 = (int) av_len (n3ray) + 1;

        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, int);
        New (1, p5, n5, int);
        New (1, p6, n6, int);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n5; i++)
          p5[i] = (int) SvIV(*av_fetch(n2ray,i,0));
        for (i = 0; i < n5; i++)
          p6[i] = (int) SvIV(*av_fetch(n3ray,i,0));

        surtri (p1, p2, p3, n, p4, p5, p6, ntri);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_surmsh (s)
	char *s;
	CODE:
	surmsh (s);

void
Dislin_suropt (s)
	char *s;
	CODE:
	suropt (s);

void
Dislin_surshd (x1ray, nx, x2ray, ny, xmat)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
        CODE:
        int i, ii, j, n1, n2;
        float *p1, *p2, *p3;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, nx * ny, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(xmat,i,0));
          for (j = 0; j < ny; j++)
            p3[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        surshd (p1, nx, p2, ny, p3);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_sursze (x1, x2, x3, x4)
	double x1;
	double x2;
        double x3;
	double x4;
	CODE:
	sursze (x1, x2, x3, x4);

void
Dislin_survis (s)
	char *s;
	CODE:
	survis (s);

void
Dislin_swapi2 (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int i, n1;
        short *p1;
        n1 = (int) av_len (n1ray) + 1;
        New (1, p1, n1, short);

        for (i = 0; i < n1; i++)
          p1[i] = (short) SvIV(*av_fetch(n1ray,i,0));

        swapi2 (p1, n);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));

        Safefree (p1);

void
Dislin_swapi4 (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int i, n1;
        int *p1;
        n1 = (int) av_len (n1ray) + 1;
        New (1, p1, n1, int);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

        swapi4 (p1, n);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));

        Safefree (p1);

void
Dislin_swgatt (i, s1, s2)
        int i;
	char *s1;
	char *s2;
	CODE:
	swgatt (i, s1, s2);

void
Dislin_swgbox (i1, i2)
	int i1;
	int i2;
	CODE:
	swgbox (i1, i2);

void
Dislin_swgbut (i1, i2)
	int i1;
	int i2;
	CODE:
	swgbut (i1, i2);

void
Dislin_swgcbk (i, s)
	int i;
	char *s;
	CODE:
        int n;
        char *p;
        n = strlen (s);
        New (1, p, n + 1, char);
        strcpy (p, s);
        if (ncbray < MAX_CB)
        { cbray[ncbray] = p;
          icbray[ncbray] = i;
          ncbray++;
          swgcbk (i, dis_callbck);
        }

void
Dislin_swgclr (x1, x2, x3, s)
	double x1;
	double x2;
	double x3;
        char *s;
	CODE:
	swgclr (x1, x2, x3, s);

void
Dislin_swgdrw (x)
	double x;
	CODE:
	swgdrw (x);

void
Dislin_swgfil (i, s)
	int i;
	char *s;
	CODE:
	swgfil (i, s);

void
Dislin_swgfnt (s, i)
	char *s;
        int i;
	CODE:
	swgfnt (s, i);

void
Dislin_swghlp (s)
	char *s;
	CODE:
	swghlp (s);

void
Dislin_swgjus (s1, s2)
	char *s1;
	char *s2;
	CODE:
	swgjus (s1, s2);

void
Dislin_swglis (i1, i2)
	int i1;
	int i2;
	CODE:
	swglis (i1, i2);

void
Dislin_swgmix (s1, s2)
	char *s1;
	char *s2;
	CODE:
	swgmix (s1, s2);

void
Dislin_swgmod (s)
	char *s;
	CODE:
	swgmod (s);

void
Dislin_swgmrg (i, s)
	int i;
	char *s;
	CODE:
	swgmrg (i, s);

void
Dislin_swgoff (i1, i2)
	int i1;
	int i2;
	CODE:
	swgoff (i1, i2);

void
Dislin_swgopt (s1, s2)
	char *s1;
	char *s2;
	CODE:
	swgopt (s1, s2);

void
Dislin_swgpop (s)
	char *s;
	CODE:
	swgpop (s);

void
Dislin_swgpos (i1, i2)
	int i1;
	int i2;
	CODE:
	swgpos (i1, i2);

void
Dislin_swgscl (i, x)
	int i;
	double x;
	CODE:
	swgscl (i, x);

void
Dislin_swgsiz (i1, i2)
	int i1;
	int i2;
	CODE:
	swgsiz (i1, i2);

void
Dislin_swgspc (x, y)
	double x;
        double y;
	CODE:
	swgspc (x, y);

void
Dislin_swgstp (x)
	double x;
	CODE:
	swgstp (x);

void
Dislin_swgtit (s)
	char *s;
	CODE:
	swgtit (s);

void
Dislin_swgtxt (i, s)
	int i;
	char *s;
	CODE:
	swgtxt (i, s);

void
Dislin_swgtyp (s1, s2)
	char *s1;
	char *s2;
	CODE:
	swgtyp (s1, s2);

void
Dislin_swgwin (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        swgwin (i1, i2, i3, i4);

void
Dislin_swgwth (i)
	int i;
	CODE:
	swgwth (i);

void
Dislin_symbol (i1, i2, i3)
	int i1;
	int i2;
	int i3;
	CODE:
	symbol (i1, i2, i3);

void
Dislin_symfil (s1, s2)
	char *s1;
	char *s2;
	CODE:
	symfil (s1, s2);

void
Dislin_symrot (x)
	double x;
	CODE:
	symrot (x);

int
Dislin_tellfl (i)
	int i;
        CODE:
        RETVAL = tellfl (i);
        OUTPUT:
        RETVAL

void
Dislin_thkcrv (i)
	int i;
	CODE:
	thkcrv (i);

void
Dislin_ticks (i, s)
	int i;
	char *s;
	CODE:
	ticks (i, s);

void
Dislin_ticlen (i1, i2)
	int i1;
	int i2;
	CODE:
	ticlen (i1, i2);

void
Dislin_ticmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	ticmod (s1, s2);

void
Dislin_ticpos (s1, s2)
	char *s1;
	char *s2;
	CODE:
	ticpos (s1, s2);

void
Dislin_tifmod (i1, s1, s2)
	int i1;
	char *s1;
	char *s2;
	CODE:
	tifmod (i1, s1, s2);

void
Dislin_tiforg (i1, i2)
	int i1;
	int i2;
	CODE:
	tiforg (i1, i2);

void
Dislin_tifwin (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        tifwin (i1, i2, i3, i4);

void
Dislin_timopt ()
	CODE:
	timopt ();

void
Dislin_titjus (s)
	char *s;
	CODE:
	titjus (s);

void
Dislin_title ()
	CODE:
	title ();

void
Dislin_titlin (s, i)
	char *s;
	int i;
	CODE:
	titlin (s, i);

void
Dislin_titpos (s)
	char *s;
	CODE:
	titpos (s);

void
Dislin_trfco1 (x1ray, n, s1, s2)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	char *s1;
	char *s2;
        CODE:
        int i, n1;
        float *p1;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));

        trfco1 (p1, n, s1, s2);
        for (i = 0; i < n1; i++)
          av_store(x1ray,i,newSVnv ((double) p1[i]));

        Safefree (p1);

void
Dislin_trfco2 (x1ray, x2ray, n, s1, s2)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	char *s1;
	char *s2;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        trfco2 (p1, p2, n, s1, s2);
        for (i = 0; i < n1; i++)
          av_store(x1ray,i,newSVnv ((double) p1[i]));
        for (i = 0; i < n2; i++)
          av_store(x2ray,i,newSVnv ((double) p2[i]));

        Safefree (p1);
        Safefree (p2);

void
Dislin_trfco3 (x1ray, x2ray, x3ray, n, s1, s2)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	char *s1;
	char *s2;
        CODE:
        int i, n1, n2, n3;
        float *p1, *p2, *p3;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));

        trfco3 (p1, p2, p3, n, s1, s2);
        for (i = 0; i < n1; i++)
          av_store(x1ray,i,newSVnv ((double) p1[i]));
        for (i = 0; i < n2; i++)
          av_store(x2ray,i,newSVnv ((double) p2[i]));
        for (i = 0; i < n3; i++)
          av_store(x3ray,i,newSVnv ((double) p3[i]));

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_trfdat (i1, i2, i3, i4)
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int j1, j2, j3;
        trfdat (i1, &j1, &j2, &j3);
        i2 = j1;
        i3 = j2;
        i4 = j3;
        OUTPUT:
        i2
        i3
        i4

void
Dislin_trfmat (x1ray, nx, ny, xmat, nx2, ny2)
	AV * x1ray = (AV *)SvRV(ST(0));
	int nx;
        int ny;
	AV * xmat = (AV *)SvRV(ST(3));
	int nx2;
        int ny2;
        CODE:
        int i, ii, j, n1;
        float *p1, *p2;
        AV *p;
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, nx * ny, float);
        New (1, p2, nx2 * ny2, float);

        for (i = 0; i < nx; i++)
        { ii = i * ny;
          p = (AV *) SvIV(*av_fetch(x1ray,i,0));
          for (j = 0; j < ny; j++)
            p1[j+ii] = (float) SvNV(*av_fetch(p,j,0));
        }

        trfmat (p1, nx, ny, p2, nx2, ny2);

        av_extend (xmat, nx2 * ny2);
        for (i = 0; i < nx2; i++)
        { ii = i * ny2;
          p = (AV *) SvIV(*av_fetch(xmat,i,0));
          for (j = 0; j < ny2; j++)
            av_store (p,j, newSVnv ((double) p2[j+ii]));
        }

        Safefree (p1);
        Safefree (p2);

void
Dislin_trfrel (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int i, n1, n2;
        float *p1, *p2;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));

        trfrel (p1, p2, n);
        for (i = 0; i < n1; i++)
          av_store(x1ray,i,newSVnv ((double) p1[i]));
        for (i = 0; i < n2; i++)
          av_store(x2ray,i,newSVnv ((double) p2[i]));

        Safefree (p1);
        Safefree (p2);

void
Dislin_trfres ()
	CODE:
	trfres ();

void
Dislin_trfrot (x, i1, i2)
	double x;
	int i1;
	int i2;
	CODE:
	trfrot (x, i1, i2);

void
Dislin_trfscl (x1, x2)
	double x1;
	double x2;
	CODE:
	trfscl (x1, x2);

void
Dislin_trfshf (i1, i2)
	int i1;
	int i2;
	CODE:
	trfshf (i1, i2);

int
Dislin_triang (x1ray, x2ray, n, n1ray, n2ray, n3ray, nmax)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * n1ray = (AV *)SvRV(ST(3));
	AV * n2ray = (AV *)SvRV(ST(4));
	AV * n3ray = (AV *)SvRV(ST(5));
        int nmax;
        CODE:
        int i, n1, n2, ntri;
        float *p1, *p2;
        int *p3, *p4, *p5; 
        n1 = (int) av_len (x1ray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n1, float);
        n2 = (int) av_len (n1ray) + 1;
        New (1, p3, n2, int);
        New (1, p4, n2, int);
        New (1, p5, n2, int);

        for (i = 0; i < n1; i++)
        { p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        }
        ntri = triang (p1, p2, n, p3, p4, p5, nmax);

        for (i = 0; i < ntri; i++)
        { av_store(n1ray,i,newSViv ((int) p3[i]));
          av_store(n2ray,i,newSViv ((int) p4[i]));
          av_store(n3ray,i,newSViv ((int) p5[i]));
        } 
        RETVAL = ntri;
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        OUTPUT:
        RETVAL

void
Dislin_triplx ()
	CODE:
	triplx ();

int
Dislin_tripts (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri, zlev,xpts, ypts, maxpts, nray, maxray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
        double zlev;
	AV * xpts = (AV *)SvRV(ST(9));
	AV * ypts = (AV *)SvRV(ST(10));
        int maxpts;
	AV * nray = (AV *)SvRV(ST(12));
        int maxray;
        CODE:
        int i, n1, n2, n3, n4, n5, n6, nn, nlins;
        float *p1, *p2, *p3, *p7, *p8;
        int *p4, *p5, *p6, *p9;
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (n1ray) + 1;
        n5 = (int) av_len (n2ray) + 1;
        n6 = (int) av_len (n3ray) + 1;

        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, int);
        New (1, p5, n5, int);
        New (1, p6, n6, int);
        New (1, p7, maxpts, float);
        New (1, p8, maxpts, float);
        New (1, p9, maxray, int);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n4; i++)
          p4[i] = (int) SvIV(*av_fetch(n1ray,i,0));
        for (i = 0; i < n5; i++)
          p5[i] = (int) SvIV(*av_fetch(n2ray,i,0));
        for (i = 0; i < n5; i++)
          p6[i] = (int) SvIV(*av_fetch(n3ray,i,0));

        tripts (p1, p2, p3, n, p4, p5, p6, ntri, zlev, p7, p8, maxpts, p9,
                maxray, &nlins);
        nn = 0; 
        for (i = 0; i < nlins; i++)
           nn += p9[i];
 
        av_extend (xpts, nn);
        av_extend (ypts, nn);
        av_extend (nray, nlins);
        for (i = 0; i < nn; i++)
        { av_store(xpts,i,newSVnv ((double) p7[i]));
          av_store(ypts,i,newSVnv ((double) p8[i]));
        }
        for (i = 0; i < nlins; i++)
          av_store(nray,i,newSViv ((int) p9[i]));

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);
        Safefree (p8);
        Safefree (p9);
        RETVAL = nlins;
        OUTPUT:
        RETVAL

int
Dislin_trmlen (s)
	char *s;
        CODE:
        RETVAL = trmlen (s);
        OUTPUT:
        RETVAL

void
Dislin_texmod (s)
	char *s;
	CODE:
	texmod (s);

void
Dislin_texopt (s1, s2)
	char *s1;
	char *s2;
	CODE:
	texopt (s1, s2);

void
Dislin_txtjus (s)
	char *s;
	CODE:
	txtjus (s);

void
Dislin_unit (i)
	int i;
	CODE:
        if (i == 0)
          unit (NULL);
        else
          unit ((void *) stdout);

void
Dislin_units (s)
	char *s;
	CODE:
	units (s);

void
Dislin_upstr (s)
	char *s;
        CODE:
        upstr (s);
        OUTPUT:
        s

void
Dislin_vang3d (x)
	double x;
	CODE:
	vang3d (x);

void
Dislin_vclp3d (x1, x2)
	double x1;
	double x2;
	CODE:
	vclp3d (x1, x2);

void
Dislin_vector (i1, i2, i3, i4, i5)
	int i1;
        int i2;
        int i3;
        int i4;
	int i5;
	CODE:
        vector (i1, i2, i3, i4, i5);

void
Dislin_vectr3 (x1, x2, x3, x4, x5, x6, i)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	double x6;
	int i;
	CODE:
        vectr3 (x1, x2, x3, x4, x5, x6, i);

void
Dislin_vfoc3d (x1, x2, x3, s)
	double x1;
	double x2;
	double x3;
	char *s;
	CODE:
        vfoc3d (x1, x2, x3, s);

void
Dislin_view3d (x1, x2, x3, s)
	double x1;
	double x2;
	double x3;
	char *s;
	CODE:
        view3d (x1, x2, x3, s);

void
Dislin_vkxbar (i)
	int i;
	CODE:
	vkxbar (i);

void
Dislin_vkybar (i)
	int i;
	CODE:
	vkybar (i);

void
Dislin_vkytit (i)
	int i;
	CODE:
	vkytit (i);

void
Dislin_vup3d (x)
	double x;
	CODE:
	vup3d (x);

int
Dislin_wgapp (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgapp (ip, s);
        OUTPUT:
        RETVAL

int
Dislin_wgbas (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgbas (ip, s);
        OUTPUT:
        RETVAL


int
Dislin_wgbox (ip, s, i)
	int ip;
	char *s;
	int i;
        CODE:
        RETVAL = wgbox (ip, s, i);
        OUTPUT:
        RETVAL

int
Dislin_wgbut (ip, s, i)
	int ip;
	char *s;
	int i;
        CODE:
        RETVAL = wgbut (ip, s, i);
        OUTPUT:
        RETVAL

int
Dislin_wgcmd (ip, s1, s2)
	int ip;
	char *s1;
	char *s2;
        CODE:
        RETVAL = wgcmd (ip, s1, s2);
        OUTPUT:
        RETVAL

int
Dislin_wgdlis (ip, s, i)
	int ip;
	char *s;
	int i;
        CODE:
        RETVAL = wgdlis (ip, s, i);
        OUTPUT:
        RETVAL

int
Dislin_wgdraw (ip)
	int ip;
        CODE:
        RETVAL = wgdraw (ip);
        OUTPUT:
        RETVAL

int
Dislin_wgfil (ip, s1, s2, s3)
	int ip;
	char *s1;
	char *s2;
	char *s3;
        CODE:
        RETVAL = wgfil (ip, s1, s2, s3);
        OUTPUT:
        RETVAL

void
Dislin_wgfin ()
	CODE:
	wgfin ();

int
Dislin_wgini (s)
	char *s;
        CODE:
        RETVAL = wgini (s);
        OUTPUT:
        RETVAL

int
Dislin_wglab (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wglab (ip, s);
        OUTPUT:
        RETVAL

int
Dislin_wglis (ip, s, i)
	int ip;
	char *s;
	int i;
        CODE:
        RETVAL = wglis (ip, s, i);
        OUTPUT:
        RETVAL

int
Dislin_wgok (ip)
	int ip;
        CODE:
        RETVAL = wgok (ip);
        OUTPUT:
        RETVAL

int
Dislin_wgpop (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgpop (ip, s);
        OUTPUT:
        RETVAL

int
Dislin_wgquit (ip)
	int ip;
        CODE:
        RETVAL = wgquit (ip);
        OUTPUT:
        RETVAL

int
Dislin_wgltxt (ip, s1, s2, i)
	int ip;
	char *s1;
	char *s2;
	int i;
        CODE:
        RETVAL = wgltxt (ip, s1, s2, i);
        OUTPUT:
        RETVAL

int
Dislin_wgpbut (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgpbut (ip, s);
        OUTPUT:
        RETVAL

int
Dislin_wgscl (ip, s, x1, x2, x3, i)
	int ip;
	char *s;
	double x1;
	double x2;
	double x3;
	int i;
        CODE:
        RETVAL = wgscl (ip, s, x1, x2, x3, i);
        OUTPUT:
        RETVAL

int
Dislin_wgtxt (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgtxt (ip, s);
        OUTPUT:
        RETVAL

void
Dislin_widbar (i)
	int i;
	CODE:
	widbar (i);

void
Dislin_wimage (s)
	char *s;
	CODE:
	wimage (s);

void
Dislin_winapp (s)
	char *s;
	CODE:
	winapp (s);

void
Dislin_winfnt (s)
	char *s;
	CODE:
	winfnt (s);
  
void
Dislin_winkey (s)
	char *s;
	CODE:
	winkey (s);

void
Dislin_winmod (s)
	char *s;
	CODE:
	winmod (s);

void
Dislin_winopt (i, s)
	char *s;
        int i;
	CODE:
	winopt (i, s);

void
Dislin_windbr (x1, i1, i2, i3, x2)
        double x1;
	int i1;
        int i2;
        int i3;
        double x2; 
	CODE:
        windbr (x1, i1, i2, i3, x2);

void
Dislin_window (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        window (i1, i2, i3, i4);

int
Dislin_winid ()
        CODE:
        RETVAL = winid ();
        OUTPUT:
        RETVAL

void
Dislin_winsiz (i1, i2)
	int i1;
	int i2;
	CODE:
	winsiz (i1, i2);

void
Dislin_wintit (s)
	char *s;
	CODE:
	wintit (s);

void
Dislin_wmfmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	wmfmod (s1, s2);


void
Dislin_world ()
	CODE:
	world ();

void
Dislin_wpixel (i1, i2, i3)
	int i1;
	int i2;
	int i3;
	CODE:
	wpixel (i1, i2, i3);

void
Dislin_wpixls (n1ray, i1, i2, i3, i4)
	AV * n1ray = (AV *)SvRV(ST(0));
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int i, n1;
        char *p1;
        n1 = (int) av_len (n1ray) + 1;

        New (1, p1, n1, char);
        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

	wpixls ((unsigned char *) p1, i1, i2, i3, i4);
        Safefree (p1);

void
Dislin_wpxrow (n1ray, i1, i2, i3)
	AV * n1ray = (AV *)SvRV(ST(0));
	int i1;
	int i2;
	int i3;
	CODE:
        int i, n1;
        char *p1;
        n1 = (int) av_len (n1ray) + 1;
        New (1, p1, n1, char);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

	wpxrow ((unsigned char *) p1, i1, i2, i3);
        Safefree (p1);

int
Dislin_writfl (nu, cbuf, nbyte)
        int nu;
	char *cbuf;
	int nbyte;
        CODE:
        RETVAL = writfl (nu, (unsigned char *) cbuf, nbyte);
        OUTPUT:
        RETVAL

void
Dislin_wtiff (s)
	char *s;
	CODE:
	wtiff (s);

void
Dislin_x11fnt (s1, s2)
	char *s1;
        char *s2;
	CODE:
	x11fnt (s1, s2);

void
Dislin_x11mod (s)
	char *s;
	CODE:
	x11mod (s);

double
Dislin_x2dpos (x, y)
	double x;
	double y;
        CODE:
        RETVAL = x2dpos (x, y);
        OUTPUT:
        RETVAL

double
Dislin_x3dabs (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = x3dabs (x, y, z);
        OUTPUT:
        RETVAL

double
Dislin_x3dpos (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = x3dpos (x, y, z);
        OUTPUT:
        RETVAL

double
Dislin_x3drel (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = x3drel (x, y, z);
        OUTPUT:
        RETVAL

void
Dislin_xaxgit ()
	CODE:
	xaxgit ();

void
Dislin_xaxis (xa, xe, xor, xstp, nl, s, it, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int nx;
	int ny;
	CODE:
	xaxis (xa, xe, xor, xstp, nl, s, it, nx, ny);

void
Dislin_xaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int nx;
	int ny;
	CODE:
	xaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny);

void
Dislin_xaxmap (xa, xe, xor, xstp, s, it, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	char *s;
	int it;
	int ny;
	CODE:
	xaxmap (xa, xe, xor, xstp, s, it, ny);

void
Dislin_xcross ()
	CODE:
	xcross ();

void
Dislin_xdraw (x1, x2)
	double x1;
	double x2;
	CODE:
	xdraw (x1, x2);

double
Dislin_xinvrs (ix)
	int ix;
        CODE:
        RETVAL = xinvrs (ix);
        OUTPUT:
        RETVAL

void
Dislin_xjdraw (x1, x2, i)
	double x1;
	double x2;
	int i;
	CODE:
	xjdraw (x1, x2, i);

void
Dislin_xmove (x1, x2)
	double x1;
	double x2;
	CODE:
	xmove (x1, x2);

double
Dislin_xposn (x)
	double x;
        CODE:
        RETVAL = xposn (x);
        OUTPUT:
        RETVAL

double
Dislin_y2dpos (x, y)
	double x;
	double y;
        CODE:
        RETVAL = y2dpos (x, y);
        OUTPUT:
        RETVAL

double
Dislin_y3dabs (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = y3dabs (x, y, z);
        OUTPUT:
        RETVAL

double
Dislin_y3dpos (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = y3dpos (x, y, z);
        OUTPUT:
        RETVAL

double
Dislin_y3drel (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = y3drel (x, y, z);
        OUTPUT:
        RETVAL

void
Dislin_yaxgit ()
	CODE:
	yaxgit ();

void
Dislin_yaxis (xa, xe, xor, xstp, nl, s, it, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int nx;
	int ny;
	CODE:
	yaxis (xa, xe, xor, xstp, nl, s, it, nx, ny);

void
Dislin_yaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int nx;
	int ny;
	CODE:
	yaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny);

void
Dislin_yaxmap (xa, xe, xor, xstp, s, it, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	char *s;
	int it;
	int ny;
	CODE:
	yaxmap (xa, xe, xor, xstp, s, it, ny);

void
Dislin_ycross ()
	CODE:
	ycross ();

double
Dislin_yinvrs (ix)
	int ix;
        CODE:
        RETVAL = yinvrs (ix);
        OUTPUT:
        RETVAL

double
Dislin_yposn (x)
	double x;
        CODE:
        RETVAL = yposn (x);
        OUTPUT:
        RETVAL

double
Dislin_z3dpos (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = z3dpos (x, y, z);
        OUTPUT:
        RETVAL

void
Dislin_zaxis (xa, xe, xor, xstp, nl, s, it, id, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int id;
	int nx;
	int ny;
	CODE:
	zaxis (xa, xe, xor, xstp, nl, s, it, id, nx, ny);

void
Dislin_zaxlg (xa, xe, xor, xstp, nl, s, it, id, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int id;
	int nx;
	int ny;
	CODE:
	zaxlg (xa, xe, xor, xstp, nl, s, it, id, nx, ny);

void
Dislin_zbffin ()
	CODE:
        zbffin ();      

int
Dislin_zbfini ()
        CODE:
        RETVAL = zbfini ();
        OUTPUT:
        RETVAL

void
Dislin_zbflin (x1, y1, z1, x2, y2, z2)
	double x1;
	double y1;
	double z1;
	double x2;
	double y2;
	double z2;
	CODE:
	zbflin (x1, y1, z1, x2, y2, z2);

void
Dislin_zbftri (x1ray, x2ray, x3ray, iray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * iray  = (AV *)SvRV(ST(3));
        CODE:
        int i, n1, n2, n3, n4;
        float *p1, *p2, *p3;
        int *p4;        
        n1 = (int) av_len (x1ray) + 1;
        n2 = (int) av_len (x2ray) + 1;
        n3 = (int) av_len (x3ray) + 1;
        n4 = (int) av_len (iray) + 1;
        New (1, p1, n1, float);
        New (1, p2, n2, float);
        New (1, p3, n3, float);
        New (1, p4, n4, int);

        for (i = 0; i < n1; i++)
          p1[i] = (float) SvNV(*av_fetch(x1ray,i,0));
        for (i = 0; i < n2; i++)
          p2[i] = (float) SvNV(*av_fetch(x2ray,i,0));
        for (i = 0; i < n3; i++)
          p3[i] = (float) SvNV(*av_fetch(x3ray,i,0));
        for (i = 0; i < n2; i++)
          p4[i] = (int) SvIV(*av_fetch(iray,i,0));

        zbftri (p1, p2, p3, p4);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_zscale (x1, x2)
	double x1;
	double x2;
	CODE:
	zscale (x1, x2);
