/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.renderer.PluginInfo;
import rogatkin.GranulatedLayout;
import rogatkin.Persistentable;
import rogatkin.Serializer;

public class PluginOptionsTab
extends JPanel
implements ActionListener,
Persistentable {
    public static final String SECNAME = "plugins";
    public static final String CLASS = "class";
    public static final String NAME = "name";
    public static final String TOOLTIP = "tooltip";
    public static final String DISABLED = "disabled";
    public static final String ALLDISABLED = "allDisabled";
    static final String DEF_NAME = "plug-in";
    Controller controller;
    JList l_plugins;
    JTextField tf_name;
    JTextField tf_class;
    JTextField tf_ttip;
    JCheckBox cb_disabled;
    JCheckBox cb_allDisabled;
    PluginList plugins;
    int lastSelected = -1;

    public PluginOptionsTab(Controller controller) {
        this.controller = controller;
        this.setLayout(new GranulatedLayout(14, 7, 20, 4, 8, 8, 1));
        this.plugins = new PluginList();
        this.l_plugins = new JList(this.plugins);
        this.add((Component)new JScrollPane(this.l_plugins), "0,1,5,5");
        this.add((Component)new JLabel("Name"), "7,0,5,1");
        this.tf_name = new JTextField();
        this.add((Component)this.tf_name, "7,1, 4");
        this.cb_disabled = new JCheckBox("Disabled");
        this.add((Component)this.cb_disabled, "11,1, 3");
        JButton jButton = new JButton("<");
        this.add((Component)jButton, "5,2, 2,1,12");
        jButton.addActionListener(this);
        this.add((Component)new JLabel("Class"), "7,2,5,1");
        this.tf_class = new JTextField();
        this.add((Component)this.tf_class, "7,3, 6");
        jButton = new JButton(">");
        this.add((Component)jButton, "5,4, 2,1,12");
        jButton.addActionListener(this);
        this.add((Component)new JLabel("Tool tip"), "7,4,5,1");
        this.tf_ttip = new JTextField();
        this.add((Component)this.tf_ttip, "7,5, 7");
        this.cb_allDisabled = new JCheckBox("All disabled");
        this.add((Component)this.cb_allDisabled, "2,6, 4");
        this.l_plugins.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = PluginOptionsTab.this.l_plugins.getSelectedIndex();
                if (n >= 0) {
                    PluginInfo pluginInfo = (PluginInfo)PluginOptionsTab.this.plugins.getElementAt(n);
                    PluginOptionsTab.this.tf_class.setText(pluginInfo.class_);
                    PluginOptionsTab.this.tf_name.setText(pluginInfo.name);
                    if (pluginInfo.tooltip != null) {
                        PluginOptionsTab.this.tf_ttip.setText(pluginInfo.tooltip);
                    } else {
                        PluginOptionsTab.this.tf_ttip.setText("");
                    }
                    PluginOptionsTab.this.cb_disabled.setSelected(pluginInfo.disabled);
                    if (PluginOptionsTab.this.lastSelected >= 0) {
                        pluginInfo = (PluginInfo)PluginOptionsTab.this.plugins.getElementAt(PluginOptionsTab.this.lastSelected);
                        pluginInfo.class_ = PluginOptionsTab.this.tf_class.getText();
                        pluginInfo.name = PluginOptionsTab.this.tf_name.getText();
                        pluginInfo.tooltip = PluginOptionsTab.this.tf_ttip.getText();
                        pluginInfo.disabled = PluginOptionsTab.this.cb_disabled.isSelected();
                    }
                    PluginOptionsTab.this.lastSelected = n;
                }
            }
        });
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getActionCommand() == "<") {
            this.plugins.add(new PluginInfo(this.tf_class.getText(), this.tf_name.getText(), this.tf_ttip.getText()));
        } else if (actionEvent.getActionCommand() == ">" && (n = this.l_plugins.getSelectedIndex()) >= 0) {
            this.tf_class.setText("");
            this.tf_name.setText("");
            this.tf_ttip.setText("");
            this.cb_disabled.setSelected(false);
            this.plugins.removeElementAt(n);
        }
        this.l_plugins.updateUI();
    }

    public void load() {
        String string;
        Serializer serializer = this.controller.getSerializer();
        int n = 1;
        while ((string = (String)serializer.getProperty(SECNAME, CLASS + n)) != null) {
            PluginInfo pluginInfo = new PluginInfo();
            pluginInfo.class_ = string;
            string = (String)serializer.getProperty(SECNAME, NAME + n);
            if (string == null) {
                string = DEF_NAME + n;
            }
            pluginInfo.name = string;
            pluginInfo.tooltip = (String)serializer.getProperty(SECNAME, TOOLTIP + n);
            pluginInfo.disabled = Serializer.getInt(serializer.getProperty(SECNAME, DISABLED + n), 0) == 1;
            this.plugins.add(pluginInfo);
            ++n;
        }
        this.l_plugins.updateUI();
        this.cb_allDisabled.setSelected(Serializer.getInt(serializer.getProperty(SECNAME, ALLDISABLED), 0) == 1);
    }

    public void save() {
        Object object;
        PluginInfo pluginInfo;
        if (this.lastSelected >= 0) {
            pluginInfo = (PluginInfo)this.plugins.getElementAt(this.lastSelected);
            pluginInfo.class_ = this.tf_class.getText();
            pluginInfo.name = this.tf_name.getText();
            pluginInfo.tooltip = this.tf_ttip.getText();
            pluginInfo.disabled = this.cb_disabled.isSelected();
            this.lastSelected = -1;
        }
        Serializer serializer = this.controller.getSerializer();
        int n = 1;
        while ((object = serializer.getProperty(SECNAME, CLASS + n)) != null) {
            serializer.setProperty(SECNAME, CLASS + n, null);
            serializer.setProperty(SECNAME, NAME + n, null);
            serializer.setProperty(SECNAME, TOOLTIP + n, null);
            serializer.setProperty(SECNAME, DISABLED + n, null);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.plugins.getSize()) {
            pluginInfo = (PluginInfo)this.plugins.getElementAt(n2);
            serializer.setProperty(SECNAME, CLASS + (n2 + 1), pluginInfo.class_);
            serializer.setProperty(SECNAME, NAME + (n2 + 1), pluginInfo.name);
            serializer.setProperty(SECNAME, TOOLTIP + (n2 + 1), pluginInfo.tooltip);
            serializer.setProperty(SECNAME, DISABLED + (n2 + 1), pluginInfo.disabled ? Resources.I_YES : Resources.I_NO);
            ++n2;
        }
        serializer.setProperty(SECNAME, ALLDISABLED, this.cb_allDisabled.isSelected() ? Resources.I_YES : Resources.I_NO);
    }

    class PluginList
    extends AbstractListModel {
        Vector storge = new Vector();

        PluginList() {
        }

        void add(PluginInfo pluginInfo) {
            this.storge.addElement(pluginInfo);
        }

        public void removeElementAt(int n) {
            this.storge.removeElementAt(n);
        }

        public Object getElementAt(int n) {
            return this.storge.elementAt(n);
        }

        public int getSize() {
            return this.storge.size();
        }
    }
}

