/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.courier;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Random;
import photoorganizer.Controller;
import photoorganizer.Courier;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileNameFormat;
import rogatkin.BaseController;
import rogatkin.Serializer;

public class HTTPCourier
implements Courier {
    static final String CONTENT_TYPE = "Content-Type";
    static final String CONTENT_LENGTH = "Content-Length";
    static final String SET_COOKIE = "Set-Cookie";
    static final String CONTENT_DISP = "Content-Disposition: form-data; name=\"";
    static final String FILENAME = "\"; filename=\"";
    static final String CONTENT_ENCODING = "Content-Encoding: ";
    static final String CONTENT_TYPE_ = "Content-Type: \"";
    static final String MULTIPART = "multipart/form-data, boundary=";
    static final String POST_ENCODING = "application/x-www-form-urlencoded";
    static final String DEFAULT_CONTENTTYPE = "application/octet-stream";
    static final String SEP = "--";
    static final String COOKIE = "Cookie";
    static final int AUTH_COOKIE = 1;
    static final int METHOD_GET = 0;
    static final int METHOD_POST = 1;
    static final int BUFSIZE = 1024;
    Controller controller;
    Serializer s;
    URL publisherURL;
    String mask;
    int authMode;
    String cookieValue;

    public HTTPCourier(Controller controller) {
        this.controller = controller;
    }

    public void deliver(StringBuffer stringBuffer, String string, String string2, String string3) throws IOException {
        HttpURLConnection httpURLConnection = this.getConnectedToPublish();
        String string4 = this.genBoundary();
        httpURLConnection.setRequestProperty(CONTENT_TYPE, MULTIPART + string4);
        int n = (string4.length() + 2) * 3 + SEP.length() + 2;
        n += CONTENT_DISP.length();
        String string5 = (String)this.s.getProperty("WebPublishOptions", "UploadDestName");
        if (string5 == null || string5.length() == 0) {
            string5 = "UploadDestName";
        }
        n += string5.length() + 1 + 2 + 2;
        n += string.length() + 2;
        String string6 = (String)this.s.getProperty("WebPublishOptions", "UploadDataName");
        if (string6 == null || string6.length() == 0) {
            string6 = "UploadDataName";
        }
        n += CONTENT_DISP.length();
        n += string6.length() + 1;
        n += FILENAME.length();
        n += string.length() + 1 + 2;
        if (string2 != null && string2.length() > 0) {
            n += string2.length() + CONTENT_TYPE_.length() + 1 + 2;
        }
        if (string3 == null || string3.length() > 0) {
            // empty if block
        }
        n += 2;
        n += stringBuffer.length();
        PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
        printWriter.println(string4);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string5);
        printWriter.println('\"');
        printWriter.println();
        printWriter.println(string);
        printWriter.println(string4);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string6);
        printWriter.print(FILENAME);
        printWriter.print(string);
        printWriter.println('\"');
        if (string2 != null && string2.length() > 0) {
            printWriter.print(CONTENT_TYPE_);
            printWriter.print(string2);
            printWriter.println('\"');
        }
        if (string3 == null || string3.length() > 0) {
            // empty if block
        }
        printWriter.println();
        printWriter.println(stringBuffer);
        printWriter.println(string4 + SEP);
        printWriter.println();
        printWriter.close();
        System.err.println("Done html " + httpURLConnection.getContent());
        System.err.println("Result :" + httpURLConnection.getResponseCode() + "/" + httpURLConnection.getResponseMessage());
        httpURLConnection.disconnect();
    }

    public void deliver(String string, String string2) throws IOException {
        HttpURLConnection httpURLConnection = this.getConnectedToPublish();
        String string3 = this.genBoundary();
        httpURLConnection.setRequestProperty(CONTENT_TYPE, MULTIPART + string3);
        int n = (string3.length() + 2) * 3 + SEP.length() + 2;
        n += CONTENT_DISP.length();
        String string4 = (String)this.s.getProperty("WebPublishOptions", "UploadDestName");
        if (string4 == null || string4.length() == 0) {
            string4 = "UploadDestName";
        }
        n += string4.length() + 1 + 2 + 2;
        String string5 = new File(string).getName();
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) != '/' && string2.charAt(string2.length() - 1) != '\\') {
            string2 = string2 + '/';
        }
        string2 = string2 + string5;
        n += string2.length() + 2;
        String string6 = (String)this.s.getProperty("WebPublishOptions", "UploadDataName");
        if (string6 == null || string6.length() == 0) {
            string6 = "UploadDataName";
        }
        n += CONTENT_DISP.length();
        n += string6.length() + 1;
        n += FILENAME.length();
        n += string.length() + 1 + 2;
        String string7 = null;
        try {
            string7 = URLConnection.getFileNameMap().getContentTypeFor(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string7 == null && string7.length() == 0) {
            string7 = DEFAULT_CONTENTTYPE;
        }
        n += string7.length() + CONTENT_TYPE_.length() + 1 + 2;
        n += 2;
        File file = new File(string);
        n += (int)file.length() + 2;
        OutputStream outputStream = httpURLConnection.getOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println(string3);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string4);
        printWriter.println('\"');
        printWriter.println();
        printWriter.println(string2);
        printWriter.println(string3);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string6);
        printWriter.print(FILENAME);
        printWriter.print(string);
        printWriter.println('\"');
        printWriter.print(CONTENT_TYPE_);
        printWriter.print(string7);
        printWriter.println('\"');
        printWriter.println();
        printWriter.flush();
        BaseController.copyFile(file, outputStream);
        outputStream.flush();
        printWriter.println();
        printWriter.println(string3 + SEP);
        printWriter.println();
        printWriter.close();
        System.err.println("Done image " + httpURLConnection.getContent());
        System.err.println("Result :" + httpURLConnection.getResponseCode() + "/" + httpURLConnection.getResponseMessage());
        httpURLConnection.disconnect();
    }

    public void checkForDestPath(String string) throws IOException {
    }

    public String deliver(BasicJpeg basicJpeg, String string) throws IOException {
        HttpURLConnection httpURLConnection = this.getConnectedToPublish();
        String string2 = this.genBoundary();
        httpURLConnection.setRequestProperty(CONTENT_TYPE, MULTIPART + string2);
        int n = (string2.length() + 2) * 3 + SEP.length() + 2;
        n += CONTENT_DISP.length();
        String string3 = (String)this.s.getProperty("WebPublishOptions", "UploadDestName");
        if (string3 == null || string3.length() == 0) {
            string3 = "UploadDestName";
        }
        n += string3.length() + 1 + 2 + 2;
        AbstractImageInfo abstractImageInfo = basicJpeg.getImageInfo();
        if (abstractImageInfo == null) {
            return "";
        }
        String string4 = FileNameFormat.makeValidPathName(new FileNameFormat(this.mask, true).format(basicJpeg), abstractImageInfo.getThumbnailExtension());
        if (string == null) {
            string = "";
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) != '/' && string.charAt(string.length() - 1) != '\\') {
            string = string + '/';
        }
        string = string + string4;
        n += string.length() + 2;
        String string5 = (String)this.s.getProperty("WebPublishOptions", "UploadDataName");
        if (string5 == null || string5.length() == 0) {
            string5 = "UploadDataName";
        }
        n += CONTENT_DISP.length();
        n += string5.length() + 1;
        n += FILENAME.length();
        n += string4.length() + 1 + 2;
        String string6 = "image/" + abstractImageInfo.getThumbnailExtension();
        n += string6.length() + CONTENT_TYPE_.length() + 1 + 2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        abstractImageInfo.saveThumbnailImage(basicJpeg, byteArrayOutputStream);
        n += byteArrayOutputStream.size() + 2;
        OutputStream outputStream = httpURLConnection.getOutputStream();
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println(string2);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string3);
        printWriter.println('\"');
        printWriter.println();
        printWriter.println(string);
        printWriter.println(string2);
        printWriter.print(CONTENT_DISP);
        printWriter.print(string5);
        printWriter.print(FILENAME);
        printWriter.print(string4);
        printWriter.println('\"');
        printWriter.print(CONTENT_TYPE_);
        printWriter.print(string6);
        printWriter.println('\"');
        printWriter.println();
        printWriter.flush();
        outputStream.write(byteArrayOutputStream.toByteArray());
        outputStream.flush();
        printWriter.println();
        printWriter.println(string2 + SEP);
        printWriter.println();
        printWriter.close();
        System.err.println("Done thumbnail " + httpURLConnection.getContent());
        System.err.println("Result :" + httpURLConnection.getResponseCode() + "/" + httpURLConnection.getResponseMessage());
        httpURLConnection.disconnect();
        return string;
    }

    public void init() throws IOException {
        this.s = this.controller.getSerializer();
        this.authMode = Serializer.getInt(this.s.getProperty("WebPublishOptions", "HttpAuthentication"), 0);
        if (this.authMode == 1) {
            HttpURLConnection httpURLConnection = null;
            String string = URLEncoder.encode((String)this.s.getProperty("WebPublishOptions", "HttpLoginName"));
            string = string + '=';
            string = string + URLEncoder.encode((String)this.s.getProperty("WebPublishOptions", "HttpLogin"));
            string = string + '&';
            string = string + URLEncoder.encode((String)this.s.getProperty("WebPublishOptions", "HttpPasswordName"));
            string = string + '=';
            String string2 = (String)this.s.getProperty("WebPublishOptions", "HttpPassword");
            if (string2 != null) {
                try {
                    string = string + URLEncoder.encode(BaseController.encryptXor(new String(BaseController.hexToBytes(string2), "iso-8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            string = string + '&';
            string = string + (String)this.s.getProperty("WebPublishOptions", "HttpStaticQuery");
            if (Serializer.getInt(this.s.getProperty("WebPublishOptions", "HttpLoginMethod"), 0) == 0) {
                try {
                    httpURLConnection = (HttpURLConnection)new URL((String)this.s.getProperty("WebPublishOptions", "HttpLoginURL") + '?' + string).openConnection();
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                try {
                    httpURLConnection = (HttpURLConnection)new URL((String)this.s.getProperty("WebPublishOptions", "HttpLoginURL")).openConnection();
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setUseCaches(false);
                    httpURLConnection.setAllowUserInteraction(false);
                    string = string + "\r\n";
                    PrintWriter printWriter = new PrintWriter(httpURLConnection.getOutputStream());
                    printWriter.print(string);
                    printWriter.flush();
                    printWriter.close();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (httpURLConnection != null) {
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    InputStream inputStream = httpURLConnection.getInputStream();
                    byte[] byArray = new byte[2048];
                    byte[] byArray2 = new byte[]{};
                    try {
                        int n2;
                        while ((n2 = inputStream.read(byArray)) >= 0) {
                            byte[] byArray3 = new byte[byArray2.length + n2];
                            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                            System.arraycopy(byArray, 0, byArray3, byArray2.length, n2);
                            byArray2 = byArray3;
                        }
                        Object var11_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_17 = null;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                    System.err.println("Content:\n" + new String(byArray2));
                } else if (n == 204) {
                    System.err.println("The request is OK, but server returned no data");
                } else {
                    System.err.println("Server return error code " + n);
                }
                System.err.println("Cookie from srv " + httpURLConnection.getHeaderField(SET_COOKIE));
                httpURLConnection.disconnect();
            }
        }
        try {
            this.publisherURL = new URL((String)this.s.getProperty("WebPublishOptions", "UploadServletURL"));
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.mask = (String)this.s.getProperty("ThumbnailsOptions", "FileMask");
        if (this.mask == null || this.mask.length() == 0) {
            this.mask = "tumbnail%00c.jpg";
        }
    }

    public void done() {
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isContentIncluded() {
        return false;
    }

    private String genBoundary() {
        return "---------------------------" + Long.toHexString(new Random().nextLong());
    }

    private HttpURLConnection getConnectedToPublish() throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)this.publisherURL.openConnection();
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setAllowUserInteraction(false);
        if (this.authMode == 1 && this.cookieValue != null) {
            httpURLConnection.setRequestProperty(COOKIE, this.cookieValue);
        }
        return httpURLConnection;
    }
}

