//
//
//                                                           %__________%
//                                                          %/ . .  .   \%
//           Van Gogh 2D-Display Library                     |  . .  o. |
//                                                           |. _  .   .|
//        Microsoft Windows 95/98/NT Version                 | / \   .  |
//                                                           |_|_|_._._.|
//                                                           |.-.-.-.-..|
//                                                          %\__________/%
//                                                           %          %
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little
//
// thline128.cpp
//
//     The true-alpha blended texture mapping horizontal scan line code.
//
//

//
//
//                                Includes
//
//

#include "debug.h"
#include "portable.h"
#include "vangogh.hpp"
#include <math.h>

//
//
//                                Equates
//
//


//
//
//                               Structures
//
//

extern long DitherMatrix[4][4];

//
//
//                               Routines
//
//


extern "C" void vngo_lghlines16_ntrans (VngoTriangle *tri);
extern "C" void vngo_lghlines16_trans_filtered (VngoTriangle *tri);
extern "C" void vngo_lghlines16_trans (VngoTriangle *tri);
extern "C" void vngo_lhlines16_ntrans (VngoTriangle *tri);
extern "C" void vngo_lhlines16_trans_filtered (VngoTriangle *tri);
extern "C" void vngo_lhlines16_trans (VngoTriangle *tri);
extern "C" void vngo_lzghlines16_ntrans_filtered (VngoTriangle *tri);
extern "C" void vngo_lzghlines16_ntrans (VngoTriangle *tri);
extern "C" void vngo_lzghlines16_trans_filtered (VngoTriangle *tri);
extern "C" void vngo_lzghlines16_trans (VngoTriangle *tri);
extern "C" void vngo_lzhlines16_ntrans_filtered (VngoTriangle *tri);
extern "C" void vngo_lzhlines16_ntrans (VngoTriangle *tri);
extern "C" void vngo_lzhlines16_trans_filtered (VngoTriangle *tri);
extern "C" void vngo_lzhlines16_trans (VngoTriangle *tri);

// Gouraud shaded texturemappers.


extern "C" void vngo_talghlines16_ntrans_filtered (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            sstep_dx1 = tri->sstep_dx1;
    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];
                int ws = (ts + matval) >> 19;

                long matvalv = (matval << (vup - 3));
                matval = matval << (uup - 3);

                clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                          + ((dword)(tu + matval) >> udown)];

                if (ws > 31)
                    ws = 31;
                else if (ws < 0)
                    ws = 0;

                swork = stable[(clr << 5) + ws];
                dwork = *ptr;

                work = salpha[(swork >> 10)] << 10;
                work += salpha[(swork >> 5) & 0x1f] << 5;
                work += salpha[swork & 0x1f];

                work += dalpha[(dwork >> 10)] << 10;
                work += dalpha[(dwork >> 5) & 0x1f] << 5;
                work += dalpha[dwork & 0x1f];

                *ptr = work;

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];
                int ws = (ts + matval) >> 19;


                long matvalv = (matval << (vup - 3));
                matval = matval << (uup - 3);

                clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                          + ((dword)(tu + matval) >> udown)];

                if (ws > 31)
                    ws = 31;
                else if (ws < 0)
                    ws = 0;

                swork = stable[(clr << 5) + ws];
                dwork = *ptr;

                work = salpha[(swork >> 11)] << 11;
                work += salpha[(swork >> 6) & 0x1f] << 6;
                work += salpha[swork & 0x1f];

                work += dalpha[(dwork >> 11)] << 11;
                work += dalpha[(dwork >> 6) & 0x1f] << 6;
                work += dalpha[dwork & 0x1f];

                *ptr = work;

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}


extern "C" void vngo_talghlines16_ntrans (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            sstep_dx1 = tri->sstep_dx1;
    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];
                int ws = (ts + matval) >> 19;


                clr = tptr[(((dword)(tv) >> vdown) & mask)
                          + ((dword)(tu) >> udown)];

                if (ws > 31)
                    ws = 31;
                else if (ws < 0)
                    ws = 0;

                swork = stable[(clr << 5) + ws];
                dwork = *ptr;

                work = salpha[(swork >> 10)] << 10;
                work += salpha[(swork >> 5) & 0x1f] << 5;
                work += salpha[swork & 0x1f];

                work += dalpha[(dwork >> 10)] << 10;
                work += dalpha[(dwork >> 5) & 0x1f] << 5;
                work += dalpha[dwork & 0x1f];

                *ptr = work;

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];
                int ws = (ts + matval) >> 19;


                clr = tptr[(((dword)(tv) >> vdown) & mask)
                          + ((dword)(tu) >> udown)];

                if (ws > 31)
                    ws = 31;
                else if (ws < 0)
                    ws = 0;

                swork = stable[(clr << 5) + ws];
                dwork = *ptr;

                work = salpha[(swork >> 11)] << 11;
                work += salpha[(swork >> 6) & 0x1f] << 6;
                work += salpha[swork & 0x1f];

                work += dalpha[(dwork >> 11)] << 11;
                work += dalpha[(dwork >> 6) & 0x1f] << 6;
                work += dalpha[dwork & 0x1f];

                *ptr = work;

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}





extern "C" void vngo_talghlines16_trans_filtered (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            sstep_dx1 = tri->sstep_dx1;
    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];
                int ws = (ts + matval) >> 19;


                long matvalv = (matval << (vup - 3));
                matval = matval << (uup - 3);

                clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                          + ((dword)(tu + matval) >> udown)];

                if (clr != 255)
                {
                    if (ws > 31)
                        ws = 31;
                    else if (ws < 0)
                        ws = 0;

                    swork = stable[(clr << 5) + ws];
                    dwork = *ptr;

                    work = salpha[(swork >> 10)] << 10;
                    work += salpha[(swork >> 5) & 0x1f] << 5;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 10)] << 10;
                    work += dalpha[(dwork >> 5) & 0x1f] << 5;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];
                int ws = (ts + matval) >> 19;


                long matvalv = (matval << (vup - 3));
                matval = matval << (uup - 3);

                clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                          + ((dword)(tu + matval) >> udown)];

                if (clr != 255)
                {
                    if (ws > 31)
                        ws = 31;
                    else if (ws < 0)
                        ws = 0;

                    swork = stable[(clr << 5) + ws];
                    dwork = *ptr;

                    work = salpha[(swork >> 11)] << 11;
                    work += salpha[(swork >> 6) & 0x1f] << 6;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 11)] << 11;
                    work += dalpha[(dwork >> 6) & 0x1f] << 6;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}


extern "C" void vngo_talghlines16_trans (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            sstep_dx1 = tri->sstep_dx1;
    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];
                int ws = (ts + matval) >> 19;


                clr = tptr[(((dword)(tv) >> vdown) & mask)
                          + ((dword)(tu) >> udown)];

                if (clr != 255)
                {
                    if (ws > 31)
                        ws = 31;
                    else if (ws < 0)
                        ws = 0;

                    swork = stable[(clr << 5) + ws];
                    dwork = *ptr;

                    work = salpha[(swork >> 10)] << 10;
                    work += salpha[(swork >> 5) & 0x1f] << 5;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 10)] << 10;
                    work += dalpha[(dwork >> 5) & 0x1f] << 5;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];
                int ws = (ts + matval) >> 19;


                clr = tptr[(((dword)(tv) >> vdown) & mask)
                          + ((dword)(tu) >> udown)];

                if (clr != 255)
                {
                    if (ws > 31)
                        ws = 31;
                    else if (ws < 0)
                        ws = 0;

                    swork = stable[(clr << 5) + ws];
                    dwork = *ptr;

                    work = salpha[(swork >> 11)] << 11;
                    work += salpha[(swork >> 6) & 0x1f] << 6;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 11)] << 11;
                    work += dalpha[(dwork >> 6) & 0x1f] << 6;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}









extern "C" void vngo_talhlines16_ntrans_filtered (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];


                long matvalv = (matval << (vup - 3));
                matval = matval << (uup - 3);

                clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                          + ((dword)(tu + matval) >> udown)];

                swork = stable[(clr << 5)];
                dwork = *ptr;

                work = salpha[(swork >> 10)] << 10;
                work += salpha[(swork >> 5) & 0x1f] << 5;
                work += salpha[swork & 0x1f];

                work += dalpha[(dwork >> 10)] << 10;
                work += dalpha[(dwork >> 5) & 0x1f] << 5;
                work += dalpha[dwork & 0x1f];

                *ptr = work;

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];

                long matvalv = (matval << (vup - 3));
                matval = matval << (uup - 3);

                clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                          + ((dword)(tu + matval) >> udown)];

                swork = stable[clr << 5];
                dwork = *ptr;

                work = salpha[(swork >> 11)] << 11;
                work += salpha[(swork >> 6) & 0x1f] << 6;
                work += salpha[swork & 0x1f];

                work += dalpha[(dwork >> 11)] << 11;
                work += dalpha[(dwork >> 6) & 0x1f] << 6;
                work += dalpha[dwork & 0x1f];

                *ptr = work;

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}



extern "C" void vngo_talhlines16_ntrans (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;

            for (int x = tx;x < dx; x++)
            {
                clr = tptr[(((dword)(tv) >> vdown) & mask)
                          + ((dword)(tu) >> udown)];

                swork = stable[(clr << 5)];
                dwork = *ptr;

                work = salpha[(swork >> 10)] << 10;
                work += salpha[(swork >> 5) & 0x1f] << 5;
                work += salpha[swork & 0x1f];

                work += dalpha[(dwork >> 10)] << 10;
                work += dalpha[(dwork >> 5) & 0x1f] << 5;
                work += dalpha[dwork & 0x1f];

                *ptr = work;

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;

            for (int x = tx;x < dx; x++)
            {
                clr = tptr[(((dword)(tv) >> vdown) & mask)
                          + ((dword)(tu) >> udown)];

                swork = stable[clr << 5];
                dwork = *ptr;

                work = salpha[(swork >> 11)] << 11;
                work += salpha[(swork >> 6) & 0x1f] << 6;
                work += salpha[swork & 0x1f];

                work += dalpha[(dwork >> 11)] << 11;
                work += dalpha[(dwork >> 6) & 0x1f] << 6;
                work += dalpha[dwork & 0x1f];

                *ptr = work;

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}



extern "C" void vngo_talhlines16_trans_filtered (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];


                long matvalv = (matval << (vup - 3));
                matval = matval << (uup - 3);

                clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                          + ((dword)(tu + matval) >> udown)];

                if (clr != 255)
                {
                    swork = stable[(clr << 5)];
                    dwork = *ptr;

                    work = salpha[(swork >> 10)] << 10;
                    work += salpha[(swork >> 5) & 0x1f] << 5;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 10)] << 10;
                    work += dalpha[(dwork >> 5) & 0x1f] << 5;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                long  matval = dmatrix[x&3];

                long matvalv = (matval << (vup - 3));
                matval = matval << (uup - 3);

                clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                          + ((dword)(tu + matval) >> udown)];

                if (clr != 255)
                {
                    swork = stable[clr << 5];
                    dwork = *ptr;

                    work = salpha[(swork >> 11)] << 11;
                    work += salpha[(swork >> 6) & 0x1f] << 6;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 11)] << 11;
                    work += dalpha[(dwork >> 6) & 0x1f] << 6;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}



extern "C" void vngo_talhlines16_trans (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;

    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;

            for (int x = tx;x < dx; x++)
            {
                clr = tptr[(((dword)(tv) >> vdown) & mask)
                          + ((dword)(tu) >> udown)];

                if (clr != 255)
                {
                    swork = stable[(clr << 5)];
                    dwork = *ptr;

                    work = salpha[(swork >> 10)] << 10;
                    work += salpha[(swork >> 5) & 0x1f] << 5;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 10)] << 10;
                    work += dalpha[(dwork >> 5) & 0x1f] << 5;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            int dx = edge2->x;

            for (int x = tx;x < dx; x++)
            {
                clr = tptr[(((dword)(tv) >> vdown) & mask)
                          + ((dword)(tu) >> udown)];

                if (clr != 255)
                {
                    swork = stable[clr << 5];
                    dwork = *ptr;

                    work = salpha[(swork >> 11)] << 11;
                    work += salpha[(swork >> 6) & 0x1f] << 6;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 11)] << 11;
                    work += dalpha[(dwork >> 6) & 0x1f] << 6;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
            }
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}




//--------------------------------------------------
// ZBuffered versions.
//--------------------------------------------------


extern "C" void vngo_talzghlines16_ntrans_filtered (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            sstep_dx1 = tri->sstep_dx1;
    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;
    long            zstep_dx1 = tri->zstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    *zptr = wz;
                    long  matval = dmatrix[x&3];
                    int ws = (ts + matval) >> 19;


                    long matvalv = (matval << (vup - 3));
                    matval = matval << (uup - 3);

                    clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                              + ((dword)(tu + matval) >> udown)];

                    if (ws > 31)
                        ws = 31;
                    else if (ws < 0)
                        ws = 0;

                    swork = stable[(clr << 5) + ws];
                    dwork = *ptr;

                    work = salpha[(swork >> 10)] << 10;
                    work += salpha[(swork >> 5) & 0x1f] << 5;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 10)] << 10;
                    work += dalpha[(dwork >> 5) & 0x1f] << 5;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tz = edge1->z;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    *zptr = wz;
                    long  matval = dmatrix[x&3];
                    int ws = (ts + matval) >> 19;


                    long matvalv = (matval << (vup - 3));
                    matval = matval << (uup - 3);

                    clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                              + ((dword)(tu + matval) >> udown)];

                    if (ws > 31)
                        ws = 31;
                    else if (ws < 0)
                        ws = 0;

                    swork = stable[(clr << 5) + ws];
                    dwork = *ptr;

                    work = salpha[(swork >> 11)] << 11;
                    work += salpha[(swork >> 6) & 0x1f] << 6;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 11)] << 11;
                    work += dalpha[(dwork >> 6) & 0x1f] << 6;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                zptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
}


extern "C" void vngo_talzghlines16_ntrans (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            zstep_dx1 = tri->zstep_dx1;
    long            sstep_dx1 = tri->sstep_dx1;
    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tz = edge1->z;
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    *zptr = wz;
                    long  matval = dmatrix[x&3];
                    int ws = (ts + matval) >> 19;


                    clr = tptr[(((dword)(tv) >> vdown) & mask)
                              + ((dword)(tu) >> udown)];

                    if (ws > 31)
                        ws = 31;
                    else if (ws < 0)
                        ws = 0;

                    swork = stable[(clr << 5) + ws];
                    dwork = *ptr;

                    work = salpha[(swork >> 10)] << 10;
                    work += salpha[(swork >> 5) & 0x1f] << 5;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 10)] << 10;
                    work += dalpha[(dwork >> 5) & 0x1f] << 5;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    long  matval = dmatrix[x&3];
                    int ws = (ts + matval) >> 19;


                    clr = tptr[(((dword)(tv) >> vdown) & mask)
                              + ((dword)(tu) >> udown)];

                    if (ws > 31)
                        ws = 31;
                    else if (ws < 0)
                        ws = 0;

                    swork = stable[(clr << 5) + ws];
                    dwork = *ptr;

                    work = salpha[(swork >> 11)] << 11;
                    work += salpha[(swork >> 6) & 0x1f] << 6;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 11)] << 11;
                    work += dalpha[(dwork >> 6) & 0x1f] << 6;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            zbuff += zpitch;
            scrn += pitch;
            edge1++;
            edge2++;
        }
    }
}





extern "C" void vngo_talzghlines16_trans_filtered (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            sstep_dx1 = tri->sstep_dx1;
    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;
    long            zstep_dx1 = tri->zstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {

                    long  matval = dmatrix[x&3];
                    int ws = (ts + matval) >> 19;

                    long matvalv = (matval << (vup - 3));
                    matval = matval << (uup - 3);

                    clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                              + ((dword)(tu + matval) >> udown)];

                    if (clr != 255)
                    {
                        *zptr = wz;
                        if (ws > 31)
                            ws = 31;
                        else if (ws < 0)
                            ws = 0;

                        swork = stable[(clr << 5) + ws];
                        dwork = *ptr;

                        work = salpha[(swork >> 10)] << 10;
                        work += salpha[(swork >> 5) & 0x1f] << 5;
                        work += salpha[swork & 0x1f];

                        work += dalpha[(dwork >> 10)] << 10;
                        work += dalpha[(dwork >> 5) & 0x1f] << 5;
                        work += dalpha[dwork & 0x1f];

                        *ptr = work;
                    }
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;

            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    long  matval = dmatrix[x&3];
                    int ws = (ts + matval) >> 19;

                    long matvalv = (matval << (vup - 3));
                    matval = matval << (uup - 3);

                    clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                              + ((dword)(tu + matval) >> udown)];

                    if (clr != 255)
                    {
                        *zptr = wz;

                        if (ws > 31)
                            ws = 31;
                        else if (ws < 0)
                            ws = 0;

                        swork = stable[(clr << 5) + ws];
                        dwork = *ptr;

                        work = salpha[(swork >> 11)] << 11;
                        work += salpha[(swork >> 6) & 0x1f] << 6;
                        work += salpha[swork & 0x1f];

                        work += dalpha[(dwork >> 11)] << 11;
                        work += dalpha[(dwork >> 6) & 0x1f] << 6;
                        work += dalpha[dwork & 0x1f];

                        *ptr = work;
                    }
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
}


extern "C" void vngo_talzghlines16_trans (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[0];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            sstep_dx1 = tri->sstep_dx1;
    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;
    long            zstep_dx1 = tri->zstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    long  matval = dmatrix[x&3];
                    int ws = (ts + matval) >> 19;


                    clr = tptr[(((dword)(tv) >> vdown) & mask)
                              + ((dword)(tu) >> udown)];

                    if (clr != 255)
                    {
                        *zptr = wz;
                        if (ws > 31)
                            ws = 31;
                        else if (ws < 0)
                            ws = 0;

                        swork = stable[(clr << 5) + ws];
                        dwork = *ptr;

                        work = salpha[(swork >> 10)] << 10;
                        work += salpha[(swork >> 5) & 0x1f] << 5;
                        work += salpha[swork & 0x1f];

                        work += dalpha[(dwork >> 10)] << 10;
                        work += dalpha[(dwork >> 5) & 0x1f] << 5;
                        work += dalpha[dwork & 0x1f];

                        *ptr = work;
                    }
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long ts = edge1->shade;
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    long  matval = dmatrix[x&3];
                    int ws = (ts + matval) >> 19;


                    clr = tptr[(((dword)(tv) >> vdown) & mask)
                              + ((dword)(tu) >> udown)];

                    if (clr != 255)
                    {
                        *zptr = wz;
                        if (ws > 31)
                            ws = 31;
                        else if (ws < 0)
                            ws = 0;

                        swork = stable[(clr << 5) + ws];
                        dwork = *ptr;

                        work = salpha[(swork >> 11)] << 11;
                        work += salpha[(swork >> 6) & 0x1f] << 6;
                        work += salpha[swork & 0x1f];

                        work += dalpha[(dwork >> 11)] << 11;
                        work += dalpha[(dwork >> 6) & 0x1f] << 6;
                        work += dalpha[dwork & 0x1f];

                        *ptr = work;
                    }
                }

                ptr++;
                ts += sstep_dx1;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
}



extern "C" void vngo_talzhlines16_ntrans_filtered (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;
    long            zstep_dx1 = tri->zstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    *zptr = wz;
                    long  matval = dmatrix[x&3];

                    long matvalv = (matval << (vup - 3));
                    matval = matval << (uup - 3);

                    clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                              + ((dword)(tu + matval) >> udown)];

                    swork = stable[(clr << 5)];
                    dwork = *ptr;

                    work = salpha[(swork >> 10)] << 10;
                    work += salpha[(swork >> 5) & 0x1f] << 5;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 10)] << 10;
                    work += dalpha[(dwork >> 5) & 0x1f] << 5;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    *zptr = wz;
                    long  matval = dmatrix[x&3];

                    long matvalv = (matval << (vup - 3));
                    matval = matval << (uup - 3);

                    clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                              + ((dword)(tu + matval) >> udown)];

                    swork = stable[clr << 5];
                    dwork = *ptr;

                    work = salpha[(swork >> 11)] << 11;
                    work += salpha[(swork >> 6) & 0x1f] << 6;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 11)] << 11;
                    work += dalpha[(dwork >> 6) & 0x1f] << 6;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
}



extern "C" void vngo_talzhlines16_ntrans (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;
    long            zstep_dx1 = tri->zstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    *zptr = wz;
                    clr = tptr[(((dword)(tv) >> vdown) & mask)
                              + ((dword)(tu) >> udown)];

                    swork = stable[(clr << 5)];
                    dwork = *ptr;

                    work = salpha[(swork >> 10)] << 10;
                    work += salpha[(swork >> 5) & 0x1f] << 5;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 10)] << 10;
                    work += dalpha[(dwork >> 5) & 0x1f] << 5;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    *zptr = wz;
                    clr = tptr[(((dword)(tv) >> vdown) & mask)
                              + ((dword)(tu) >> udown)];

                    swork = stable[clr << 5];
                    dwork = *ptr;

                    work = salpha[(swork >> 11)] << 11;
                    work += salpha[(swork >> 6) & 0x1f] << 6;
                    work += salpha[swork & 0x1f];

                    work += dalpha[(dwork >> 11)] << 11;
                    work += dalpha[(dwork >> 6) & 0x1f] << 6;
                    work += dalpha[dwork & 0x1f];

                    *ptr = work;
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
}



extern "C" void vngo_talzhlines16_trans_filtered (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;
    long            zstep_dx1 = tri->zstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    long matval = dmatrix[x&3];

                    long matvalv = (matval << (vup - 3));
                    matval = matval << (uup - 3);

                    clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                              + ((dword)(tu + matval) >> udown)];

                    if (clr != 255)
                    {
                        *zptr = wz;
                        swork = stable[(clr << 5)];
                        dwork = *ptr;

                        work = salpha[(swork >> 10)] << 10;
                        work += salpha[(swork >> 5) & 0x1f] << 5;
                        work += salpha[swork & 0x1f];

                        work += dalpha[(dwork >> 10)] << 10;
                        work += dalpha[(dwork >> 5) & 0x1f] << 5;
                        work += dalpha[dwork & 0x1f];

                        *ptr = work;
                    }
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;
            long *dmatrix = &DitherMatrix[(start_y+y)&3][0];

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    long matval = dmatrix[x&3];

                    long matvalv = (matval << (vup - 3));
                    matval = matval << (uup - 3);

                    clr = tptr[(((dword)(tv + matvalv) >> vdown) & mask)
                              + ((dword)(tu + matval) >> udown)];

                    if (clr != 255)
                    {
                        *zptr = wz;
                        swork = stable[clr << 5];
                        dwork = *ptr;

                        work = salpha[(swork >> 11)] << 11;
                        work += salpha[(swork >> 6) & 0x1f] << 6;
                        work += salpha[swork & 0x1f];

                        work += dalpha[(dwork >> 11)] << 11;
                        work += dalpha[(dwork >> 6) & 0x1f] << 6;
                        work += dalpha[dwork & 0x1f];

                        *ptr = work;
                    }
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
}



extern "C" void vngo_talzhlines16_trans (VngoTriangle *tri)
{
    VngoShadePal16   *tp = (VngoShadePal16 *)tri->vbuff->pal->shd_pal;
    VngoColorShade16 *tc = &(*tp)[0];
    word             *stable = &tc->shl[tri->left_edge->shade >> 19];

    long            count = tri->height;
    long            pitch = tri->pitch >> 1;
    long            zpitch = tri->zpitch >> 1;

    long            ustep_dx1 = tri->ustep_dx1;
    long            vstep_dx1 = tri->vstep_dx1;
    long            zstep_dx1 = tri->zstep_dx1;

    word            *scrn = (word*)tri->sptr;
    word            *zbuff = (word*)tri->zptr;
    VngoPoint2      *edge1 = tri->left_edge;
    VngoPoint2      *edge2 = tri->right_edge;
    long            uup = tri->tex->u_upshift;
    long            vup = tri->tex->v_upshift;
    long            udown = tri->tex->u_downshift;
    long            vdown = tri->tex->v_downshift - tri->tex->widthshift;
    long            start_y = tri->start_y;
    byte            *tptr = (byte*)tri->tex->vtxt->tex;
    long            mask = ~((1 << tri->tex->widthshift) - 1);
    byte            clr;
    word            work;
    word            swork;
    word            dwork;
    byte            *salpha = &VgSystem->alpha_table[(tri->alpha) << 5];
    byte            *dalpha = &VgSystem->alpha_table[( 255 - tri->alpha) << 5];

    if (tri->vbuff->pal->flags & VNGO_15BIT)
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    clr = tptr[(((dword)(tv) >> vdown) & mask)
                              + ((dword)(tu) >> udown)];

                    if (clr != 255)
                    {
                        *zptr = wz;
                        swork = stable[(clr << 5)];
                        dwork = *ptr;

                        work = salpha[(swork >> 10)] << 10;
                        work += salpha[(swork >> 5) & 0x1f] << 5;
                        work += salpha[swork & 0x1f];

                        work += dalpha[(dwork >> 10)] << 10;
                        work += dalpha[(dwork >> 5) & 0x1f] << 5;
                        work += dalpha[dwork & 0x1f];

                        *ptr = work;
                    }
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
    else
    {
        for (long y=0;y <= count;y++)
        {
            long tu = edge1->u << uup;
            long tv = edge1->v << vup;
            long tz = edge1->z;

            long tx = edge1->x;
            word *ptr = scrn + tx;
            word *zptr = zbuff + tx;
            int dx = edge2->x;

            for (int x = tx;x < dx; x++)
            {
                word wz = word(tz >> 15);
                if (wz < *zptr)
                {
                    clr = tptr[(((dword)(tv) >> vdown) & mask)
                              + ((dword)(tu) >> udown)];

                    if (clr != 255)
                    {
                        *zptr = wz;
                        swork = stable[clr << 5];
                        dwork = *ptr;

                        work = salpha[(swork >> 11)] << 11;
                        work += salpha[(swork >> 6) & 0x1f] << 6;
                        work += salpha[swork & 0x1f];

                        work += dalpha[(dwork >> 11)] << 11;
                        work += dalpha[(dwork >> 6) & 0x1f] << 6;
                        work += dalpha[dwork & 0x1f];

                        *ptr = work;
                    }
                }

                ptr++;
                tu += ustep_dx1;
                tv += vstep_dx1;
                tz += zstep_dx1;
                zptr++;
            }
            scrn += pitch;
            zbuff += zpitch;
            edge1++;
            edge2++;
        }
    }
}




extern "C" void vngo_alghlines16_filtered(VngoTriangle *tri)
{
    if (tri->tex->vtxt->flags & VNGO_TEXTURE_TRANSPARENT)
        vngo_talghlines16_trans_filtered(tri);
    else
        vngo_talghlines16_ntrans_filtered(tri);
}

extern "C" void vngo_alghlines16(VngoTriangle *tri)
{
    if (tri->tex->vtxt->flags & VNGO_TEXTURE_TRANSPARENT)
        vngo_talghlines16_trans(tri);
    else
        vngo_talghlines16_ntrans(tri);
}

extern "C" void vngo_alzghlines16_filtered(VngoTriangle *tri)
{
    if (tri->tex->vtxt->flags & VNGO_TEXTURE_TRANSPARENT)
        vngo_talzghlines16_trans_filtered(tri);
    else
        vngo_talzghlines16_ntrans_filtered(tri);
}

extern "C" void vngo_alzghlines16(VngoTriangle *tri)
{
    if (tri->tex->vtxt->flags & VNGO_TEXTURE_TRANSPARENT)
        vngo_talzghlines16_trans(tri);
    else
        vngo_talzghlines16_ntrans(tri);
}

extern "C" void vngo_alhlines16_filtered(VngoTriangle *tri)
{
    if (tri->tex->vtxt->flags & VNGO_TEXTURE_TRANSPARENT)
        vngo_talhlines16_trans_filtered(tri);
    else
        vngo_talhlines16_ntrans_filtered(tri);
}

extern "C" void vngo_alhlines16(VngoTriangle *tri)
{
    if (tri->tex->vtxt->flags & VNGO_TEXTURE_TRANSPARENT)
        vngo_talhlines16_trans(tri);
    else
        vngo_talhlines16_ntrans(tri);
}

extern "C" void vngo_alzhlines16_filtered(VngoTriangle *tri)
{
    if (tri->tex->vtxt->flags & VNGO_TEXTURE_TRANSPARENT)
        vngo_talzhlines16_trans_filtered(tri);
    else
        vngo_talzhlines16_ntrans_filtered(tri);
}

extern "C" void vngo_alzhlines16(VngoTriangle *tri)
{
    if (tri->tex->vtxt->flags & VNGO_TEXTURE_TRANSPARENT)
        vngo_talzhlines16_trans(tri);
    else
        vngo_talzhlines16_ntrans(tri);
}


