//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
// essystem.hpp
//
// The EschSystem class is used to initialize the Escher library as
// a whole.  It contains various diagnostic information and the
// global state information.
//
//

#ifndef __ESSYSTEM_HPP
#define __ESSYSTEM_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include <portable.h>
#include <ivory.hpp>

//
//
//                                Equates
//
//

#define ESCH_DEFAULT_ARENA      65536   // Default size of workspace (bytes)

#define ESCH_DEFAULT_SORT       65536   // Default size of sort area (bytes)

//
//
//                                Data
//
//

class EschSystem;

//Ŀ
// Pointer to escher system class created before using Escher objects.      
//
extern EschSystem *EschSysInstance;

//
//
//                                Classes
//
//

struct EschTextureCache;
struct EschTextureFile;
class EschElement;

//Ŀ
// EschSystem - Main control class.                                         
//
class EschSystem
{
public:
    //Ŀ
    // Public data members.                                                 
    //
    dword               flags;          // System state flags

    // Workspace information
    ulong               wspace_mbytes;  // Work-space needed
    ulong               wspace_sbytes;  // Size of work-space
    IvoryArena          *wspace;

    // Sort space information
    ulong               sspace_mdepth;  // Sort area tree depth
    ulong               sspace_mbytes;  // Sort area needed
    ulong               sspace_sbytes;  // Size of sort area
    IvoryArena          *sspace;
    EschElement         *sroot;         // Root of sort tree

    // Diagnostic information
    ulong               diag_faces;     // Count of faces in Meshes
    ulong               diag_verts;     // Count of verts in Meshes
    ulong               diag_ifaces;    // Count of faces in MeshDraws
    ulong               diag_iverts;    // Count of verts in MeshDraws
    ulong               diag_ntxts;     // Count of texture instances

    // Texture cache
    ulong               tcache_hi;      // Highest used texture cache entry
    ulong               tcache_max;     // Maximum texture cache entry
    EschTextureCache    *tcache;

    // Texture file (shared)
    ulong               tfile_hi;      // Highest used texture file entry
    ulong               tfile_max;     // Maximum texture file entry
    EschTextureFile     *tfile;

    //Ŀ
    // Constructor/Destructors                                              
    //
    EschSystem(ulong arena_size=0, ulong sort_size=0);
    virtual ~EschSystem();

    //Ŀ
    // Operations                                                           
    //
    esch_error_codes init(ulong arena_size=ESCH_DEFAULT_ARENA,
                          ulong sort_size=ESCH_DEFAULT_SORT);
    void release();

    esch_error_codes enable_amd3d();
    void disable_amd3d();
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - essystem.hpp 

