//
//                oooooooooo.
//                `888'   `Y8b
//                 888     888  .ooooo.    oooooooo  .ooooo.
//                 888oooo888' d88' `88b  d'""7d8P  d88' `88b
//                 888    `88b 888   888    .d8P'   888   888
//                 888    .88P 888   888  .d8P'  .P 888   888
//                o888bood8P'  `Y8bod8P' d8888888P  `Y8bod8P'
//                           _
//                          /_\     |    _  _ | _ ._
//                         /   \  \_||_|(_|(_||(/_|
//                                       _| _|
//                     Microsoft Windows 95/98/NT Version
//
//  Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Dan Higdon
//
// Semaphores
//
//      This module abstracts the process queues of the TASK module by
// introducing semaphores.  In this library, semaphores are mutual
// exclusion devices, and only one task can own the semaphore at a time.
// Also, the semaphore is set unowned by default.
//
//

//
//
//                                Includes
//
//

#include <stdlib.h>
#include <assert.h>

#include "bzqueue.h"
#include "bzsemap.h"

//
//
//                                Equates
//
//

//
//
//                               Structures
//
//

//
//
//                               Routines
//
//

//
//
//                                 Data
//
//

//
//
//                                 Code
//
//


//Ŀ
//  Initialize a semaphore by clearing the flag and the waiting queue.      
//
void bzsem_init (bz_semaphore *sem, unsigned count)
{
    sem->count = count;
    bzqueue_init (&sem->waiting);
}

//Ŀ
//  Wait for the semaphore.  If the flag is set, return immediately after   
//  "taking" the semaphore.  Otherwise, yield onto the semaphore's queue.   
//
void bzsem_wait (bz_semaphore *sem)
{
    if (sem->count)
        sem->count--;
    else
        bz_yield (&sem->waiting, &ReadyQ);
}

//Ŀ
//  Signal the semaphore.  Adds a waiting process to the ready queue,       
//  otherwise sets the flag so that the next task to wait will return       
//  immediately.                                                            
//
void bzsem_signal (bz_semaphore *sem)
{
    if (bzqueue_empty (&sem->waiting))
    {
        sem->count++;
    }
    else
    {
        bz_task *t = bzqueue_leave (&sem->waiting);
        bzqueue_enter (&ReadyQ, t);
    }
}


//Ŀ
//  Yield the current task and place it into the destq.  Select the next    
//  task to run from the srcq.                                              
//
void bz_yield (bz_task_queue *destq, bz_task_queue *srcq)
{
    bz_task *running = Task;

    // All of these things must be true to proceed
    assert (Task != NULL);
    assert (destq != NULL);
    assert (srcq != NULL);

    // This is a quick "hack" check that makes switches to self trivial.
    if (destq == srcq && bzqueue_empty (srcq))
        return;

    // Get the task to run.
    assert (!bzqueue_empty (srcq));
    Task = bzqueue_leave (srcq);

    // Put the old task into the requested queue.
    bzqueue_enter (destq, running);

    // Now, transfer to the next task up in the ready queue.
    bz_swap (&running->context, &Task->context);
}


//Ŀ
//  A simplified API to suspend the current task's execution, and replace   
//  it into the round-robin scheduler.                                      
//
void bz_suspend (void)
{
    assert (Task != NULL);
    bz_yield (&ReadyQ, &ReadyQ);
}

// End of file - bzsemap.c 
