/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.xml.util;

import java.io.Writer;
import org.freehep.xml.util.XMLWriter;

public class XHTMLWriter
extends XMLWriter {
    public XHTMLWriter(Writer w2, String indentString, String type) {
        super(w2, indentString, "xhtml");
        this.openDoc("1.0", "UTF-8", false);
        if (type.equals("strict")) {
            this.referToDTD("html", "-//W3C//DTD XHTML 1.0 Strict//EN", "http://wwww.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
        } else if (type.equals("transitional")) {
            this.referToDTD("html", "-//W3C//DTD XHTML 1.0 Transitional//EN", "http://wwww.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
        } else if (type.equals("frameset")) {
            this.referToDTD("html", "-//W3C//DTD XHTML 1.0 Frameset//EN", "http://wwww.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd");
        } else {
            System.err.println("XHTMLWriter: unknown type: " + type + ", allowed are: strict, transitional, frameset");
        }
        this.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
        if (!type.equals("strict")) {
            this.setAttribute("xml", "lang", "en");
        }
        this.setAttribute("lang", "en");
        this.openTag("html");
    }

    public XHTMLWriter(Writer w2) {
        this(w2, "  ", "strict");
    }

    public void closeDoc() {
        if (!this.closed) {
            this.closeTag();
        }
        super.closeDoc();
    }

    public void printTag(String name) {
        this.checkNameValid(name);
        this.writer.print("<" + name);
        this.printAttributes(name.length());
        this.writer.println(" />");
    }

    public void setAttribute(String name, boolean value) {
        if (value) {
            this.setAttribute(name, name);
        }
    }

    public void printPlain(String text) {
        this.writer.print(text);
    }
}

