/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.CompressableOutputStream;
import org.freehep.util.io.FinishableOutputStream;

public class BitOutputStream
extends CompressableOutputStream
implements FinishableOutputStream {
    private int bits = 0;
    private int bitPos = 0;

    public BitOutputStream(OutputStream out) {
        super(out);
    }

    public void write(int b2) throws IOException {
        super.write(b2);
    }

    public void finish() throws IOException {
        this.flushByte();
        if (this.out instanceof FinishableOutputStream) {
            ((FinishableOutputStream)((Object)this.out)).finish();
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    protected void flushByte() throws IOException {
        if (this.bitPos == 0) {
            return;
        }
        this.write(this.bits);
        this.bits = 0;
        this.bitPos = 0;
    }

    public void byteAlign() throws IOException {
        this.flushByte();
    }

    public void writeBitFlag(boolean bit) throws IOException {
        this.writeUBits(bit ? 1L : 0L, 1);
    }

    public void writeSBits(long value, int n2) throws IOException {
        long tmp = value & Integer.MAX_VALUE;
        if (value < 0L) {
            tmp |= 1L << n2 - 1;
        }
        this.writeUBits(tmp, n2);
    }

    public void writeFBits(float value, int n2) throws IOException {
        if (n2 == 0) {
            return;
        }
        long tmp = (long)(value * 65536.0f);
        this.writeSBits(tmp, n2);
    }

    /*
     * Unable to fully structure code
     */
    public void writeUBits(long value, int n) throws IOException {
        if (n == 0) {
            return;
        }
        if (this.bitPos == 0) {
            this.bitPos = 8;
        }
        bitNum = n;
        ** GOTO lbl20
        {
            or = value & 1L << bitNum - 1;
            shift = this.bitPos - bitNum;
            or = shift < 0 ? (or >>= -shift) : (or <<= shift);
            this.bits = (int)((long)this.bits | or);
            --bitNum;
            --this.bitPos;
            do {
                if (this.bitPos > 0 && bitNum > 0) continue block0;
                if (this.bitPos != 0) continue;
                this.write(this.bits);
                this.bits = 0;
                if (bitNum <= 0) continue;
                this.bitPos = 8;
lbl20:
                // 4 sources

            } while (bitNum > 0);
        }
    }

    public static int minBits(float number) {
        return BitOutputStream.minBits((int)number, true) + 16;
    }

    public static int minBits(long number) {
        return BitOutputStream.minBits(number, number < 0L);
    }

    public static int minBits(long number, boolean signed) {
        number = Math.abs(number);
        long x2 = 1L;
        int i2 = 1;
        while (i2 <= 64) {
            if ((x2 <<= 1) > number) break;
            ++i2;
        }
        return i2 + (signed ? 1 : 0);
    }
}

