/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.util.io.FinishableOutputStream;

public class Base64OutputStream
extends FilterOutputStream
implements FinishableOutputStream {
    private int MAX_LINE_LENGTH = 74;
    private int position = 0;
    private byte[] buffer = new byte[3];
    private int bufferLength;
    private int lineLength = 0;
    private static final char[] intToBase64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public Base64OutputStream(OutputStream out) {
        super(out);
    }

    public void write(int a2) throws IOException {
        this.buffer[this.position++] = (byte)a2;
        if (this.position < this.buffer.length) {
            return;
        }
        this.writeTuple();
        this.lineLength += 4;
        if (this.lineLength >= this.MAX_LINE_LENGTH) {
            this.out.write(10);
            this.lineLength = 0;
        }
        this.position = 0;
    }

    public void finish() throws IOException {
        this.writeTuple();
        this.flush();
        if (this.out instanceof FinishableOutputStream) {
            ((FinishableOutputStream)((Object)this.out)).finish();
        }
    }

    public void close() throws IOException {
        this.finish();
        super.close();
    }

    private void writeTuple() throws IOException {
        int data = (this.position > 0 ? this.buffer[0] << 16 & 0xFF0000 : 0) | (this.position > 1 ? this.buffer[1] << 8 & 0xFF00 : 0) | (this.position > 2 ? this.buffer[2] & 0xFF : 0);
        switch (this.position) {
            case 3: {
                this.out.write(intToBase64[data >> 18 & 0x3F]);
                this.out.write(intToBase64[data >> 12 & 0x3F]);
                this.out.write(intToBase64[data >> 6 & 0x3F]);
                this.out.write(intToBase64[data & 0x3F]);
                return;
            }
            case 2: {
                this.out.write(intToBase64[data >> 18 & 0x3F]);
                this.out.write(intToBase64[data >> 12 & 0x3F]);
                this.out.write(intToBase64[data >> 6 & 0x3F]);
                this.out.write(61);
                return;
            }
            case 1: {
                this.out.write(intToBase64[data >> 18 & 0x3F]);
                this.out.write(intToBase64[data >> 12 & 0x3F]);
                this.out.write(61);
                this.out.write(61);
                return;
            }
        }
    }
}

