/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.commandline;

import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.freehep.util.commandline.CommandLineException;
import org.freehep.util.commandline.MissingArgumentException;
import org.freehep.util.commandline.NoSuchOptionException;
import org.freehep.util.commandline.NoSuchQualifierException;
import org.freehep.util.commandline.TooManyArgumentsException;

public class CommandLine {
    private String name;
    private String description;
    private int numberOfParameters;
    private Hashtable options;
    private TreeMap sortedOptions;
    private Vector parameters;
    private CommandLineException exception;
    private boolean multiLevel;
    private boolean check = true;
    private Vector arguments = new Vector();
    private Hashtable flags = new Hashtable();

    public CommandLine(String name, String description, int numberOfParameters, boolean multiLevel) {
        this.name = name;
        this.description = description;
        this.numberOfParameters = numberOfParameters;
        this.multiLevel = multiLevel;
        this.parameters = new Vector();
        this.exception = null;
        this.options = new Hashtable();
        this.sortedOptions = new TreeMap(new Comparator(){

            public int compare(Object obj1, Object obj2) {
                return ((String)obj1).compareTo((String)obj2);
            }
        });
    }

    public CommandLine(String name, String description, int numberOfParameters) {
        this(name, description, numberOfParameters, false);
    }

    public void enableChecking(boolean check) {
        this.check = check;
    }

    public void addOption(String longName, String shortName, String comment) {
        this.addOption(new Option(longName, shortName, comment));
    }

    public void addOption(String longName, String shortName, String[] qualifiers, String comment) {
        this.addOption(new Option(longName, shortName, qualifiers, comment));
    }

    public void addOption(String longName, String shortName, String valueDescription, String comment) {
        this.addOption(new Option(longName, shortName, valueDescription, comment));
    }

    public void addBailOutOption(String longName, String shortName, String comment) {
        this.addOption(new Option(longName, shortName, comment, true));
    }

    public void addMultiOption(String name, String valueDescription, String comment) {
        this.addOption(new Option(name, name, valueDescription, comment, true));
    }

    private void addOption(Option option) {
        this.options.put(option.getName(), option);
        this.sortedOptions.put(option.getName(), option);
        if (option.getShortName() != null) {
            this.options.put(option.getShortName(), option);
        }
    }

    public void addParameter(String name, String comment) {
        Parameter par = new Parameter(name, comment, this.parameters.size() >= this.numberOfParameters);
        this.parameters.addElement(par);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Enumeration getOptions() {
        return this.options.keys();
    }

    public Enumeration getParameters() {
        return this.parameters.elements();
    }

    public boolean isLegalOption(String name) {
        return this.options.containsKey(name);
    }

    /*
     * Unable to fully structure code
     */
    public boolean parse(String[] args) throws CommandLineException {
        bailOut = false;
        i = 0;
        while (i < args.length) {
            block15: {
                if (args[i].charAt(0) != '-') ** GOTO lbl46
                j = args[i].charAt(1) != '-' ? 1 : 2;
                flag = new StringBuffer();
                qualified = false;
                while (j < args[i].length()) {
                    switch (args[i].charAt(j)) {
                        case '-': {
                            this.checkflag(flag.toString(), null, qualified);
                            bailOut |= ((Option)this.options.get(flag.toString())).isBailOut();
                            flag = new StringBuffer();
                            qualified = false;
                            break;
                        }
                        case ':': {
                            qualified = true;
                            qualifier = args[i].substring(j + 1);
                            j = args[i].length() - 1;
                            this.checkflag(flag.toString(), qualifier, qualified);
                            flag = new StringBuffer();
                            qualified = false;
                            break;
                        }
                        case '=': {
                            value = args[i].substring(j + 1);
                            j = args[i].length() - 1;
                            this.checkflag(flag.toString() + "=" + value, value, qualified);
                            flag = new StringBuffer();
                            qualified = false;
                            break;
                        }
                        default: {
                            flag.append(args[i].charAt(j));
                        }
                    }
                    ++j;
                }
                if (flag.length() <= 0) break block15;
                if (this.checkflag(flag.toString(), i + 1 < args.length ? args[i + 1] : null, qualified)) {
                    ++i;
                }
                bailOut |= (option = (Option)this.options.get(flag.toString())) == null ? false : option.isBailOut();
                break block15;
lbl-1000:
                // 1 sources

                {
                    this.arguments.addElement(args[i]);
                    ++i;
lbl46:
                    // 2 sources

                    ** while (i < args.length)
                }
            }
            ++i;
        }
        if (!bailOut) {
            if (this.arguments.size() < this.numberOfParameters) {
                this.exception = new MissingArgumentException("Too few arguments: " + this.arguments.size() + ", while " + this.numberOfParameters + " " + (this.parameters.size() == 1 ? "was" : "were") + " expected.");
                throw this.exception;
            }
            if (!(!this.check || this.multiLevel || this.parameters.size() != 0 && ((Parameter)this.parameters.elementAt(this.parameters.size() - 1)).getName().endsWith("...") || this.arguments.size() <= this.parameters.size())) {
                this.exception = new TooManyArgumentsException("Too many arguments: " + this.arguments.size() + ", while " + this.parameters.size() + " " + (this.parameters.size() == 1 ? "was" : "were") + " expected.");
                throw this.exception;
            }
        }
        this.exception = null;
        return bailOut == false;
    }

    private boolean checkflag(String flag, String value, boolean qualified) throws CommandLineException {
        if (this.check && flag.length() <= 0) {
            this.exception = new NoSuchOptionException("Option has zero length");
            throw this.exception;
        }
        Option option = (Option)this.options.get(flag);
        if (option != null) {
            if (qualified) {
                String[] qualifiers = option.getQualifiers();
                int j2 = 0;
                while (j2 < qualifiers.length) {
                    if (value.equals(qualifiers[j2])) {
                        this.setFlag(option, value);
                        return false;
                    }
                    ++j2;
                }
                this.exception = new NoSuchQualifierException("Qualifier '" + value + "' for option '" + flag + "' does not exist.");
                throw this.exception;
            }
            if (option.getValue() == null) {
                this.setFlag(option, "true");
                return false;
            }
            if (value == null) {
                this.exception = new MissingArgumentException("Missing argument <" + option.getValue() + "> for option '" + flag + "'.");
                throw this.exception;
            }
            this.setFlag(option, value);
            return true;
        }
        Enumeration e2 = this.options.elements();
        while (e2.hasMoreElements()) {
            Option opt = (Option)e2.nextElement();
            if (!opt.isMulti() || !flag.startsWith(opt.getName())) continue;
            if (opt.getName().length() < flag.length()) {
                this.setFlag(opt, flag.substring(opt.getName().length()));
                return false;
            }
            this.exception = new MissingArgumentException("Missing argument <" + opt.getValue() + "> for option '" + opt.getName() + "'.");
            throw this.exception;
        }
        if (this.check) {
            this.exception = new NoSuchOptionException("Option '" + flag + "' does not exist.");
            throw this.exception;
        }
        return false;
    }

    private void setFlag(Option option, String value) {
        if (option.isMulti()) {
            if (this.flags.get(option.getName()) == null) {
                this.flags.put(option.getName(), new Vector());
            }
            Vector values = (Vector)this.flags.get(option.getName());
            values.addElement(value);
        } else {
            this.flags.put(option.getName(), value);
        }
        if (option.getShortName() != null) {
            this.flags.put(option.getShortName(), value);
        }
    }

    public CommandLineException getException() {
        return this.exception;
    }

    public String toString() {
        StringBuffer s2 = new StringBuffer("CommandLine [\n");
        s2.append("    ");
        s2.append(this.name);
        s2.append(" - ");
        s2.append(this.description);
        s2.append("\n");
        Enumeration e2 = this.flags.keys();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            s2.append("    option[");
            s2.append(key);
            s2.append("] = ");
            Option option = (Option)this.options.get(key);
            if (option.isMulti()) {
                Vector values = (Vector)this.flags.get(key);
                int i2 = 0;
                while (i2 < values.size()) {
                    s2.append((String)values.elementAt(i2) + ", ");
                    ++i2;
                }
            } else {
                s2.append(this.flags.get(key));
            }
            s2.append("\n");
        }
        Enumeration e3 = this.arguments.elements();
        while (e3.hasMoreElements()) {
            String arg = (String)e3.nextElement();
            s2.append("    arg = ");
            s2.append(arg);
            s2.append("\n");
        }
        if (this.exception != null) {
            s2.append(this.exception.getMessage());
            s2.append("\n");
        }
        s2.append("\n]");
        return s2.toString();
    }

    public String getOption(String name) {
        return this.getOption(name, null);
    }

    public Vector getMultiOption(String name) {
        Object flag = this.flags.get(name);
        return flag == null ? new Vector() : (Vector)flag;
    }

    public String getOption(String name, String defaultValue) {
        Object flag = this.flags.get(name);
        return flag == null ? defaultValue : flag.toString();
    }

    public boolean hasOption(String name) {
        return this.flags.containsKey(name);
    }

    public String getArgument(String name) {
        int i2 = 0;
        while (i2 < this.parameters.size()) {
            Parameter parameter = (Parameter)this.parameters.elementAt(i2);
            if (name.equals(parameter.getName())) {
                return (String)this.arguments.elementAt(i2);
            }
            ++i2;
        }
        return null;
    }

    public String[] getArguments() {
        Object[] s2 = new String[this.arguments.size()];
        this.arguments.copyInto(s2);
        return s2;
    }

    public String[] getUnparsedArguments() {
        String[] s2 = new String[this.arguments.size() - this.parameters.size()];
        int j2 = 0;
        int i2 = this.parameters.size();
        while (i2 < this.arguments.size()) {
            s2[j2] = (String)this.arguments.elementAt(i2);
            ++i2;
        }
        return s2;
    }

    private String pad(String str, int length) {
        String padding = "                                                             ";
        int l2 = str.length();
        if (l2 == length) {
            return str;
        }
        if (l2 < length) {
            return str + padding.substring(0, length - l2);
        }
        return str.substring(length);
    }

    public String getHelp() {
        StringBuffer s2 = new StringBuffer();
        s2.append(this.name);
        s2.append(" - ");
        s2.append(this.description);
        s2.append("\n");
        s2.append("Usage: ");
        s2.append(this.name);
        if (this.options.size() > 0) {
            s2.append(" [-options]");
        }
        int len = 0;
        int i2 = 0;
        while (i2 < this.parameters.size()) {
            Parameter parameter = (Parameter)this.parameters.elementAt(i2);
            len = Math.max(len, parameter.getName().length());
            if (i2 < this.numberOfParameters) {
                s2.append(" <");
                s2.append(parameter.getName());
                s2.append(">");
            } else {
                s2.append(" [");
                s2.append(parameter.getName());
            }
            ++i2;
        }
        int i3 = this.numberOfParameters;
        while (i3 < this.parameters.size()) {
            s2.append("]");
            ++i3;
        }
        s2.append("\n\n");
        if (!this.parameters.isEmpty()) {
            s2.append("where:\n");
            int i4 = 0;
            while (i4 < this.parameters.size()) {
                Parameter parameter = (Parameter)this.parameters.elementAt(i4);
                s2.append("    ");
                s2.append(this.pad(parameter.getName(), len));
                s2.append("  ");
                s2.append(parameter.getDescription());
                s2.append("\n");
                ++i4;
            }
            s2.append("\n");
        }
        if (!this.sortedOptions.isEmpty()) {
            s2.append("where options include:\n");
            len = 0;
            int slen = 0;
            Iterator iterator = this.sortedOptions.entrySet().iterator();
            while (iterator.hasNext()) {
                Option option = (Option)iterator.next().getValue();
                len = Math.max(len, option.getString().length());
                slen = Math.max(slen, option.getShortName() == null ? 0 : option.getShortName().length());
            }
            boolean multi = false;
            Iterator iterator2 = this.sortedOptions.keySet().iterator();
            while (iterator2.hasNext()) {
                String key = (String)iterator2.next();
                Option option = (Option)this.sortedOptions.get(key);
                s2.append("    ");
                if (slen > 0) {
                    if (option.getShortName() == null) {
                        s2.append(option.isMulti() ? "*" : " ");
                        multi |= option.isMulti();
                        s2.append(this.pad("", slen));
                    } else {
                        s2.append("-");
                        s2.append(this.pad(option.getShortName(), slen));
                    }
                    s2.append(" ");
                }
                s2.append(this.pad(option.getString(), len));
                s2.append("  ");
                s2.append(option.getDescription());
                s2.append("\n");
            }
            s2.append("\n");
            if (multi) {
                s2.append("(* option can be specified multiple times).\n");
                s2.append("\n");
            }
        }
        return s2.toString();
    }

    public static class Option {
        private String name;
        private String shortName;
        private String description;
        private String[] qualifiers = null;
        private String value = null;
        private boolean multi = false;
        private boolean bailOut;

        public Option(String name, String shortName, String description) {
            this(name, shortName, description, false);
        }

        public Option(String name, String shortName, String description, boolean bailOut) {
            this.name = name;
            this.shortName = shortName;
            this.description = description;
            this.bailOut = bailOut;
        }

        public Option(String name, String shortName, String[] qualifiers, String description) {
            this(name, shortName, description);
            this.qualifiers = qualifiers;
        }

        public Option(String name, String shortName, String value, String description) {
            this(name, shortName, description);
            this.value = value;
        }

        public Option(String name, String shortName, String value, String description, boolean multi) {
            this(name, multi ? null : shortName, description);
            this.value = value;
            this.multi = multi;
        }

        public String getName() {
            return this.name;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isBailOut() {
            return this.bailOut;
        }

        public String[] getQualifiers() {
            return this.qualifiers;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isMulti() {
            return this.multi;
        }

        public String getString() {
            StringBuffer s2 = new StringBuffer("-");
            s2.append(this.name);
            if (this.value != null) {
                if (!this.isMulti()) {
                    s2.append(" ");
                }
                s2.append("<");
                s2.append(this.value);
                s2.append(">");
            } else if (this.qualifiers != null) {
                s2.append(":{");
                int i2 = 0;
                while (i2 < this.qualifiers.length) {
                    if (i2 > 0) {
                        s2.append("|");
                    }
                    s2.append(this.qualifiers[i2]);
                    ++i2;
                }
                s2.append("}");
            }
            return s2.toString();
        }
    }

    public static class Parameter {
        private String name;
        private String description;
        private boolean optional;

        public Parameter(String name, String description, boolean optional) {
            this.name = name;
            this.description = description;
            this.optional = optional;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isOptional() {
            return this.optional;
        }
    }
}

