/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class UserProperties
extends Properties {
    protected Properties altDefaults;

    public UserProperties() {
        this.altDefaults = new Properties();
    }

    public UserProperties(Properties defaults) {
        super(defaults);
        this.altDefaults = new Properties();
    }

    public UserProperties(Properties defaults, Properties altDefaults) {
        super(defaults);
        this.altDefaults = altDefaults;
    }

    public Enumeration propertyNames() {
        Hashtable names = new Hashtable();
        Enumeration<?> e2 = super.propertyNames();
        while (e2.hasMoreElements()) {
            names.put(e2.nextElement(), names);
        }
        if (this.altDefaults != null) {
            Enumeration<?> e3 = this.altDefaults.propertyNames();
            while (e3.hasMoreElements()) {
                names.put(e3.nextElement(), names);
            }
        }
        return names.keys();
    }

    public void setProperties(Properties properties) {
        Enumeration<?> e2 = properties.propertyNames();
        while (e2.hasMoreElements()) {
            String key = (String)e2.nextElement();
            this.setProperty(key, properties.getProperty(key));
        }
    }

    public Object setProperty(String key, String value) {
        if (value == null) {
            return super.setProperty(key, "null");
        }
        return super.setProperty(key, value);
    }

    public Object setProperty(String key, String[] value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, String[] value) {
        if (value == null) {
            return properties.setProperty(key, "null");
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < value.length) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(value[i2]);
            ++i2;
        }
        return properties.setProperty(key, sb.toString());
    }

    public Object setProperty(String key, Color value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, Color value) {
        if (value == null) {
            return properties.setProperty(key, "null");
        }
        return properties.setProperty(key, value.getRed() + ", " + value.getGreen() + ", " + value.getBlue() + ", " + value.getAlpha());
    }

    public Object setProperty(String key, Rectangle value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, Rectangle value) {
        if (value == null) {
            return properties.setProperty(key, "null");
        }
        return properties.setProperty(key, value.x + ", " + value.y + ", " + value.width + ", " + value.height);
    }

    public Object setProperty(String key, Insets value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, Insets value) {
        if (value == null) {
            return properties.setProperty(key, "null");
        }
        return properties.setProperty(key, value.top + ", " + value.left + ", " + value.bottom + ", " + value.right);
    }

    public Object setProperty(String key, Dimension value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, Dimension value) {
        if (value == null) {
            return properties.setProperty(key, "null");
        }
        return properties.setProperty(key, value.width + ", " + value.height);
    }

    public Object setProperty(String key, int value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, int value) {
        return properties.setProperty(key, Integer.toString(value));
    }

    public Object setProperty(String key, double value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, double value) {
        return properties.setProperty(key, Double.toString(value));
    }

    public Object setProperty(String key, float value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, float value) {
        return properties.setProperty(key, Float.toString(value));
    }

    public Object setProperty(String key, boolean value) {
        return UserProperties.setProperty((Properties)this, key, value);
    }

    public static Object setProperty(Properties properties, String key, boolean value) {
        return properties.setProperty(key, Boolean.toString(value));
    }

    public String getProperty(String key) {
        String value = super.getProperty(key);
        return value != null ? value : this.altDefaults.getProperty(key);
    }

    public String getProperty(String key, String def) {
        String value = this.getProperty(key);
        return value != null ? value : def;
    }

    public String[] getPropertyStringArray(String key) {
        return this.getPropertyStringArray(key, null);
    }

    public String[] getPropertyStringArray(String key, String[] def) {
        String s2 = this.getProperty(key);
        if (s2 == null) {
            return def;
        }
        if (s2.equals("null")) {
            return null;
        }
        return s2.split(", ");
    }

    public Color getPropertyColor(String key) {
        return this.getPropertyColor(key, null);
    }

    public Color getPropertyColor(String key, Color def) {
        String s2 = this.getProperty(key);
        if (s2 == null) {
            return def;
        }
        if (s2.equals("null")) {
            return null;
        }
        String[] r2 = s2.split(", ");
        return new Color(Integer.parseInt(r2[0]), Integer.parseInt(r2[1]), Integer.parseInt(r2[2]), Integer.parseInt(r2[3]));
    }

    public Rectangle getPropertyRectangle(String key) {
        return this.getPropertyRectangle(key, null);
    }

    public Rectangle getPropertyRectangle(String key, Rectangle def) {
        String s2 = this.getProperty(key);
        if (s2 == null) {
            return def;
        }
        if (s2.equals("null")) {
            return null;
        }
        String[] r2 = s2.split(", ");
        return new Rectangle(Integer.parseInt(r2[0]), Integer.parseInt(r2[1]), Integer.parseInt(r2[2]), Integer.parseInt(r2[3]));
    }

    public Insets getPropertyInsets(String key) {
        return this.getPropertyInsets(key, null);
    }

    public Insets getPropertyInsets(String key, Insets def) {
        String s2 = this.getProperty(key);
        if (s2 == null) {
            return def;
        }
        if (s2.equals("null")) {
            return null;
        }
        String[] r2 = s2.split(", ");
        return new Insets(Integer.parseInt(r2[0]), Integer.parseInt(r2[1]), Integer.parseInt(r2[2]), Integer.parseInt(r2[3]));
    }

    public Dimension getPropertyDimension(String key) {
        return this.getPropertyDimension(key, null);
    }

    public Dimension getPropertyDimension(String key, Dimension def) {
        String s2 = this.getProperty(key);
        if (s2 == null) {
            return def;
        }
        if (s2.equals("null")) {
            return null;
        }
        String[] d2 = s2.split(", ");
        return new Dimension(Integer.parseInt(d2[0]), Integer.parseInt(d2[1]));
    }

    public int getPropertyInt(String key) {
        return this.getPropertyInt(key, 0);
    }

    public int getPropertyInt(String key, int def) {
        return new Integer(this.getProperty(key, Integer.toString(def)));
    }

    public double getPropertyDouble(String key) {
        return this.getPropertyDouble(key, 0.0);
    }

    public double getPropertyDouble(String key, double def) {
        return new Double(this.getProperty(key, Double.toString(def)));
    }

    public float getPropertyFloat(String key) {
        return this.getPropertyFloat(key, 0.0f);
    }

    public float getPropertyFloat(String key, float def) {
        return new Float(this.getProperty(key, Float.toString(def))).floatValue();
    }

    public boolean isProperty(String key) {
        return this.isProperty(key, false);
    }

    public boolean isProperty(String key, boolean def) {
        return new Boolean(this.getProperty(key, Boolean.toString(def)));
    }
}

