/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.plaf.metal;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.freehep.swing.JTriStateMenuItem;

public class CheckBoxMenuItemIcon
implements Icon,
UIResource,
Serializable {
    private static final Dimension menuCheckIconSize = new Dimension(10, 10);

    public void paintIcon(Component c2, Graphics g2, int x2, int y2) {
        JTriStateMenuItem b2 = (JTriStateMenuItem)c2;
        ButtonModel model = b2.getModel();
        int state = b2.getTriState();
        boolean isSelected = model.isSelected();
        boolean isEnabled = model.isEnabled();
        boolean isPressed = model.isPressed();
        boolean isArmed = model.isArmed();
        g2.translate(x2, y2);
        if (isEnabled) {
            if (isPressed || isArmed) {
                g2.setColor(MetalLookAndFeel.getControlInfo());
                g2.drawLine(0, 0, 8, 0);
                g2.drawLine(0, 0, 0, 8);
                g2.drawLine(8, 2, 8, 8);
                g2.drawLine(2, 8, 8, 8);
                g2.setColor(MetalLookAndFeel.getPrimaryControl());
                g2.drawLine(1, 1, 7, 1);
                g2.drawLine(1, 1, 1, 7);
                g2.drawLine(9, 1, 9, 9);
                g2.drawLine(1, 9, 9, 9);
            } else {
                g2.setColor(MetalLookAndFeel.getControlDarkShadow());
                g2.drawLine(0, 0, 8, 0);
                g2.drawLine(0, 0, 0, 8);
                g2.drawLine(8, 2, 8, 8);
                g2.drawLine(2, 8, 8, 8);
                g2.setColor(MetalLookAndFeel.getControlHighlight());
                g2.drawLine(1, 1, 7, 1);
                g2.drawLine(1, 1, 1, 7);
                g2.drawLine(9, 1, 9, 9);
                g2.drawLine(1, 9, 9, 9);
            }
        } else {
            g2.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            g2.drawRect(0, 0, 8, 8);
        }
        if (isSelected) {
            if (isEnabled) {
                if (state == -1) {
                    g2.setColor(MetalLookAndFeel.getControlShadow());
                    g2.fillRect(1, 1, 8, 8);
                }
                if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
                    g2.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                } else {
                    g2.setColor(b2.getForeground());
                }
            } else {
                g2.setColor(MetalLookAndFeel.getMenuDisabledForeground());
            }
            g2.drawLine(2, 2, 2, 6);
            g2.drawLine(3, 2, 3, 6);
            g2.drawLine(4, 4, 8, 0);
            g2.drawLine(4, 5, 9, 0);
        }
        g2.translate(-x2, -y2);
    }

    public int getIconWidth() {
        return CheckBoxMenuItemIcon.menuCheckIconSize.width;
    }

    public int getIconHeight() {
        return CheckBoxMenuItemIcon.menuCheckIconSize.height;
    }
}

