/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.graphics;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.freehep.swing.graphics.GraphicalSelectionEvent;
import org.freehep.swing.graphics.GraphicalSelectionPanel;
import org.freehep.swing.graphics.PointSelectionEvent;
import org.freehep.swing.images.FreeHepImage;

public class PointSelectionPanel
extends GraphicalSelectionPanel {
    private static final int cursorSize = 10;
    Rectangle oldBounds = new Rectangle();
    Rectangle lastDrawnRect = new Rectangle();
    Rectangle updateRect = new Rectangle();
    private Point currentPoint = new Point();
    private int xmin;
    private int xmax;
    private int ymin;
    private int ymax;
    private boolean cursorVisible = false;
    private static Cursor invisibleCursor;
    private Cursor savedCursor;

    public PointSelectionPanel() {
        this.setSelectionActionsEnabled(false);
        BufferedImage cursorImage = new BufferedImage(16, 16, 2);
        Graphics g2 = cursorImage.getGraphics();
        g2.setColor(new Color(0, 0, 0, 0));
        g2.fillRect(0, 0, 16, 16);
        Toolkit toolKit = Toolkit.getDefaultToolkit();
        invisibleCursor = toolKit.createCustomCursor(cursorImage, new Point(0, 0), "InvisibleCursor");
        this.setCursor(FreeHepImage.getCursor("PointCursor"));
    }

    public void keyReleased(KeyEvent e2) {
        int increment = e2.isShiftDown() ? 1 : 2;
        switch (e2.getKeyCode()) {
            case 38: {
                this.updatePosition(this.currentPoint.x, this.currentPoint.y - increment);
                break;
            }
            case 40: {
                this.updatePosition(this.currentPoint.x, this.currentPoint.y + increment);
                break;
            }
            case 39: {
                this.updatePosition(this.currentPoint.x + increment, this.currentPoint.y);
                break;
            }
            case 37: {
                this.updatePosition(this.currentPoint.x - increment, this.currentPoint.y);
                break;
            }
            default: {
                super.keyReleased(e2);
            }
        }
    }

    public void mousePressed(MouseEvent e2) {
        if (!this.isProcessingPopup(e2)) {
            this.cursorVisible = true;
            this.setSelectionActionsEnabled(true);
            this.savedCursor = this.getCursor();
            this.setCursor(invisibleCursor);
            this.updatePosition(e2.getX(), e2.getY());
        }
    }

    public void mouseReleased(MouseEvent e2) {
        if (!this.isProcessingPopup(e2)) {
            this.setCursor(this.savedCursor);
            this.updatePosition(e2.getX(), e2.getY());
        }
    }

    public void mouseDragged(MouseEvent e2) {
        if (!this.isProcessingPopup(e2)) {
            this.updatePosition(e2.getX(), e2.getY());
        }
    }

    public void updatePosition(int x2, int y2) {
        if (this.cursorVisible) {
            this.xmin = 1;
            this.xmax = this.getWidth() - 1;
            this.ymin = 1;
            this.ymax = this.getHeight() - 1;
            x2 = Math.max(Math.min(x2, this.xmax), this.xmin);
            y2 = Math.max(Math.min(y2, this.ymax), this.ymin);
            this.currentPoint.setLocation(x2, y2);
            int xLow = this.currentPoint.x - 10;
            int yLow = this.currentPoint.y - 10;
            this.updateRect.setBounds(this.lastDrawnRect);
            this.updateRect = SwingUtilities.computeUnion(xLow, yLow, 20, 20, this.updateRect);
            this.repaint(this.updateRect);
        }
    }

    public void setCursorVisible(boolean visible) {
        if (this.cursorVisible != visible) {
            this.cursorVisible = visible;
            this.setSelectionActionsEnabled(this.cursorVisible);
            this.repaint();
        }
    }

    public boolean getCursorVisible() {
        return this.cursorVisible;
    }

    public void resetSelection() {
        this.cursorVisible = false;
        this.updateRect.setBounds(this.lastDrawnRect);
        this.setSelectionActionsEnabled(false);
        this.repaint(this.updateRect);
    }

    public void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        if (this.cursorVisible) {
            Graphics2D g2d = (Graphics2D)g2;
            int xLow = this.currentPoint.x - 10;
            int xHigh = this.currentPoint.x + 10;
            int yLow = this.currentPoint.y - 10;
            int yHigh = this.currentPoint.y + 10;
            g2d.setStroke(GraphicalSelectionPanel.thickStroke);
            g2.setColor(Color.black);
            g2.drawLine(this.currentPoint.x, yLow, this.currentPoint.x, yHigh);
            g2.drawLine(xLow, this.currentPoint.y, xHigh, this.currentPoint.y);
            g2d.setStroke(GraphicalSelectionPanel.thinStroke);
            g2.setColor(Color.white);
            g2.drawLine(this.currentPoint.x, yLow, this.currentPoint.x, yHigh);
            g2.drawLine(xLow, this.currentPoint.y, xHigh, this.currentPoint.y);
            this.lastDrawnRect.setRect(xLow - 1, yLow - 1, 23.0, 23.0);
        }
    }

    public AffineTransform makeAffineTransform() {
        return new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)this.getWidth() / 2.0 - (double)this.currentPoint.x, (double)this.getHeight() / 2.0 - (double)this.currentPoint.y);
    }

    protected void makeSelectionEvent(int actionCode) {
        switch (actionCode) {
            case 13: {
                this.resetSelection();
                this.setVisible(false);
                this.fireGraphicalSelectionMade(new GraphicalSelectionEvent(this, 13, null, null));
                break;
            }
            case 10: {
                this.resetSelection();
                this.setVisible(false);
                this.fireGraphicalSelectionMade(new GraphicalSelectionEvent(this, 10, null, null));
                break;
            }
            case 11: {
                this.resetSelection();
                this.setVisible(false);
                this.fireGraphicalSelectionMade(new GraphicalSelectionEvent(this, 11, null, null));
                break;
            }
            case 0: 
            case 1: {
                if (this.cursorVisible) {
                    this.fireGraphicalSelectionMade(new PointSelectionEvent((Object)this, actionCode, this.currentPoint, this.makeAffineTransform()));
                }
                this.resetSelection();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                if (this.cursorVisible) {
                    AffineTransform trans = this.makeAffineTransform();
                    double size = 20.0;
                    double halfWidth = (double)this.getWidth() / 2.0;
                    double sx = halfWidth / size;
                    double halfHeight = (double)this.getHeight() / 2.0;
                    double sy = halfHeight / size;
                    AffineTransform scaling = new AffineTransform(sx, 0.0, 0.0, sy, halfWidth * (1.0 - sx), halfHeight * (1.0 - sy));
                    trans.preConcatenate(scaling);
                    this.fireGraphicalSelectionMade(new PointSelectionEvent((Object)this, actionCode, this.currentPoint, trans));
                }
                this.resetSelection();
            }
        }
    }
}

