/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JDirectoryChooser
extends JComponent {
    private FileTreeModel model = new FileTreeModel();
    private JFileChooser foo = new JFileChooser();
    private JButton approve = new JButton("Select");
    private JButton cancel = new JButton("Cancel");
    private File currentDirectory = null;
    private JTree tree;
    private JDialog dialog;
    private int returnValue;
    public static int APPROVE_OPTION = 0;
    public static int CANCEL_OPTION = 1;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private static File root = new File("root");
    static /* synthetic */ Class class$java$awt$Frame;
    static /* synthetic */ Class class$javax$swing$event$TreeModelListener;
    static /* synthetic */ Class class$java$awt$Window;

    public JDirectoryChooser() {
        this(FileSystemView.getFileSystemView());
    }

    public JDirectoryChooser(File currentDirectory) {
        this();
        this.setCurrentDirectory(currentDirectory);
    }

    public JDirectoryChooser(String currentDirectory) {
        this();
        if (currentDirectory != null) {
            this.setCurrentDirectory(new File(currentDirectory));
        }
    }

    public JDirectoryChooser(File currentDirectory, FileSystemView view) {
        this(view);
        this.setCurrentDirectory(currentDirectory);
    }

    public JDirectoryChooser(String currentDirectory, FileSystemView view) {
        this(view);
        this.setCurrentDirectory(new File(currentDirectory));
    }

    public JDirectoryChooser(FileSystemView view) {
        this.setup(view);
        ButtonListener al = new ButtonListener();
        this.tree = new JTree();
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new FileRenderer());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(al);
        this.approve.addActionListener(al);
        this.cancel.addActionListener(al);
        this.approve.setEnabled(false);
        this.setLayout(new BorderLayout());
        this.add(new JScrollPane(this.tree));
        JPanel p2 = new JPanel(new FlowLayout());
        p2.add(this.approve);
        p2.add(this.cancel);
        this.add((Component)p2, "South");
    }

    public void addNotify() {
        this.tree.setModel(this.model);
        this.makeCurrentDirectoryVisible();
        super.addNotify();
    }

    private void makeCurrentDirectoryVisible() {
        if (this.currentDirectory != null) {
            Object node;
            File dir = this.currentDirectory;
            FileSystemView view = this.foo.getFileSystemView();
            Vector<File> v2 = new Vector<File>();
            while (true) {
                if (dir == null) {
                    return;
                }
                v2.addElement(dir);
                if (view.isRoot(dir)) break;
                dir = view.getParentDirectory(dir);
            }
            Object[] files = new File[v2.size() + 1];
            files[0] = node = this.model.getRoot();
            int i2 = 1;
            while (i2 < files.length) {
                File here = (File)v2.elementAt(files.length - i2 - 1);
                int index = this.model.getIndexOfChild(node, here);
                if (index < 0) {
                    return;
                }
                files[i2] = node = this.model.getChild(node, index);
                ++i2;
            }
            TreePath path = new TreePath(files);
            this.tree.setSelectionPath(path);
            this.tree.scrollPathToVisible(path);
        }
    }

    public void setCurrentDirectory(File dir) {
        this.currentDirectory = dir;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.foo.setFileFilter(fileFilter);
        this.model.changed();
    }

    public FileFilter getFileFilter() {
        return this.foo.getFileFilter();
    }

    public void setFileHidingEnabled(boolean hide) {
        this.foo.setFileHidingEnabled(hide);
        this.model.changed();
    }

    public boolean isFileHidingEnabled() {
        return this.foo.isFileHidingEnabled();
    }

    public void setFileSelectionMode(int mode) {
        this.foo.setFileSelectionMode(mode);
        this.model.changed();
    }

    public int getFileSelectionMode() {
        return this.foo.getFileSelectionMode();
    }

    public void setMultiSelectionEnabled(boolean enable) {
        this.foo.setMultiSelectionEnabled(enable);
        this.tree.getSelectionModel().setSelectionMode(enable ? 4 : 1);
    }

    public boolean isMultiSelectionEnabled() {
        return this.foo.isMultiSelectionEnabled();
    }

    public File getSelectedFile() {
        return (File)this.tree.getLastSelectedPathComponent();
    }

    public File[] getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        File[] result = new File[paths.length];
        int i2 = 0;
        while (i2 < paths.length) {
            result[i2] = (File)paths[i2].getLastPathComponent();
            ++i2;
        }
        return result;
    }

    protected void setup(FileSystemView view) {
        this.foo.setFileSystemView(view);
    }

    public void updateUI() {
        super.updateUI();
        this.foo.updateUI();
    }

    public int showDialog(Component parent) {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = JDirectoryChooser.class$("java.awt.Frame")) : class$java$awt$Frame, parent);
        String title = null;
        title = this.foo.getDialogTitle();
        if (title == null) {
            this.foo.getUI().getDialogTitle(this.foo);
        }
        this.returnValue = 1;
        this.dialog = new JDialog(frame, title, true);
        this.dialog.getContentPane().add((Component)this, "Center");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
        this.dialog.show();
        return this.returnValue;
    }

    public void setDialogTitle(String dialogTitle) {
        this.foo.setDialogTitle(dialogTitle);
    }

    public String getDialogTitle() {
        return this.foo.getDialogTitle();
    }

    public void setFileView(FileView fileView) {
        this.foo.setFileView(fileView);
    }

    public FileView getFileView() {
        return this.foo.getFileView();
    }

    public static void main(String[] argv) {
        final JTextField tf = new JTextField(40);
        JButton b2 = new JButton("Show Browser"){

            public void fireActionPerformed(ActionEvent e2) {
                JDirectoryChooser dlg = new JDirectoryChooser(tf.getText());
                dlg.showDialog(this);
                if (dlg.getSelectedFile() != null) {
                    tf.setText(dlg.getSelectedFile().toString());
                }
            }
        };
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)b2, "Center");
        frame.getContentPane().add((Component)tf, "South");
        frame.pack();
        frame.show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FileTreeModel
    implements TreeModel {
        private EventListenerList listenerList = new EventListenerList();
        private final int CACHE_SIZE = 10;
        private File[] cachedNode = new File[10];
        private File[][] cachedChildren = new File[10][];
        private int nextCache = 0;

        private FileTreeModel() {
        }

        public Object getChild(Object node, int index) {
            return this.children(node)[index];
        }

        public int getChildCount(Object node) {
            return this.children(node).length;
        }

        public int getIndexOfChild(Object node, Object child) {
            File[] children = this.children(node);
            int i2 = 0;
            while (i2 < children.length) {
                if (children[i2].equals(child)) {
                    return i2;
                }
                ++i2;
            }
            return -1;
        }

        public Object getRoot() {
            return root;
        }

        public boolean isLeaf(Object node) {
            return node != root && !((File)node).isDirectory();
        }

        public void valueForPathChanged(TreePath p1, Object p2) {
        }

        public void addTreeModelListener(TreeModelListener l2) {
            this.listenerList.add(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = JDirectoryChooser.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l2);
        }

        public void removeTreeModelListener(TreeModelListener l2) {
            this.listenerList.remove(class$javax$swing$event$TreeModelListener == null ? (class$javax$swing$event$TreeModelListener = JDirectoryChooser.class$("javax.swing.event.TreeModelListener")) : class$javax$swing$event$TreeModelListener, l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File[] children(Object node) {
            int i2 = 0;
            while (i2 < 10) {
                if (node == this.cachedNode[i2]) {
                    return this.cachedChildren[i2];
                }
                ++i2;
            }
            Window w2 = null;
            Cursor oldCursor = null;
            if (JDirectoryChooser.this.tree != null && JDirectoryChooser.this.tree.isVisible() && (w2 = (Window)SwingUtilities.getAncestorOfClass(class$java$awt$Window == null ? (class$java$awt$Window = JDirectoryChooser.class$("java.awt.Window")) : class$java$awt$Window, JDirectoryChooser.this.tree)) != null) {
                oldCursor = w2.getCursor();
                w2.setCursor(Cursor.getPredefinedCursor(3));
            }
            try {
                Object[] children;
                FileSystemView view = JDirectoryChooser.this.foo.getFileSystemView();
                File dir = (File)node;
                boolean isRoot = dir == root;
                Object[] objectArray = children = isRoot ? view.getRoots() : view.getFiles(dir, JDirectoryChooser.this.foo.isFileHidingEnabled());
                if (!isRoot) {
                    boolean dirOnly;
                    int n2 = JDirectoryChooser.this.foo.getFileSelectionMode();
                    JDirectoryChooser.this.foo;
                    boolean bl = dirOnly = n2 == 1;
                    if (JDirectoryChooser.this.foo.getFileFilter() != null || dirOnly) {
                        Vector<Object> v2 = new Vector<Object>();
                        int i3 = 0;
                        while (i3 < children.length) {
                            File f2 = children[i3];
                            if ((!dirOnly || f2.isDirectory()) && JDirectoryChooser.this.foo.accept(f2)) {
                                v2.addElement(children[i3]);
                            }
                            ++i3;
                        }
                        if (v2.size() != children.length) {
                            children = new File[v2.size()];
                            v2.copyInto(children);
                        }
                    }
                }
                this.cachedNode[this.nextCache] = dir;
                this.cachedChildren[this.nextCache] = children;
                this.nextCache = (this.nextCache + 1) % 10;
                Object[] objectArray2 = children;
                Object var14_14 = null;
                if (w2 != null) {
                    w2.setCursor(oldCursor);
                }
                return objectArray2;
            }
            catch (Throwable throwable) {
                block11: {
                    Object var14_15 = null;
                    if (w2 == null) break block11;
                    w2.setCursor(oldCursor);
                }
                throw throwable;
            }
        }

        void changed() {
            this.cachedNode = new File[10];
            this.cachedChildren = new File[10][];
            this.fireTreeStructureChanged(new TreeModelEvent((Object)this, new TreePath(root)));
        }

        protected void fireTreeStructureChanged(TreeModelEvent e2) {
            Object[] listeners = this.listenerList.getListenerList();
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == (class$javax$swing$event$TreeModelListener == null ? JDirectoryChooser.class$("javax.swing.event.TreeModelListener") : class$javax$swing$event$TreeModelListener)) {
                    ((TreeModelListener)listeners[i2 + 1]).treeStructureChanged(e2);
                }
                i2 -= 2;
            }
        }
    }

    private class FileRenderer
    extends DefaultTreeCellRenderer {
        private FileRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object node, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component comp = super.getTreeCellRendererComponent(tree, node, selected, expanded, leaf, row, hasFocus);
            if (comp instanceof JLabel && node instanceof File) {
                JLabel label = (JLabel)comp;
                File f2 = (File)node;
                label.setText(JDirectoryChooser.this.foo.getName(f2));
                label.setIcon(JDirectoryChooser.this.foo.getIcon(f2));
            }
            return comp;
        }
    }

    private class ButtonListener
    implements ActionListener,
    TreeSelectionListener {
        private ButtonListener() {
        }

        public void actionPerformed(ActionEvent e2) {
            if (e2.getSource() == JDirectoryChooser.this.approve) {
                JDirectoryChooser.this.foo;
                JDirectoryChooser.this.returnValue = 0;
            }
            JDirectoryChooser.this.dialog.hide();
            JDirectoryChooser.this.dialog = null;
        }

        public void valueChanged(TreeSelectionEvent e2) {
            JDirectoryChooser.this.approve.setEnabled(JDirectoryChooser.this.tree.getSelectionCount() > 0);
        }
    }
}

