/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.filechooser.FileFilter;

public class EndingFileFilter
extends FileFilter {
    private static String TYPE_UNKNOWN = "Type Unknown";
    private static String HIDDEN_FILE = "Hidden File";
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;
    private LinkedList endings = new LinkedList();

    public EndingFileFilter() {
    }

    public EndingFileFilter(String extension) {
        this(extension, null);
    }

    public EndingFileFilter(String extension, String description) {
        this();
        if (extension != null) {
            this.addExtension(extension);
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public EndingFileFilter(String[] filters) {
        this(filters, null);
    }

    public EndingFileFilter(String[] filters, String description) {
        this();
        int i2 = 0;
        while (i2 < filters.length) {
            this.addExtension(filters[i2]);
            ++i2;
        }
        if (description != null) {
            this.setDescription(description);
        }
    }

    public boolean accept(File f2) {
        if (f2 != null) {
            if (f2.isDirectory()) {
                return true;
            }
            if (this.match(f2)) {
                return true;
            }
        }
        return false;
    }

    protected boolean match(File f2) {
        if (f2 != null) {
            String filename = f2.getName();
            Iterator i2 = this.endings.iterator();
            while (i2.hasNext()) {
                String end = (String)i2.next();
                if (!filename.endsWith(end)) continue;
                return true;
            }
        }
        return false;
    }

    public void addExtension(String extension) {
        this.endings.add(extension);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                this.fullDescription = this.description == null ? "(" : this.description + " (";
                Iterator i2 = this.endings.iterator();
                while (i2.hasNext()) {
                    this.fullDescription = this.fullDescription + (String)i2.next();
                    if (!i2.hasNext()) continue;
                    this.fullDescription = this.fullDescription + ", ";
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b2) {
        this.useExtensionsInDescription = b2;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

