/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFShape;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFont2
extends DefinitionTag
implements SWFConstants {
    private int character;
    private boolean shiftJIS = false;
    private boolean ansi = false;
    private boolean wideOffsets = false;
    private boolean wideCodes = false;
    private boolean italic = false;
    private boolean bold = false;
    private int languageCode;
    private String name;
    private long[] offsets;
    private long codeOffset;
    private SWFShape[] shapes;
    private int[] codes;
    private int ascent;
    private int descent;
    private int leading;
    private short[] advances;
    private Rectangle2D[] bounds;
    private KerningRecord[] kerning = new KerningRecord[0];

    public DefineFont2() {
        super(48, 3);
    }

    public DefineFont2(int character, boolean italic, boolean bold, String name, SWFShape[] shapes, int[] codes) {
        this(character, false, false, italic, bold, true, true, 1, name, shapes, codes, 0, 0, 0, null, null, null);
    }

    public DefineFont2(int character, boolean shiftJIS, boolean ansi, boolean italic, boolean bold, boolean wideOffsets, boolean wideCodes, int languageCode, String name, SWFShape[] shapes, int[] codes, int ascent, int descent, int leading, short[] advances, Rectangle2D[] bounds, KerningRecord[] kerning) {
        this();
        this.character = character;
        this.shiftJIS = shiftJIS;
        this.ansi = ansi;
        this.italic = italic;
        this.bold = bold;
        this.wideOffsets = wideOffsets;
        this.wideCodes = wideCodes;
        this.languageCode = languageCode;
        this.name = name;
        this.shapes = shapes;
        this.codes = codes;
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.advances = advances;
        this.bounds = bounds;
        this.kerning = kerning;
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineFont2 tag = new DefineFont2();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        boolean hasLayout = swf.readBitFlag();
        tag.shiftJIS = swf.readBitFlag();
        boolean reserved = swf.readBitFlag();
        tag.ansi = swf.readBitFlag();
        tag.wideOffsets = swf.readBitFlag();
        tag.wideCodes = swf.readBitFlag();
        tag.italic = swf.readBitFlag();
        tag.bold = swf.readBitFlag();
        tag.languageCode = swf.readLanguageCode();
        int nameLength = swf.readUnsignedByte();
        tag.name = swf.getVersion() >= 6 ? swf.readUTF() : new String(swf.readByte(nameLength));
        int glyphCount = swf.readUnsignedShort();
        tag.offsets = new long[glyphCount];
        int i2 = 0;
        while (i2 < glyphCount) {
            tag.offsets[i2] = tag.wideOffsets ? swf.readUnsignedInt() : (long)swf.readUnsignedShort();
            ++i2;
        }
        tag.codeOffset = tag.wideOffsets ? swf.readUnsignedInt() : (long)swf.readUnsignedShort();
        tag.shapes = new SWFShape[glyphCount];
        int i3 = 0;
        while (i3 < glyphCount) {
            tag.shapes[i3] = new SWFShape(swf);
            ++i3;
        }
        int[] nArray = tag.codes = tag.wideCodes ? swf.readUnsignedShort(glyphCount) : swf.readUnsignedByte(glyphCount);
        if (hasLayout) {
            tag.ascent = swf.readShort();
            tag.descent = swf.readShort();
            tag.leading = swf.readShort();
            tag.advances = swf.readShort(glyphCount);
            tag.bounds = new Rectangle2D[glyphCount];
            int i4 = 0;
            while (i4 < glyphCount) {
                tag.bounds[i4] = swf.readRect();
                ++i4;
            }
            int kerningCount = swf.readUnsignedShort();
            tag.kerning = new KerningRecord[kerningCount];
            int i5 = 0;
            while (i5 < kerningCount) {
                tag.kerning[i5] = new KerningRecord(swf, tag.wideCodes);
                ++i5;
            }
        }
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        int i2;
        boolean hasLayout = this.ascent != 0 || this.descent != 0 || this.leading != 0 || this.advances != null || this.bounds != null || this.kerning != null;
        swf.writeUnsignedShort(this.character);
        swf.writeBitFlag(hasLayout);
        swf.writeBitFlag(this.shiftJIS);
        swf.writeUBits(0L, 1);
        swf.writeBitFlag(this.ansi);
        swf.writeBitFlag(this.wideOffsets);
        swf.writeBitFlag(this.wideCodes);
        swf.writeBitFlag(this.italic);
        swf.writeBitFlag(this.bold);
        if (swf.getVersion() >= 6) {
            swf.writeLanguageCode(this.languageCode);
        } else {
            swf.writeUnsignedByte(0);
        }
        swf.writeUnsignedByte(this.name.length());
        if (swf.getVersion() >= 6) {
            swf.writeUTF(this.name);
        } else {
            swf.writeByte(this.name.getBytes());
        }
        swf.pushBuffer();
        int[] offsets = new int[this.shapes.length];
        int inc = this.wideOffsets ? 4 : 2;
        inc = (offsets.length + 1) * inc;
        int i3 = 0;
        while (i3 < this.shapes.length) {
            offsets[i3] = swf.getBufferLength() + inc;
            this.shapes[i3].write(swf);
            swf.byteAlign();
            ++i3;
        }
        this.codeOffset = swf.getBufferLength() + inc;
        swf.popBuffer();
        swf.writeUnsignedShort(offsets.length);
        int i4 = 0;
        while (i4 < offsets.length) {
            if (this.wideOffsets) {
                swf.writeUnsignedInt(offsets[i4]);
            } else {
                swf.writeUnsignedShort(offsets[i4]);
            }
            ++i4;
        }
        if (this.wideOffsets) {
            swf.writeUnsignedInt(this.codeOffset);
        } else {
            swf.writeUnsignedShort((int)this.codeOffset);
        }
        swf.append();
        if (this.wideCodes) {
            i2 = 0;
            while (i2 < offsets.length) {
                swf.writeUnsignedShort(this.codes[i2]);
                ++i2;
            }
        } else {
            i2 = 0;
            while (i2 < offsets.length) {
                swf.writeUnsignedByte(this.codes[i2]);
                ++i2;
            }
        }
        if (hasLayout) {
            swf.writeShort(this.ascent);
            swf.writeShort(this.descent);
            swf.writeShort(this.leading);
            i2 = 0;
            while (i2 < offsets.length) {
                swf.writeShort(this.advances[i2]);
                ++i2;
            }
            int i5 = 0;
            while (i5 < this.bounds.length) {
                swf.writeRect(this.bounds[i5]);
                ++i5;
            }
            swf.writeUnsignedShort(this.kerning.length);
            int i6 = 0;
            while (i6 < this.kerning.length) {
                this.kerning[i6].write(swf, this.wideCodes);
                ++i6;
            }
        }
    }

    public long getId() {
        return this.character;
    }

    public boolean getShiftJIS() {
        return this.shiftJIS;
    }

    public boolean isAnsi() {
        return this.ansi;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean hasWideOffsets() {
        return this.wideOffsets;
    }

    public boolean hasWideCodes() {
        return this.wideCodes;
    }

    public String getName() {
        return this.name;
    }

    public SWFShape[] getShapes() {
        return this.shapes;
    }

    public int[] getCodes() {
        return this.codes;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public short[] getAdvances() {
        return this.advances;
    }

    public Rectangle2D[] getBounds() {
        return this.bounds;
    }

    public KerningRecord[] getKerning() {
        return this.kerning;
    }

    public void setId(int id) {
        this.character = id;
    }

    public void setShiftJIS(boolean shiftJIS) {
        this.shiftJIS = shiftJIS;
    }

    public void setAnsi(boolean ansi) {
        this.ansi = ansi;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }

    public void setWideOffsets(boolean wideOffsets) {
        this.wideOffsets = wideOffsets;
    }

    public void setWideCodes(boolean wideCodes) {
        this.wideCodes = wideCodes;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCodes(int[] codes) {
        this.codes = codes;
    }

    public void setShapes(SWFShape[] shapes) {
        this.shapes = shapes;
    }

    public void setAscent(int ascent) {
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.descent = descent;
    }

    public void setLeading(int leading) {
        this.leading = leading;
    }

    public void setAdvances(short[] advances) {
        this.advances = advances;
    }

    public void setAdvances(int[] advances) {
        short[] s2 = new short[advances.length];
        int i2 = 0;
        while (i2 < s2.length) {
            s2[i2] = (short)advances[i2];
            ++i2;
        }
        this.setAdvances(s2);
    }

    public void setBounds(Rectangle2D[] bounds) {
        this.bounds = bounds;
    }

    public void setKerning(KerningRecord[] kerning) {
        this.kerning = kerning;
    }

    public String toString() {
        int i2;
        StringBuffer s2 = new StringBuffer();
        s2.append(super.toString() + "\n");
        s2.append("  character:  " + this.character + "\n");
        s2.append("  name: " + this.name + "\n");
        if (this.shiftJIS) {
            s2.append("  shiftJIS\n");
        }
        if (this.ansi) {
            s2.append("  ansi\n");
        }
        if (this.italic) {
            s2.append("  italic\n");
        }
        if (this.bold) {
            s2.append("  bold\n");
        }
        if (this.wideOffsets) {
            s2.append("  wideOffsets\n");
        }
        if (this.wideCodes) {
            s2.append("  wideCodes\n");
        }
        if (this.languageCode > 0) {
            s2.append("  languageCode: " + this.languageCode + "\n");
        }
        if (this.ascent != 0) {
            s2.append("  ascent: " + this.ascent + "\n");
        }
        if (this.descent != 0) {
            s2.append("  descent: " + this.descent + "\n");
        }
        if (this.leading != 0) {
            s2.append("  leading: " + this.leading + "\n");
        }
        if (this.advances != null) {
            i2 = 0;
            while (i2 < this.advances.length) {
                s2.append("  advances[" + i2 + "]: " + this.advances[i2] + "\n");
                ++i2;
            }
        }
        if (this.bounds != null) {
            i2 = 0;
            while (i2 < this.bounds.length) {
                s2.append("  bounds[" + i2 + "]: " + this.bounds[i2] + "\n");
                ++i2;
            }
        }
        s2.append("  glyphCount: " + this.shapes.length + "\n");
        i2 = 0;
        while (i2 < this.shapes.length) {
            s2.append("  >>> Shape " + i2 + "\n");
            s2.append(this.shapes[i2] + "\n");
            ++i2;
        }
        return s2.toString();
    }

    public static class KerningRecord {
        private int code1;
        private int code2;
        private int adjustment;

        public KerningRecord(int code1, int code2, int adjustment) {
            this.code1 = code1;
            this.code2 = code2;
            this.adjustment = adjustment;
        }

        public KerningRecord(SWFInputStream input, boolean wideCodes) throws IOException {
            this.code1 = wideCodes ? input.readUnsignedShort() : input.readUnsignedByte();
            this.code2 = wideCodes ? input.readUnsignedShort() : input.readUnsignedByte();
            this.adjustment = input.readShort();
        }

        public void write(SWFOutputStream swf, boolean wideCodes) throws IOException {
            if (wideCodes) {
                swf.writeUnsignedShort(this.code1);
            } else {
                swf.writeUnsignedByte(this.code1);
            }
            if (wideCodes) {
                swf.writeUnsignedShort(this.code2);
            } else {
                swf.writeUnsignedByte(this.code2);
            }
            swf.writeShort(this.adjustment);
        }

        public String toString() {
            return "Kerning[" + this.code1 + ", " + this.code2 + ", " + this.adjustment + "]";
        }
    }
}

