/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import org.freehep.graphicsio.font.truetype.TTFInput;

public class TTFMemoryInput
extends TTFInput {
    private byte[] data;
    private int pointer;

    public TTFMemoryInput(byte[] data) {
        this.data = data;
    }

    public void seek(long offset) {
        this.pointer = (int)offset;
    }

    long getPointer() {
        return this.pointer;
    }

    public byte readChar() {
        return this.data[this.pointer++];
    }

    public int readRawByte() {
        return this.data[this.pointer++] & 0xFF;
    }

    public int readByte() {
        return this.data[this.pointer++] & 0xFF;
    }

    public short readShort() {
        byte result = this.data[this.pointer++];
        return (short)(result << 8 | this.data[this.pointer++]);
    }

    public int readUShort() {
        return this.data[this.pointer++] << 8 | this.data[this.pointer++];
    }

    public int readLong() {
        byte result = this.data[this.pointer++];
        return (short)(result << 24 | this.data[this.pointer++] << 16 | this.data[this.pointer++] << 8 | this.data[this.pointer++]);
    }

    public long readULong() {
        byte[] temp = new byte[4];
        this.readFully(temp);
        long l2 = 0L;
        int i2 = 0;
        while (i2 < temp.length) {
            l2 |= (long)((temp[3 - i2] & 0xFF) << 8 * i2);
            ++i2;
        }
        return l2;
    }

    public void readFully(byte[] b2) {
        int i2 = 0;
        while (i2 < b2.length) {
            b2[i2] = this.data[this.pointer++];
            ++i2;
        }
    }
}

