/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import org.freehep.graphicsio.font.truetype.TTFInput;
import org.freehep.graphicsio.font.truetype.TTFLocaTable;
import org.freehep.graphicsio.font.truetype.TTFMaxPTable;
import org.freehep.graphicsio.font.truetype.TTFVersionTable;

public class TTFGlyfTable
extends TTFVersionTable {
    private static final boolean READ_GLYPHS = false;
    public Glyph[] glyphs;
    private long[] offsets;

    public String getTag() {
        return "glyf";
    }

    public void readTable() throws IOException {
        this.glyphs = new Glyph[((TTFMaxPTable)this.getTable((String)"maxp")).numGlyphs];
        this.offsets = ((TTFLocaTable)this.getTable((String)"loca")).offset;
    }

    public Glyph getGlyph(int i2) throws IOException {
        if (this.glyphs[i2] != null) {
            return this.glyphs[i2];
        }
        this.ttf.pushPos();
        this.ttf.seek(this.offsets[i2]);
        short numberOfContours = this.ttf.readShort();
        this.glyphs[i2] = numberOfContours >= 0 ? new SimpleGlyph(numberOfContours) : new CompositeGlyph();
        this.glyphs[i2].read();
        this.ttf.popPos();
        return this.glyphs[i2];
    }

    public String toString() {
        String str = super.toString();
        int i2 = 0;
        while (i2 < this.glyphs.length) {
            str = str + "\n  #" + i2 + ": " + this.glyphs[i2];
            ++i2;
        }
        return str;
    }

    public class CompositeGlyph
    extends Glyph {
        private static final int ARGS_WORDS = 0;
        private static final int ARGS_XY = 1;
        private static final int SCALE = 3;
        private static final int XY_SCALE = 6;
        private static final int TWO_BY_TWO = 7;
        private static final int MORE_COMPONENTS = 5;
        private GeneralPath shape;
        private int noComponents;

        public String getType() {
            return "Composite Glyph";
        }

        public GeneralPath getShape() {
            return this.shape;
        }

        public void read() throws IOException {
            super.read();
            this.shape = new GeneralPath();
            this.noComponents = 0;
            boolean more = true;
            while (more) {
                short arg2;
                short arg1;
                ++this.noComponents;
                TTFGlyfTable.this.ttf.readUShortFlags();
                more = TTFGlyfTable.this.ttf.flagBit(5);
                int glyphIndex = TTFGlyfTable.this.ttf.readUShort();
                if (TTFGlyfTable.this.ttf.flagBit(0)) {
                    arg1 = TTFGlyfTable.this.ttf.readShort();
                    arg2 = TTFGlyfTable.this.ttf.readShort();
                } else {
                    arg1 = TTFGlyfTable.this.ttf.readChar();
                    arg2 = TTFGlyfTable.this.ttf.readChar();
                }
                AffineTransform t2 = new AffineTransform();
                if (TTFGlyfTable.this.ttf.flagBit(1)) {
                    t2.translate(arg1, arg2);
                } else {
                    System.err.println("TTFGlyfTable: ARGS_ARE_POINTS not implemented.");
                }
                if (TTFGlyfTable.this.ttf.flagBit(3)) {
                    double scale = TTFGlyfTable.this.ttf.readF2Dot14();
                    t2.scale(scale, scale);
                } else if (TTFGlyfTable.this.ttf.flagBit(6)) {
                    double scaleX = TTFGlyfTable.this.ttf.readF2Dot14();
                    double scaleY = TTFGlyfTable.this.ttf.readF2Dot14();
                    t2.scale(scaleX, scaleY);
                } else if (TTFGlyfTable.this.ttf.flagBit(7)) {
                    System.err.println("TTFGlyfTable: WE_HAVE_A_TWO_BY_TWO not implemented.");
                }
                GeneralPath appendGlyph = (GeneralPath)TTFGlyfTable.this.getGlyph(glyphIndex).getShape().clone();
                appendGlyph.transform(t2);
                this.shape.append(appendGlyph, false);
            }
        }

        public String toString() {
            return super.toString() + ", " + this.noComponents + " components";
        }
    }

    public class SimpleGlyph
    extends Glyph {
        private static final int ON_CURVE = 0;
        private static final int X_SHORT = 1;
        private static final int Y_SHORT = 2;
        private static final int REPEAT_FLAG = 3;
        private static final int X_SAME = 4;
        private static final int Y_SAME = 5;
        private static final int X_POSITIVE = 4;
        private static final int Y_POSITIVE = 5;
        public int numberOfContours;
        public int[] endPtsOfContours;
        public int[] instructions;
        public int[] flags;
        public int[] xCoordinates;
        public int[] yCoordinates;
        public boolean[] onCurve;
        public GeneralPath shape;

        public SimpleGlyph(int numberOfContours) {
            this.numberOfContours = numberOfContours;
            this.endPtsOfContours = new int[numberOfContours];
        }

        public String getType() {
            return "Simple Glyph";
        }

        public void read() throws IOException {
            super.read();
            int i2 = 0;
            while (i2 < this.endPtsOfContours.length) {
                this.endPtsOfContours[i2] = TTFGlyfTable.this.ttf.readUShort();
                ++i2;
            }
            this.instructions = new int[TTFGlyfTable.this.ttf.readUShort()];
            int i3 = 0;
            while (i3 < this.instructions.length) {
                this.instructions[i3] = TTFGlyfTable.this.ttf.readByte();
                ++i3;
            }
            int numberOfPoints = this.endPtsOfContours[this.endPtsOfContours.length - 1] + 1;
            this.flags = new int[numberOfPoints];
            this.xCoordinates = new int[numberOfPoints];
            this.yCoordinates = new int[numberOfPoints];
            this.onCurve = new boolean[numberOfPoints];
            int repeatCount = 0;
            int repeatFlag = 0;
            int i4 = 0;
            while (i4 < numberOfPoints) {
                if (repeatCount > 0) {
                    this.flags[i4] = repeatFlag;
                    --repeatCount;
                } else {
                    this.flags[i4] = TTFGlyfTable.this.ttf.readRawByte();
                    if (TTFInput.flagBit(this.flags[i4], 3)) {
                        repeatCount = TTFGlyfTable.this.ttf.readByte();
                        repeatFlag = this.flags[i4];
                    }
                }
                TTFInput.checkZeroBit(this.flags[i4], 6, "flags");
                TTFInput.checkZeroBit(this.flags[i4], 7, "flags");
                this.onCurve[i4] = TTFInput.flagBit(this.flags[i4], 0);
                ++i4;
            }
            int last = 0;
            int i5 = 0;
            while (i5 < numberOfPoints) {
                last = TTFInput.flagBit(this.flags[i5], 1) ? (TTFInput.flagBit(this.flags[i5], 4) ? (this.xCoordinates[i5] = last + TTFGlyfTable.this.ttf.readByte()) : (this.xCoordinates[i5] = last - TTFGlyfTable.this.ttf.readByte())) : (TTFInput.flagBit(this.flags[i5], 4) ? (this.xCoordinates[i5] = last) : (this.xCoordinates[i5] = last + TTFGlyfTable.this.ttf.readShort()));
                ++i5;
            }
            last = 0;
            int i6 = 0;
            while (i6 < numberOfPoints) {
                last = TTFInput.flagBit(this.flags[i6], 2) ? (TTFInput.flagBit(this.flags[i6], 5) ? (this.yCoordinates[i6] = last + TTFGlyfTable.this.ttf.readByte()) : (this.yCoordinates[i6] = last - TTFGlyfTable.this.ttf.readByte())) : (TTFInput.flagBit(this.flags[i6], 5) ? (this.yCoordinates[i6] = last) : (this.yCoordinates[i6] = last + TTFGlyfTable.this.ttf.readShort()));
                ++i6;
            }
        }

        public String toString() {
            String str = super.toString() + ", " + this.numberOfContours + " contours, endPts={";
            int i2 = 0;
            while (i2 < this.numberOfContours) {
                str = str + (i2 == 0 ? "" : ",") + this.endPtsOfContours[i2];
                ++i2;
            }
            str = str + "}, " + this.instructions.length + " instructions";
            return str;
        }

        public String toDetailedString() {
            String str = this.toString() + "\n  instructions = {";
            int i2 = 0;
            while (i2 < this.instructions.length) {
                str = str + Integer.toHexString(this.instructions[i2]) + " ";
                ++i2;
            }
            return str + "}";
        }

        public GeneralPath getShape() {
            if (this.shape != null) {
                return this.shape;
            }
            this.shape = new GeneralPath(1);
            int p2 = 0;
            int x2 = 0;
            int y2 = 0;
            int i2 = 0;
            while (i2 < this.endPtsOfContours.length) {
                boolean first = true;
                while (p2 <= this.endPtsOfContours[i2]) {
                    x2 = this.xCoordinates[p2];
                    y2 = this.yCoordinates[p2];
                    if (first) {
                        this.shape.moveTo(x2, y2);
                        if (!this.onCurve[p2]) {
                            System.err.println("First point of contour not on curve!");
                        }
                    } else if (this.onCurve[p2]) {
                        this.shape.lineTo(x2, y2);
                    } else {
                        int pIndex = 0;
                        pIndex = p2 == this.endPtsOfContours[i2] ? (i2 > 0 ? this.endPtsOfContours[i2 - 1] + 1 : 0) : ++p2;
                        int x1 = this.xCoordinates[pIndex];
                        int y1 = this.yCoordinates[pIndex];
                        if (this.onCurve[p2]) {
                            this.shape.quadTo(x2, y2, x1, y1);
                        } else {
                            pIndex = p2 == this.endPtsOfContours[i2] ? (i2 > 0 ? this.endPtsOfContours[i2 - 1] + 1 : 0) : ++p2;
                            int x22 = this.xCoordinates[pIndex];
                            int y22 = this.yCoordinates[pIndex];
                            this.shape.curveTo(x2, y2, x1, y1, x22, y22);
                            if (!this.onCurve[p2]) {
                                System.err.println("Three points in a row not on curve!");
                            }
                        }
                    }
                    first = false;
                    ++p2;
                }
                this.shape.closePath();
                ++i2;
            }
            return this.shape;
        }
    }

    public abstract class Glyph {
        public int xMin;
        public int yMin;
        public int xMax;
        public int yMax;

        public abstract String getType();

        public abstract GeneralPath getShape();

        public void read() throws IOException {
            this.xMin = TTFGlyfTable.this.ttf.readFWord();
            this.yMin = TTFGlyfTable.this.ttf.readFWord();
            this.xMax = TTFGlyfTable.this.ttf.readFWord();
            this.yMax = TTFGlyfTable.this.ttf.readFWord();
        }

        public Rectangle getBBox() {
            return new Rectangle(this.xMin, this.yMin, this.xMax - this.xMin, this.yMax - this.yMin);
        }

        public String toString() {
            return "[" + this.getType() + "] (" + this.xMin + "," + this.yMin + "):(" + this.xMax + "," + this.yMax + ")";
        }

        public String toDetailedString() {
            return this.toString();
        }
    }
}

