/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.encoding;

import org.freehep.graphicsio.font.encoding.CharTable;
import org.freehep.graphicsio.font.encoding.Expert;
import org.freehep.graphicsio.font.encoding.ISOLatin;
import org.freehep.graphicsio.font.encoding.MACLatin;
import org.freehep.graphicsio.font.encoding.PDFLatin;
import org.freehep.graphicsio.font.encoding.STDLatin;
import org.freehep.graphicsio.font.encoding.Symbol;
import org.freehep.graphicsio.font.encoding.WINLatin;
import org.freehep.graphicsio.font.encoding.Zapfdingbats;

public class Lookup {
    private static Lookup instance;
    private CharTable[] tables = new CharTable[this.ntables];
    private int ntables = 8;

    public static Lookup getInstance() {
        if (instance == null) {
            instance = new Lookup();
        }
        return instance;
    }

    private Lookup() {
        this.tables[0] = new Symbol();
        this.tables[1] = new Expert();
        this.tables[2] = new Zapfdingbats();
        this.tables[3] = new STDLatin();
        this.tables[4] = new MACLatin();
        this.tables[5] = new WINLatin();
        this.tables[6] = new PDFLatin();
        this.tables[7] = new ISOLatin();
    }

    public char toUnicode(String name) {
        int i2 = 0;
        while (i2 < this.ntables) {
            char uc = this.tables[i2].toUnicode(name);
            if (uc != '\uffff') {
                return uc;
            }
            ++i2;
        }
        return '\uffff';
    }

    public String toName(char uc) {
        int i2 = 0;
        while (i2 < this.ntables) {
            String name = this.tables[i2].toName(uc);
            if (name != null) {
                return name;
            }
            ++i2;
        }
        return null;
    }

    public String toName(Character uc) {
        int i2 = 0;
        while (i2 < this.ntables) {
            String name = this.tables[i2].toName(uc);
            if (name != null) {
                return name;
            }
            ++i2;
        }
        return null;
    }

    public CharTable getTable(String tableName) {
        int i2 = 0;
        while (i2 < this.ntables) {
            String tblName = this.tables[i2].getEncoding() + this.tables[i2].getName();
            if (tblName.equalsIgnoreCase(tableName)) {
                return this.tables[i2];
            }
            ++i2;
        }
        return null;
    }

    public int getNumberOfTables() {
        return this.ntables;
    }

    public String[] getTableNames() {
        String[] tblnames = new String[this.ntables];
        int i2 = 0;
        while (i2 < this.ntables) {
            tblnames[i2] = this.tables[i2].getEncoding() + this.tables[i2].getName();
            ++i2;
        }
        return tblnames;
    }
}

