/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;

public class PolyPolyline16
extends EMFTag {
    private Rectangle bounds;
    private int numberOfPolys;
    private int[] numberOfPoints;
    private Point[][] points;

    PolyPolyline16() {
        super(90, 1);
    }

    public PolyPolyline16(Rectangle bounds, int numberOfPolys, int[] numberOfPoints, Point[][] points) {
        this();
        this.bounds = bounds;
        this.numberOfPolys = numberOfPolys;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        Rectangle bounds = emf.readRECTL();
        int np = emf.readDWORD();
        int totalNumberOfPoints = emf.readDWORD();
        int[] pc = new int[np];
        Point[][] points = new Point[np][];
        int i2 = 0;
        while (i2 < np) {
            pc[i2] = emf.readDWORD();
            points[i2] = new Point[pc[i2]];
            ++i2;
        }
        int i3 = 0;
        while (i3 < np) {
            points[i3] = emf.readPOINTS(pc[i3]);
            ++i3;
        }
        PolyPolyline16 tag = new PolyPolyline16(bounds, np, pc, points);
        return tag;
    }

    public void write(int tagID, EMFOutputStream emf) throws IOException {
        emf.writeRECTL(this.bounds);
        emf.writeDWORD(this.numberOfPolys);
        int c2 = 0;
        int i2 = 0;
        while (i2 < this.numberOfPolys) {
            c2 += this.numberOfPoints[i2];
            ++i2;
        }
        emf.writeDWORD(c2);
        int i3 = 0;
        while (i3 < this.numberOfPolys) {
            emf.writeDWORD(this.numberOfPoints[i3]);
            ++i3;
        }
        int i4 = 0;
        while (i4 < this.numberOfPolys) {
            emf.writePOINTS(this.numberOfPoints[i4], this.points[i4]);
            ++i4;
        }
    }

    public String toString() {
        return super.toString() + "\n" + "  bounds: " + this.bounds + "\n" + "  #polys: " + this.numberOfPolys;
    }
}

