/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.OutputStream;
import org.freehep.graphicsio.cgm.CGMTagSet;
import org.freehep.util.io.ActionHeader;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TagHeader;
import org.freehep.util.io.TaggedOutputStream;

public class CGMOutputStream
extends TaggedOutputStream {
    private int version;
    private boolean direct = true;
    private int colorIndexPrecision = 8;
    private int directColorPrecision = 8;
    private int indexPrecision = 16;
    private int integerPrecision = 16;
    private boolean fixedPrecision = true;
    private boolean doublePrecision = false;
    private boolean vdcReal = false;
    private boolean vdcFixedPrecision = true;
    private boolean vdcDoublePrecision = false;
    private int vdcIntegerPrecision = 16;
    private int namePrecision = 16;
    private int lineWidthSpecificationMode = 0;
    private int markerSizeSpecificationMode = 0;
    private int edgeWidthSpecificationMode = 0;
    private int interiorStyleSpecificationMode = 0;

    public CGMOutputStream(OutputStream os, int version) throws IOException {
        super(os, new CGMTagSet(version), null, false);
        this.version = version;
    }

    public CGMOutputStream(OutputStream os) throws IOException {
        this(os, 1);
    }

    void setColorMode(boolean direct) {
        this.direct = direct;
    }

    void setColorIndexPrecision(int precision) {
        this.colorIndexPrecision = precision;
    }

    void setDirectColorPrecision(int precision) {
        this.directColorPrecision = precision;
    }

    void setIndexPrecision(int precision) {
        this.indexPrecision = precision;
    }

    void setIntegerPrecision(int precision) {
        this.integerPrecision = precision;
    }

    void setRealPrecision(boolean fixedPrecision, boolean doublePrecision) {
        this.fixedPrecision = fixedPrecision;
        this.doublePrecision = doublePrecision;
    }

    void setVDCReal(boolean real) {
        this.vdcReal = real;
    }

    void setVDCIntegerPrecision(int precision) {
        this.vdcIntegerPrecision = precision;
    }

    void setVDCRealPrecision(boolean fixedPrecision, boolean doublePrecision) {
        this.vdcFixedPrecision = fixedPrecision;
        this.vdcDoublePrecision = doublePrecision;
    }

    void setNamePrecision(int precision) {
        this.namePrecision = precision;
    }

    void setLineWidthSpecificationMode(int mode) {
        this.lineWidthSpecificationMode = mode;
    }

    int getLineWidthSpecificationMode() {
        return this.lineWidthSpecificationMode;
    }

    void setMarkerSizeSpecificationMode(int mode) {
        this.markerSizeSpecificationMode = mode;
    }

    int getMarkerSizeSpecificationMode() {
        return this.markerSizeSpecificationMode;
    }

    void setEdgeWidthSpecificationMode(int mode) {
        this.edgeWidthSpecificationMode = mode;
    }

    int getEdgeWidthSpecificationMode() {
        return this.edgeWidthSpecificationMode;
    }

    void setInteriorStyleSpecificationMode(int mode) {
        this.interiorStyleSpecificationMode = mode;
    }

    int getInteriorStyleSpecificationMode() {
        return this.interiorStyleSpecificationMode;
    }

    public void writeFixedPoint(double d2) throws IOException {
        int whole = (int)Math.floor(d2);
        int frac = (int)Math.floor((d2 - (double)whole) * 65536.0);
        this.writeShort(whole);
        this.writeShort(frac);
    }

    public void writeFloatingPoint(double d2) throws IOException {
        if (this.doublePrecision) {
            this.writeDouble(d2);
        } else {
            this.writeFloat((float)d2);
        }
    }

    public void writeColorIndex(int i2) throws IOException {
        switch (this.colorIndexPrecision) {
            case 8: {
                this.writeByte(i2);
                break;
            }
            case 16: {
                this.writeShort(i2);
                break;
            }
            default: {
                this.writeInt(i2);
            }
        }
    }

    public void writeColorComponent(int c2) throws IOException {
        switch (this.directColorPrecision) {
            default: 
        }
        this.writeUnsignedByte(c2);
    }

    public void writeColorDirect(Color c2) throws IOException {
        this.writeColorComponent(c2.getRed());
        this.writeColorComponent(c2.getGreen());
        this.writeColorComponent(c2.getBlue());
        this.writeColorComponent(0);
    }

    public void writeIntegerIndex(int i2) throws IOException {
        switch (this.indexPrecision) {
            case 8: {
                this.writeByte(i2);
                break;
            }
            default: {
                this.writeShort(i2);
                break;
            }
            case 24: 
            case 32: {
                this.writeInt(i2);
            }
        }
    }

    public void writeEnumerate(int i2) throws IOException {
        this.writeShort(i2);
    }

    public void writeInteger(int i2) throws IOException {
        switch (this.integerPrecision) {
            case 8: {
                this.writeByte(i2);
                break;
            }
            default: {
                this.writeShort(i2);
                break;
            }
            case 24: 
            case 32: {
                this.writeInt(i2);
            }
        }
    }

    public void writeReal(double r2) throws IOException {
        if (this.fixedPrecision) {
            this.writeFixedPoint(r2);
        } else {
            this.writeFloatingPoint(r2);
        }
    }

    public void writeString(String s2) throws IOException {
        int len = s2.length();
        if (len < 255) {
            this.writeUnsignedByte(len);
        } else {
            this.writeUnsignedByte(255);
            this.writeUnsignedShort(len & Short.MAX_VALUE);
        }
        this.writeBytes(s2);
    }

    public void writeData(byte[] data) throws IOException {
        this.writeString(new String(data));
    }

    public void writeVDC(double d2) throws IOException {
        if (this.vdcReal) {
            if (this.vdcFixedPrecision) {
                this.writeFixedPoint(d2);
            } else if (this.vdcDoublePrecision) {
                this.writeDouble(d2);
            } else {
                this.writeFloat((float)d2);
            }
        } else {
            switch (this.vdcIntegerPrecision) {
                default: {
                    this.writeShort((int)d2);
                    break;
                }
                case 24: 
                case 32: {
                    this.writeInt((int)d2);
                }
            }
        }
    }

    public void writePoint(Point2D p2) throws IOException {
        this.writeVDC(p2.getX());
        this.writeVDC(p2.getY());
    }

    public void writeColor(Color c2) throws IOException {
        if (this.direct) {
            this.writeColorDirect(c2);
        } else {
            this.writeColorIndex((c2.getRed() << 16) + (c2.getGreen() << 8) + c2.getBlue());
        }
    }

    public void writeName(int name) throws IOException {
        switch (this.namePrecision) {
            case 8: {
                this.writeByte(name);
                break;
            }
            default: {
                this.writeShort(name);
                break;
            }
            case 24: 
            case 32: {
                this.writeInt(name);
            }
        }
    }

    protected void writeTagHeader(TagHeader header) throws IOException {
        this.byteAlign();
        int tagID = header.getTag();
        long length = header.getLength();
        if (length < 31L) {
            this.writeUnsignedShort((tagID << 5) + (int)length);
        } else {
            this.writeUnsignedShort((tagID << 5) + 31);
            this.writeUnsignedShort((int)(length & 0x7FFFL));
        }
    }

    public void writeTag(Tag tag) throws IOException {
        super.writeTag(tag);
        if (this.size() % 2 != 0) {
            this.writeUnsignedByte(0);
        }
    }

    protected void writeActionHeader(ActionHeader header) throws IOException {
    }

    public int getVersion() {
        return this.version;
    }
}

