/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SymbolShape
implements Shape {
    private static final double SQRT_2 = Math.sqrt(2.0);
    private static final double SQRT_3 = Math.sqrt(3.0);
    private double[] points;
    private int[] type;
    private int numberOfPoints;
    private ArrayPathIterator pathIterator;
    private Rectangle2D.Double bounds;

    public SymbolShape() {
        this.ensureNumberOfPoints(10);
        this.type[0] = 0;
        this.bounds = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        int i2 = 1;
        while (i2 < this.type.length) {
            this.type[i2] = 1;
            ++i2;
        }
        this.pathIterator = new ArrayPathIterator(this.points, this.type);
    }

    public boolean contains(double x2, double y2) {
        return this.bounds.contains(x2, y2);
    }

    public boolean contains(double x2, double y2, double w2, double h2) {
        return this.contains(x2, y2) && this.contains(x2 + w2, y2) && this.contains(x2, y2 + h2) && this.contains(x2 + w2, y2 + h2);
    }

    public boolean contains(Point2D p2) {
        return this.contains(p2.getX(), p2.getY());
    }

    public boolean contains(Rectangle2D r2) {
        return this.contains(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public boolean intersects(double x2, double y2, double w2, double h2) {
        return this.contains(x2, y2) || this.contains(x2 + w2, y2) || this.contains(x2, y2 + h2) || this.contains(x2 + w2, y2 + h2);
    }

    public boolean intersects(Rectangle2D r2) {
        return this.intersects(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public Rectangle2D getBounds2D() {
        return this.bounds;
    }

    public Rectangle getBounds() {
        Rectangle2D bounds = this.getBounds2D();
        return new Rectangle((int)Math.floor(bounds.getX()), (int)Math.floor(bounds.getY()), (int)Math.ceil(bounds.getWidth()), (int)Math.ceil(bounds.getHeight()));
    }

    public PathIterator getPathIterator(AffineTransform t2) {
        if (t2 != null) {
            t2.transform(this.points, 0, this.pathIterator.points, 0, this.points.length / 2);
        }
        this.pathIterator.reset();
        return this.pathIterator;
    }

    private void createNew(int n2) {
        if (!this.pathIterator.isDone()) {
            System.err.println("SymbolShape: concurrent modification!");
        }
        this.ensureNumberOfPoints(n2);
        this.numberOfPoints = n2;
        this.pathIterator.numberOfPoints = this.numberOfPoints;
        this.pathIterator.done();
    }

    public void create(int type, double x2, double y2, double size) {
        switch (type) {
            case 0: {
                this.createHLine(x2, y2, size);
                break;
            }
            case 1: {
                this.createVLine(x2, y2, size);
                break;
            }
            case 2: {
                this.createPlus(x2, y2, size);
                break;
            }
            case 3: {
                this.createCross(x2, y2, size);
                break;
            }
            case 4: {
                this.createStar(x2, y2, size);
                break;
            }
            case 6: {
                this.createBox(x2, y2, size);
                break;
            }
            case 7: {
                this.createUpTriangle(x2, y2, size);
                break;
            }
            case 8: {
                this.createDownTriangle(x2, y2, size);
                break;
            }
            case 9: {
                this.createDiamond(x2, y2, size);
            }
        }
        this.setBounds(x2, y2, size);
    }

    public void createHLine(double x2, double y2, double size) {
        this.createNew(2);
        this.type[0] = 0;
        this.points[0] = x2 - size / 2.0;
        this.points[1] = y2;
        this.type[1] = 1;
        this.points[2] = x2 + size / 2.0;
        this.points[3] = y2;
    }

    public void createVLine(double x2, double y2, double size) {
        this.ensureNumberOfPoints(2);
        this.numberOfPoints = 2;
        this.pathIterator.numberOfPoints = 2;
        this.type[0] = 0;
        this.points[0] = x2;
        this.points[1] = y2 - size / 2.0;
        this.type[1] = 1;
        this.points[2] = x2;
        this.points[3] = y2 + size / 2.0;
    }

    public void createPlus(double x2, double y2, double size) {
        this.ensureNumberOfPoints(4);
        this.numberOfPoints = 4;
        this.pathIterator.numberOfPoints = 4;
        double length = size / 2.0;
        this.type[0] = 0;
        this.points[0] = x2 + length;
        this.points[1] = y2;
        this.type[1] = 1;
        this.points[2] = x2 - length;
        this.points[3] = y2;
        this.type[2] = 0;
        this.points[4] = x2;
        this.points[5] = y2 + length;
        this.type[3] = 1;
        this.points[6] = x2;
        this.points[7] = y2 - length;
    }

    public void createCross(double x2, double y2, double size) {
        this.ensureNumberOfPoints(4);
        this.numberOfPoints = 4;
        this.pathIterator.numberOfPoints = 4;
        double side = size / 2.0 / SQRT_2;
        this.type[0] = 0;
        this.points[0] = x2 - side;
        this.points[1] = y2 - side;
        this.type[1] = 1;
        this.points[2] = x2 + side;
        this.points[3] = y2 + side;
        this.type[2] = 0;
        this.points[4] = x2 + side;
        this.points[5] = y2 - side;
        this.type[3] = 1;
        this.points[6] = x2 - side;
        this.points[7] = y2 + side;
    }

    public void createStar(double x2, double y2, double size) {
        this.ensureNumberOfPoints(8);
        this.numberOfPoints = 8;
        this.pathIterator.numberOfPoints = 8;
        double delta = size / 2.0;
        this.type[0] = 0;
        this.points[0] = x2;
        this.points[1] = y2 - delta;
        this.type[1] = 1;
        this.points[2] = x2;
        this.points[3] = y2 + delta;
        this.type[2] = 0;
        this.points[4] = x2 - delta;
        this.points[5] = y2;
        this.type[3] = 1;
        this.points[6] = x2 + delta;
        this.points[7] = y2;
        delta = size / 2.0 / SQRT_2;
        this.type[4] = 0;
        this.points[8] = x2 - delta;
        this.points[9] = y2 - delta;
        this.type[5] = 1;
        this.points[10] = x2 + delta;
        this.points[11] = y2 + delta;
        this.type[6] = 0;
        this.points[12] = x2 + delta;
        this.points[13] = y2 - delta;
        this.type[7] = 1;
        this.points[14] = x2 - delta;
        this.points[15] = y2 + delta;
    }

    public void createUpTriangle(double x2, double y2, double size) {
        this.ensureNumberOfPoints(4);
        this.numberOfPoints = 4;
        this.pathIterator.numberOfPoints = 4;
        this.type[0] = 0;
        this.points[0] = x2;
        this.points[1] = y2 - size / SQRT_3;
        this.type[1] = 1;
        this.points[2] = x2 - size / 2.0;
        this.points[3] = y2 + (-size / SQRT_3 + size * SQRT_3 / 2.0);
        this.type[2] = 1;
        this.points[4] = x2 + size / 2.0;
        this.points[5] = y2 + (-size / SQRT_3 + size * SQRT_3 / 2.0);
        this.type[3] = 4;
    }

    public void createDownTriangle(double x2, double y2, double size) {
        this.ensureNumberOfPoints(4);
        this.numberOfPoints = 4;
        this.pathIterator.numberOfPoints = 4;
        this.type[0] = 0;
        this.points[0] = x2;
        this.points[1] = y2 + size / SQRT_3;
        this.type[1] = 1;
        this.points[2] = x2 - size / 2.0;
        this.points[3] = y2 - (-size / SQRT_3 + size * SQRT_3 / 2.0);
        this.type[2] = 1;
        this.points[4] = x2 + size / 2.0;
        this.points[5] = y2 - (-size / SQRT_3 + size * SQRT_3 / 2.0);
        this.type[3] = 4;
    }

    public void createDiamond(double x2, double y2, double size) {
        this.ensureNumberOfPoints(5);
        this.numberOfPoints = 5;
        this.pathIterator.numberOfPoints = 5;
        double length = size / 2.0;
        this.type[0] = 0;
        this.points[0] = x2 + length;
        this.points[1] = y2;
        this.type[1] = 1;
        this.points[2] = x2;
        this.points[3] = y2 + length;
        this.type[2] = 1;
        this.points[4] = x2 - length;
        this.points[5] = y2;
        this.type[3] = 1;
        this.points[6] = x2;
        this.points[7] = y2 - length;
        this.type[4] = 4;
    }

    public void createBox(double x2, double y2, double size) {
        this.ensureNumberOfPoints(5);
        this.numberOfPoints = 5;
        this.pathIterator.numberOfPoints = 5;
        double side = size / SQRT_2 / 2.0;
        this.type[0] = 0;
        this.points[0] = x2 - side;
        this.points[1] = y2 - side;
        this.type[1] = 1;
        this.points[2] = x2 + side;
        this.points[3] = y2 - side;
        this.type[2] = 1;
        this.points[4] = x2 + side;
        this.points[5] = y2 + side;
        this.type[3] = 1;
        this.points[6] = x2 - side;
        this.points[7] = y2 + side;
        this.type[4] = 4;
    }

    private void setBounds(double x2, double y2, double size) {
        this.bounds.x = x2 - size / 2.0;
        this.bounds.y = y2 - size / 2.0;
        this.bounds.width = this.bounds.height = size;
    }

    private void ensureNumberOfPoints(int n2) {
        if (this.type == null || this.type.length < n2) {
            this.points = new double[n2 * 2];
            this.type = new int[n2];
        }
    }

    private class ArrayPathIterator
    implements PathIterator {
        private int currentPoint = 0;
        private double[] points;
        private int[] type;
        private int numberOfPoints;

        private ArrayPathIterator(double[] points, int[] type) {
            this.points = points;
            this.type = type;
        }

        public boolean isDone() {
            return this.currentPoint >= this.numberOfPoints;
        }

        public void next() {
            ++this.currentPoint;
        }

        public int currentSegment(double[] coords) {
            coords[0] = this.points[2 * this.currentPoint];
            coords[1] = this.points[2 * this.currentPoint + 1];
            return this.type[this.currentPoint];
        }

        public int currentSegment(float[] coords) {
            coords[0] = (float)this.points[2 * this.currentPoint];
            coords[1] = (float)this.points[2 * this.currentPoint + 1];
            return this.type[this.currentPoint];
        }

        public int getWindingRule() {
            return 1;
        }

        private void reset() {
            this.currentPoint = 0;
        }

        private void done() {
            this.currentPoint = this.numberOfPoints;
        }
    }
}

