/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.mdi;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.freehep.application.Application;
import org.freehep.application.HasPopupItems;
import org.freehep.application.mdi.ManagedPage;
import org.freehep.application.mdi.PageContext;
import org.freehep.application.mdi.PageManager;
import org.freehep.util.commanddispatcher.CommandProcessor;
import org.freehep.util.commanddispatcher.CommandSourceAdapter;
import org.freehep.util.commanddispatcher.CommandState;
import org.freehep.util.commanddispatcher.CommandTargetManager;

public class InternalFramePageManager
extends PageManager {
    private int m_nCascaded = 0;
    private boolean init = false;
    private final int m_xCascadeOffset = 20;
    private final int m_yCascadeOffset = 20;
    private final float m_xCascadeFraction = 0.75f;
    private final float m_yCascadeFraction = 0.75f;
    public static final int CASCADE = -3;
    public static final int TILE_HORIZONTALLY = -4;
    public static final int TILE_VERTICALLY = -5;
    private Map map = new HashMap();
    private JDesktopPane top = new MDIDesktopPane();

    protected void show(PageContext page) {
        this.top.setSelectedFrame(this.frameForPage(page));
    }

    protected Component getEmbodiment() {
        return this.top;
    }

    protected boolean close(PageContext page) {
        boolean ok = super.close(page);
        if (ok) {
            ((JInternalFrame)this.map.remove(page)).dispose();
        }
        return ok;
    }

    protected void titleChanged(PageContext page) {
        this.frameForPage(page).setTitle(page.getTitle());
    }

    protected void iconChanged(PageContext page) {
        this.frameForPage(page).setFrameIcon(page.getIcon());
    }

    private JInternalFrame frameForPage(PageContext page) {
        return (JInternalFrame)this.map.get(page);
    }

    public PageContext openPage(Component c2, String title, Icon icon) {
        PageContext context = super.openPage(c2, title, icon);
        FrameWithContext frame = new FrameWithContext(context);
        this.map.put(context, frame);
        this.top.add(frame);
        if (this.init) {
            this.cascadeFrame(frame);
        }
        frame.show();
        super.firePageOpened(context);
        return context;
    }

    protected void init(List pages, PageContext selected) {
        Iterator i2 = pages.iterator();
        while (i2.hasNext()) {
            PageContext context = (PageContext)i2.next();
            FrameWithContext frame = new FrameWithContext(context);
            this.map.put(context, frame);
            this.top.add(frame);
            frame.show();
        }
        if (selected != null) {
            try {
                this.frameForPage(selected).setSelected(true);
            }
            catch (PropertyVetoException x2) {
                // empty catch block
            }
        }
        super.init(pages, selected);
    }

    private void cascadeFrame(JInternalFrame frame) {
        Dimension paneSize = this.top.getSize();
        Dimension frameSize = new Dimension();
        frameSize.height = (int)((float)paneSize.height * 0.75f);
        frameSize.width = (int)((float)paneSize.width * 0.75f);
        Point position = new Point();
        position.translate(this.m_nCascaded * 20, this.m_nCascaded * 20);
        frame.setLocation(position);
        frame.setPreferredSize(frameSize);
        frame.setSize(frameSize);
        ++this.m_nCascaded;
    }

    void arrange(int index) {
        this.m_nCascaded = 0;
        JInternalFrame[] frames = this.top.getAllFrames();
        if (index == -3) {
            int i2 = frames.length - 1;
            while (i2 >= 0) {
                JInternalFrame frame = frames[i2];
                if (!frame.isIcon()) {
                    try {
                        frames[i2].setMaximum(false);
                        this.cascadeFrame(frame);
                    }
                    catch (PropertyVetoException x2) {
                        // empty catch block
                    }
                }
                --i2;
            }
        } else {
            int numberOfWindows;
            int nLeft = numberOfWindows = this.getPageCount();
            int i3 = 0;
            while (i3 < numberOfWindows) {
                if (frames[i3].isIcon()) {
                    --nLeft;
                } else {
                    try {
                        frames[i3].setMaximum(false);
                    }
                    catch (PropertyVetoException x3) {
                        --nLeft;
                    }
                }
                ++i3;
            }
            int n2 = (int)Math.sqrt(nLeft);
            if (n2 < 1) {
                return;
            }
            int paneWidth = this.top.getSize().width;
            int paneHeight = this.top.getSize().height;
            boolean isHorizontal = index == -4;
            int xTranslation_1 = isHorizontal ? paneWidth / n2 : 0;
            int yTranslation_1 = isHorizontal ? 0 : paneHeight / n2;
            int k2 = 0;
            Dimension size = new Dimension();
            Point point = new Point();
            int xTranslation_2 = 0;
            int yTranslation_2 = 0;
            if (isHorizontal) {
                size.width = paneWidth / n2;
            } else {
                size.height = paneHeight / n2;
            }
            int i4 = 0;
            while (i4 < n2) {
                point.setLocation(0, 0);
                point.translate(i4 * xTranslation_1, i4 * yTranslation_1);
                int nThis = nLeft / (n2 - i4);
                nLeft -= nThis;
                if (isHorizontal) {
                    yTranslation_2 = size.height = paneHeight / nThis;
                } else {
                    xTranslation_2 = size.width = paneWidth / nThis;
                }
                int j2 = 0;
                while (true) {
                    JInternalFrame frame;
                    if ((frame = frames[k2++]).isIcon() || frame.isMaximum()) {
                        continue;
                    }
                    frame.setSize(new Dimension(size));
                    frame.setLocation(new Point(point));
                    if (++j2 >= nThis) break;
                    point.translate(xTranslation_2, yTranslation_2);
                }
                ++i4;
            }
        }
    }

    protected CommandProcessor createCommandProcessor() {
        return new InternalFrameCommandProcessor();
    }

    public class InternalFrameCommandProcessor
    extends PageManager.PageManagerCommandProcessor {
        public void onCascade() {
            InternalFramePageManager.this.arrange(-3);
        }

        public void onTileHorizontally() {
            InternalFramePageManager.this.arrange(-4);
        }

        public void onTileVertically() {
            InternalFramePageManager.this.arrange(-5);
        }

        private boolean hasOpenPages() {
            JInternalFrame[] frames = InternalFramePageManager.this.top.getAllFrames();
            int i2 = 0;
            while (i2 < frames.length) {
                if (!frames[i2].isIcon()) {
                    return true;
                }
                ++i2;
            }
            return false;
        }

        public void enableCascade(CommandState state) {
            state.setEnabled(this.hasOpenPages());
        }

        public void enableTileVertically(CommandState state) {
            state.setEnabled(this.hasOpenPages());
        }

        public void enableTileHorizontally(CommandState state) {
            state.setEnabled(this.hasOpenPages());
        }
    }

    private class FrameWithContext
    extends JInternalFrame {
        private PageContext context;

        FrameWithContext(PageContext context) {
            super(context.getTitle(), true, true, true, true);
            this.context = context;
            this.setFrameIcon(context.getIcon());
            this.setDefaultCloseOperation(0);
            Component c2 = context.getPage();
            if (c2 instanceof Container) {
                this.setContentPane((Container)c2);
            } else {
                this.getContentPane().add(c2);
            }
        }

        protected void fireInternalFrameEvent(int id) {
            switch (id) {
                case 25552: {
                    ManagedPage mp = InternalFramePageManager.this.getManagedPage(this.context.getPage());
                    if (mp != null) {
                        mp.pageIconized();
                    }
                    InternalFramePageManager.this.firePageEvent(this.context, 4002);
                    InternalFramePageManager.this.getCommandProcessor().setChanged();
                    break;
                }
                case 25553: {
                    ManagedPage mp = InternalFramePageManager.this.getManagedPage(this.context.getPage());
                    if (mp != null) {
                        mp.pageDeiconized();
                    }
                    InternalFramePageManager.this.firePageEvent(this.context, 4003);
                    InternalFramePageManager.this.getCommandProcessor().setChanged();
                    break;
                }
                case 25550: {
                    InternalFramePageManager.this.close(this.context);
                    break;
                }
                case 25554: {
                    InternalFramePageManager.this.fireSelectionChanged(this.context);
                }
            }
            super.fireInternalFrameEvent(id);
        }
    }

    protected class MDIDesktopPane
    extends JDesktopPane
    implements HasPopupItems {
        protected MDIDesktopPane() {
        }

        public void doLayout() {
            super.doLayout();
            if (!InternalFramePageManager.this.init) {
                InternalFramePageManager.this.arrange(-3);
                InternalFramePageManager.this.init = true;
            }
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p2) {
            if (source == this) {
                CommandTargetManager cm = Application.getApplication().getCommandTargetManager();
                JMenuItem cascade = new JMenuItem("Cascade");
                cascade.setMnemonic('C');
                cascade.setActionCommand("cascade");
                cm.add(new CommandSourceAdapter(cascade));
                menu.add(cascade);
                JMenuItem tileV = new JMenuItem("Tile Vertically");
                tileV.setMnemonic('V');
                tileV.setActionCommand("tileVertically");
                cm.add(new CommandSourceAdapter(tileV));
                menu.add(tileV);
                JMenuItem tileH = new JMenuItem("Tile Horizontally");
                tileH.setMnemonic('H');
                tileH.setActionCommand("tileHorizontally");
                cm.add(new CommandSourceAdapter(tileH));
                menu.add(tileH);
                JMenuItem close = new JMenuItem("Close All");
                close.setMnemonic('A');
                close.setActionCommand("closeAllPages");
                cm.add(new CommandSourceAdapter(close));
                menu.add(close);
            } else {
                CommandTargetManager cm = Application.getApplication().getCommandTargetManager();
                JMenuItem close = new JMenuItem("Close Window");
                close.setMnemonic('C');
                close.setActionCommand("closePage");
                cm.add(new CommandSourceAdapter(close));
                menu.add(close);
            }
            return menu;
        }
    }
}

