/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Properties;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.freehep.application.PrintDialog;
import org.freehep.application.PrintPreview;
import org.freehep.application.PropertyUtilities;
import org.freehep.application.studio.Studio;

public class PrintHelper
implements Printable {
    private static final String rootName = (class$org$freehep$application$PrintHelper == null ? (class$org$freehep$application$PrintHelper = PrintHelper.class$("org.freehep.application.PrintHelper")) : class$org$freehep$application$PrintHelper).getName() + ".";
    public static final int ORIENTATION_BEST_FIT = 0;
    public static final int ORIENTATION_PORTRAIT = 1;
    public static final int ORIENTATION_LANDSCAPE = 2;
    private Component target;
    private Font headerFooterFont = new Font("SansSerif", 0, 10);
    private PrintRequestAttributeSet atts = new HashPrintRequestAttributeSet();
    private PrinterJob pj;
    private String footer;
    private String header;
    private Studio app;
    private boolean drawBorder;
    private boolean scaleUp;
    private boolean showFooter;
    private boolean showHeader;
    private int orientation;
    static /* synthetic */ Class class$org$freehep$application$PrintHelper;
    static /* synthetic */ Class class$javax$print$attribute$standard$Media;
    static /* synthetic */ Class class$javax$print$attribute$standard$MediaPrintableArea;
    static /* synthetic */ Class class$javax$print$attribute$standard$JobName;

    public PrintHelper(Component target, Studio app) {
        this.target = target;
        this.app = app;
        Properties user = app.getUserProperties();
        this.drawBorder = PropertyUtilities.getBoolean(user, rootName + "drawBorder", false);
        this.scaleUp = PropertyUtilities.getBoolean(user, rootName + "scaleUp", false);
        this.showHeader = PropertyUtilities.getBoolean(user, rootName + "showHeader", true);
        this.showFooter = PropertyUtilities.getBoolean(user, rootName + "showFooter", false);
        this.footer = PropertyUtilities.getString(user, rootName + "footer", null);
        this.header = PropertyUtilities.getString(user, rootName + "header", "JAS3&b&d");
        this.orientation = PropertyUtilities.getInteger(user, rootName + "orientation", 0);
        this.pj = PrinterJob.getPrinterJob();
        this.pj.setPrintable(this);
        String defaultPrinter = user.getProperty(rootName + "defaultPrinter");
        PrintService ps = this.pj.getPrintService();
        if (defaultPrinter != null && !ps.getName().equals(defaultPrinter)) {
            PrintService[] services = PrinterJob.lookupPrintServices();
            int i2 = 0;
            while (i2 < services.length) {
                if (services[i2].getName().equals(defaultPrinter)) {
                    try {
                        this.pj.setPrintService(services[i2]);
                        ps = services[i2];
                        break;
                    }
                    catch (PrinterException x2) {
                        x2.printStackTrace();
                    }
                }
                ++i2;
            }
        }
        this.atts.add(new JobName(user.getProperty(rootName + "printJobName", "JAS3 Plots"), null));
        Media media = (Media)ps.getDefaultAttributeValue(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PrintHelper.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        float x3 = PropertyUtilities.getFloat(user, rootName + "printArea.top", 0.0f);
        float y2 = PropertyUtilities.getFloat(user, rootName + "printArea.left", 0.0f);
        float w2 = PropertyUtilities.getFloat(user, rootName + "printArea.right", 0.0f);
        float h2 = PropertyUtilities.getFloat(user, rootName + "printArea.bottom", 0.0f);
        if (x3 > 0.0f) {
            this.atts.add(new MediaPrintableArea(x3, y2, w2, h2, 25400));
        }
    }

    public void setDrawBorder(boolean drawBorder) {
        this.drawBorder = drawBorder;
    }

    public boolean isDrawBorder() {
        return this.drawBorder;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setScaleUp(boolean scaleUp) {
        this.scaleUp = scaleUp;
    }

    public boolean getScaleUp() {
        return this.scaleUp;
    }

    public void setShowFooter(boolean showFooter) {
        this.showFooter = showFooter;
    }

    public boolean isShowFooter() {
        return this.showFooter;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public boolean isShowHeader() {
        return this.showHeader;
    }

    public int print(Graphics g2, PageFormat pf, int pi) throws PrinterException {
        boolean useLandscape;
        if (pi >= 1) {
            return 1;
        }
        Graphics2D orig = (Graphics2D)g2;
        Graphics2D g22 = (Graphics2D)orig.create();
        g22.translate(pf.getImageableX(), pf.getImageableY());
        Dimension size = this.target.getSize();
        double pageWidth = pf.getImageableWidth();
        double pageHeight = pf.getImageableHeight();
        double portraiteRatio = Math.min(pageWidth / (double)size.width, pageHeight / (double)size.height);
        double landscapeRatio = Math.min(pageWidth / (double)size.height, pageHeight / (double)size.width);
        if (!this.scaleUp) {
            portraiteRatio = Math.min(portraiteRatio, 1.0);
            landscapeRatio = Math.min(landscapeRatio, 1.0);
        }
        boolean bl = this.orientation == 0 ? landscapeRatio > portraiteRatio : (useLandscape = this.orientation == 2);
        if (useLandscape) {
            g22.rotate(1.5707963267948966);
            g22.translate(0.0, -pageWidth);
            g22.scale(landscapeRatio, landscapeRatio);
        } else {
            g22.scale(portraiteRatio, portraiteRatio);
        }
        this.target.print(g22);
        g22.dispose();
        if (this.drawBorder) {
            orig.setColor(Color.BLACK);
            orig.draw(new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pageWidth, pageHeight));
        }
        return 0;
    }

    void pageDialog(Component parent) {
        this.pj.pageDialog(this.atts);
    }

    public void print() throws PrinterException {
        this.pj.print(this.atts);
        this.commitChanges();
    }

    void printDialog(Component parent) {
        this.pj.printDialog(this.atts);
    }

    public void printPreview(Component parent) throws PrinterException {
        PrintPreview pp = new PrintPreview(){

            protected boolean onPrint(Pageable document) throws PrinterException {
                PrintHelper.this.print();
                return true;
            }

            protected void onError(PrinterException x2) {
                PrintHelper.this.app.error(this, "Print Error", x2);
            }
        };
        PageFormat pf = this.pj.defaultPage();
        Media media = (Media)this.atts.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PrintHelper.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media);
        if (media instanceof MediaSizeName) {
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
            MediaPrintableArea ma = (MediaPrintableArea)this.atts.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = PrintHelper.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea);
            Paper paper = pf.getPaper();
            paper.setSize(72.0f * ms.getX(25400), 72.0f * ms.getY(25400));
            paper.setImageableArea(72.0f * ma.getX(25400), 72.0f * ma.getY(25400), 72.0f * ma.getWidth(25400), 72.0f * ma.getHeight(25400));
            pf.setPaper(paper);
        }
        pp.setPrintable(this, pf);
        this.app.showDialog(pp.createDialog(parent), "printPreview");
    }

    public void showOptionsDialog(Component parent) {
        PrintDialog pd = new PrintDialog(this.app, this);
        int rc = pd.showDialog(parent);
        if (rc == 0) {
            this.commitChanges();
        }
    }

    private void commitChanges() {
        Media media;
        MediaPrintableArea mp;
        Properties user = this.app.getUserProperties();
        PropertyUtilities.setBoolean(user, rootName + "drawBorder", this.drawBorder);
        PropertyUtilities.setBoolean(user, rootName + "scaleUp", this.scaleUp);
        PropertyUtilities.setBoolean(user, rootName + "showHeader", this.showHeader);
        PropertyUtilities.setBoolean(user, rootName + "showFooter", this.showFooter);
        PropertyUtilities.setString(user, rootName + "footer", this.footer);
        PropertyUtilities.setString(user, rootName + "header", this.header);
        PropertyUtilities.setInteger(user, rootName + "orientation", this.orientation);
        PropertyUtilities.setString(user, rootName + "defaultPrinter", this.pj.getPrintService().getName());
        JobName jobName = (JobName)this.atts.get(class$javax$print$attribute$standard$JobName == null ? (class$javax$print$attribute$standard$JobName = PrintHelper.class$("javax.print.attribute.standard.JobName")) : class$javax$print$attribute$standard$JobName);
        if (jobName != null) {
            PropertyUtilities.setString(user, rootName + "printJobName", jobName.getName());
        }
        if ((mp = (MediaPrintableArea)this.atts.get(class$javax$print$attribute$standard$MediaPrintableArea == null ? (class$javax$print$attribute$standard$MediaPrintableArea = PrintHelper.class$("javax.print.attribute.standard.MediaPrintableArea")) : class$javax$print$attribute$standard$MediaPrintableArea)) != null) {
            PropertyUtilities.setFloat(user, rootName + "printArea.x", mp.getX(25400));
            PropertyUtilities.setFloat(user, rootName + "printArea.y", mp.getY(25400));
            PropertyUtilities.setFloat(user, rootName + "printArea.w", mp.getWidth(25400));
            PropertyUtilities.setFloat(user, rootName + "printArea.h", mp.getHeight(25400));
        }
        if ((media = (Media)this.atts.get(class$javax$print$attribute$standard$Media == null ? (class$javax$print$attribute$standard$Media = PrintHelper.class$("javax.print.attribute.standard.Media")) : class$javax$print$attribute$standard$Media)) instanceof MediaSizeName) {
            MediaSize ms = MediaSize.getMediaSizeForName((MediaSizeName)media);
            PropertyUtilities.setString(user, rootName + "mediaSize", media.getName());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

