/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.hyphenation;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.hyphenation.Hyphen;
import com.lowagie.text.pdf.hyphenation.PatternConsumer;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatternInternalParser
implements PatternConsumer {
    PatternConsumer consumer;

    public PatternInternalParser() {
    }

    public PatternInternalParser(PatternConsumer patternConsumer) {
        this.consumer = patternConsumer;
    }

    public void setConsumer(PatternConsumer patternConsumer) {
        this.consumer = patternConsumer;
    }

    protected String getHyphString(InputStream inputStream) throws IOException {
        int n2;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF8");
        char[] cArray = new char[4000];
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = inputStreamReader.read(cArray)) >= 0) {
            stringBuffer.append(cArray, 0, n2);
        }
        inputStreamReader.close();
        return stringBuffer.toString();
    }

    public void parse(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        this.parse(fileInputStream);
    }

    public void parse(InputStream inputStream) {
        String string;
        try {
            string = this.getHyphString(inputStream);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
        this.parseString(string);
    }

    public void parseString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        this.readClasses(stringTokenizer);
        this.readExceptions(stringTokenizer);
        this.readPatterns(stringTokenizer);
    }

    protected void readClasses(StringTokenizer stringTokenizer) {
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("*")) break;
            this.consumer.addClass(string);
        }
    }

    protected void readExceptions(StringTokenizer stringTokenizer) {
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("*")) break;
            String string2 = string;
            Vector<Object> vector = new Vector<Object>();
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                if (string.equals("{")) {
                    String string3;
                    String string4;
                    String string5 = stringTokenizer.nextToken();
                    if (string5.equals("N")) {
                        string5 = null;
                    }
                    if ((string4 = stringTokenizer.nextToken()).equals("N")) {
                        string4 = null;
                    }
                    if ((string3 = stringTokenizer.nextToken()).equals("N")) {
                        string3 = null;
                    }
                    Hyphen hyphen = new Hyphen(string4, string5, string3);
                    vector.addElement(hyphen);
                    continue;
                }
                if (string.equals("#")) break;
                vector.addElement(string);
            }
            this.consumer.addException(string2, vector);
        }
    }

    protected void readPatterns(StringTokenizer stringTokenizer) {
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            this.consumer.addPattern(string, stringTokenizer.nextToken());
        }
    }

    public void addClass(String string) {
        System.out.println("class: " + string);
    }

    public void addException(String string, Vector vector) {
        System.out.println("exception: " + string + " : " + vector.toString());
    }

    public void addPattern(String string, String string2) {
        System.out.println("pattern: " + string + " : " + string2);
    }
}

