/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileOrArray
implements DataInput {
    RandomAccessFile rf;
    String filename;
    byte[] arrayIn;
    int arrayInPtr;

    public RandomAccessFileOrArray(String string) throws IOException {
        this.filename = string;
        this.rf = new RandomAccessFile(string, "r");
    }

    public RandomAccessFileOrArray(byte[] byArray) {
        this.arrayIn = byArray;
    }

    public RandomAccessFileOrArray(RandomAccessFileOrArray randomAccessFileOrArray) {
        this.filename = randomAccessFileOrArray.filename;
        this.arrayIn = randomAccessFileOrArray.arrayIn;
    }

    public int read() throws IOException {
        if (this.arrayIn == null) {
            return this.rf.read();
        }
        if (this.arrayInPtr >= this.arrayIn.length) {
            return -1;
        }
        return this.arrayIn[this.arrayInPtr++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.arrayIn == null) {
            return this.rf.read(byArray, n2, n3);
        }
        if (n3 == 0) {
            return 0;
        }
        if (this.arrayInPtr >= this.arrayIn.length) {
            return -1;
        }
        if (this.arrayInPtr + n3 > this.arrayIn.length) {
            n3 = this.arrayIn.length - this.arrayInPtr;
        }
        System.arraycopy(this.arrayIn, this.arrayInPtr, byArray, n2, n3);
        this.arrayInPtr += n3;
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 0;
        do {
            if ((n4 = this.read(byArray, n2 + n5, n3 - n5)) >= 0) continue;
            throw new EOFException();
        } while ((n5 += n4) < n3);
    }

    public int skipBytes(int n2) throws IOException {
        int n3;
        if (n2 <= 0) {
            return 0;
        }
        int n4 = this.getFilePointer();
        int n5 = n4 + n2;
        if (n5 > (n3 = this.length())) {
            n5 = n3;
        }
        this.seek(n5);
        return n5 - n4;
    }

    void reOpen() throws IOException {
        if (this.filename != null) {
            this.close();
            this.rf = new RandomAccessFile(this.filename, "r");
        } else {
            this.arrayInPtr = 0;
        }
    }

    public void close() throws IOException {
        if (this.rf != null) {
            this.rf.close();
            this.rf = null;
        }
    }

    public int length() throws IOException {
        if (this.arrayIn == null) {
            return (int)this.rf.length();
        }
        return this.arrayIn.length;
    }

    public void seek(int n2) throws IOException {
        if (this.arrayIn == null) {
            this.rf.seek(n2);
        } else {
            this.arrayInPtr = n2;
        }
    }

    public int getFilePointer() throws IOException {
        if (this.arrayIn == null) {
            return (int)this.rf.getFilePointer();
        }
        return this.arrayInPtr;
    }

    public boolean readBoolean() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    public byte readByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public int readUnsignedByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public short readShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (short)((n3 << 8) + n2);
    }

    public int readUnsignedShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n3 << 8) + n2;
    }

    public char readChar() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (char)((n3 << 8) + n2);
    }

    public int readInt() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + n2;
    }

    public long readLong() throws IOException {
        return ((long)this.readInt() << 32) + ((long)this.readInt() & 0xFFFFFFFFL);
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        boolean bl = false;
        block4: while (!bl) {
            n2 = this.read();
            switch (n2) {
                case -1: 
                case 10: {
                    bl = true;
                    break;
                }
                case 13: {
                    bl = true;
                    int n3 = this.getFilePointer();
                    if (this.read() == 10) continue block4;
                    this.seek(n3);
                    break;
                }
                default: {
                    stringBuffer.append((char)n2);
                }
            }
        }
        if (n2 == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }
}

