/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

class PdfReaderInstance {
    static final PdfLiteral IDENTITYMATRIX = new PdfLiteral("[1 0 0 1 0 0]");
    static final PdfNumber ONE = new PdfNumber(1);
    PdfObject[] xrefObj;
    PdfDictionary[] pages;
    int[] myXref;
    PdfReader reader;
    RandomAccessFileOrArray file;
    HashMap importedPages = new HashMap();
    PdfWriter writer;
    HashMap visited = new HashMap();
    ArrayList nextRound = new ArrayList();

    PdfReaderInstance(PdfReader pdfReader, PdfWriter pdfWriter, PdfObject[] pdfObjectArray, PdfDictionary[] pdfDictionaryArray) {
        this.reader = pdfReader;
        this.xrefObj = pdfObjectArray;
        this.pages = pdfDictionaryArray;
        this.writer = pdfWriter;
        this.file = pdfReader.getSafeFile();
        this.myXref = new int[pdfObjectArray.length];
    }

    PdfReader getReader() {
        return this.reader;
    }

    PdfImportedPage getImportedPage(int n2) {
        if (n2 < 1 || n2 > this.pages.length) {
            throw new IllegalArgumentException("Invalid page number");
        }
        Integer n3 = new Integer(n2);
        PdfImportedPage pdfImportedPage = (PdfImportedPage)this.importedPages.get(n3);
        if (pdfImportedPage == null) {
            pdfImportedPage = new PdfImportedPage(this, this.writer, n2);
            this.importedPages.put(n3, pdfImportedPage);
        }
        return pdfImportedPage;
    }

    int getNewObjectNumber(int n2, int n3) {
        if (this.myXref[n2] == 0) {
            this.myXref[n2] = this.writer.getIndirectReferenceNumber();
            this.nextRound.add(new Integer(n2));
        }
        return this.myXref[n2];
    }

    RandomAccessFileOrArray getReaderFile() {
        return this.file;
    }

    PdfObject getResources(int n2) {
        return this.reader.getPdfObject(this.pages[n2 - 1].get(PdfName.RESOURCES));
    }

    PdfStream getFormXObject(int n2) throws IOException {
        PdfObject pdfObject;
        PdfDictionary pdfDictionary = this.pages[n2 - 1];
        PdfObject pdfObject2 = this.reader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
        int n3 = 0;
        int n4 = 0;
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        ByteArrayOutputStream byteArrayOutputStream = null;
        ArrayList arrayList = null;
        if (pdfObject2 != null) {
            if (pdfObject2.type() == 7) {
                pdfObject = (PRStream)pdfObject2;
                n3 = ((PRStream)pdfObject).getLength();
                n4 = ((PRStream)pdfObject).getOffset();
                pdfDictionary2.putAll((PdfDictionary)pdfObject);
            } else {
                pdfObject = (PdfArray)pdfObject2;
                ArrayList arrayList2 = ((PdfArray)pdfObject).getArrayList();
                byteArrayOutputStream = new ByteArrayOutputStream();
                int n5 = 0;
                while (n5 < arrayList2.size()) {
                    PRStream pRStream = (PRStream)this.reader.getPdfObject((PdfObject)arrayList2.get(n5));
                    PdfObject pdfObject3 = pRStream.get(PdfName.FILTER);
                    byte[] byArray = new byte[pRStream.getLength()];
                    this.file.seek(pRStream.getOffset());
                    this.file.readFully(byArray);
                    arrayList = new ArrayList();
                    if (pdfObject3 != null) {
                        if (pdfObject3.type() == 4) {
                            arrayList.add(pdfObject3);
                        } else if (pdfObject3.type() == 5) {
                            arrayList = ((PdfArray)pdfObject3).getArrayList();
                        }
                    }
                    int n6 = 0;
                    while (n6 < arrayList.size()) {
                        String string = ((PdfName)arrayList.get(n6)).toString();
                        if (string.equals("/FlateDecode") || string.equals("/Fl")) {
                            byArray = PdfReader.FlateDecode(byArray);
                        } else if (string.equals("/ASCIIHexDecode") || string.equals("/AHx")) {
                            byArray = PdfReader.ASCIIHexDecode(byArray);
                        } else if (string.equals("/ASCII85Decode") || string.equals("/A85")) {
                            byArray = PdfReader.ASCII85Decode(byArray);
                        } else if (string.equals("/LZWDecode")) {
                            byArray = PdfReader.LZWDecode(byArray);
                        } else {
                            throw new IOException("The filter " + string + " is not supported.");
                        }
                        ++n6;
                    }
                    byteArrayOutputStream.write(byArray);
                    if (n5 != arrayList2.size() - 1) {
                        byteArrayOutputStream.write(10);
                    }
                    ++n5;
                }
            }
        }
        pdfDictionary2.put(PdfName.RESOURCES, this.reader.getPdfObject(pdfDictionary.get(PdfName.RESOURCES)));
        pdfDictionary2.put(PdfName.TYPE, PdfName.XOBJECT);
        pdfDictionary2.put(PdfName.SUBTYPE, PdfName.FORM);
        pdfDictionary2.put(PdfName.BBOX, new PdfRectangle(((PdfImportedPage)this.importedPages.get(new Integer(n2))).getBoundingBox()));
        pdfDictionary2.put(PdfName.MATRIX, IDENTITYMATRIX);
        pdfDictionary2.put(PdfName.FORMTYPE, ONE);
        if (byteArrayOutputStream == null) {
            pdfObject = new PRStream(this.reader, n4);
            ((PdfDictionary)pdfObject).putAll(pdfDictionary2);
            ((PRStream)pdfObject).setLength(n3);
        } else {
            pdfObject = new PRStream(this.reader, byteArrayOutputStream.toByteArray());
            ((PdfDictionary)pdfObject).putAll(pdfDictionary2);
        }
        return pdfObject;
    }

    void writeAllVisited() throws IOException {
        while (this.nextRound.size() > 0) {
            ArrayList arrayList = this.nextRound;
            this.nextRound = new ArrayList();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                Integer n3 = (Integer)arrayList.get(n2);
                if (!this.visited.containsKey(n3)) {
                    this.visited.put(n3, null);
                    int n4 = n3;
                    this.writer.addToBody(this.xrefObj[n4], this.myXref[n4]);
                }
                ++n2;
            }
        }
    }

    void writeAllPages() throws IOException {
        this.file.reOpen();
        Iterator iterator = this.importedPages.values().iterator();
        while (iterator.hasNext()) {
            PdfImportedPage pdfImportedPage = (PdfImportedPage)iterator.next();
            this.writer.addToBody((PdfObject)pdfImportedPage.getFormXObject(), pdfImportedPage.getIndirectReference());
        }
        this.writeAllVisited();
        this.file.close();
    }
}

