/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageElement;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfPages
extends PdfDictionary
implements PdfPageElement {
    private PdfNumber count;
    private PdfArray kids;
    private ArrayList pages = new ArrayList();

    PdfPages() {
        super(PdfDictionary.PAGES);
        this.count = new PdfNumber(0);
        this.kids = new PdfArray();
        this.put(PdfName.COUNT, this.count);
        this.put(PdfName.KIDS, this.kids);
    }

    public void setParent(PdfIndirectReference pdfIndirectReference) {
        this.put(PdfName.PARENT, pdfIndirectReference);
    }

    public boolean isParent() {
        return true;
    }

    void add(PdfPages pdfPages) {
        pdfPages.add(pdfPages);
    }

    void add(PdfPage pdfPage) {
        this.pages.add(pdfPage);
    }

    void add(PdfIndirectReference pdfIndirectReference) {
        this.count.increment();
        this.kids.add(pdfIndirectReference);
    }

    Iterator iterator() {
        return ((AbstractList)this.pages).iterator();
    }

    int reorderPages(int[] nArray) throws DocumentException {
        if (nArray == null) {
            return this.kids.size();
        }
        if (nArray.length != this.kids.size()) {
            throw new DocumentException("Page reordering requires and array with the same size as the number of pages.");
        }
        int n2 = this.kids.size();
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            if (n4 < 1 || n4 > n2) {
                throw new DocumentException("Page reordering requires pages between 1 and " + n2 + ". Found " + n4 + ".");
            }
            if (blArray[n4 - 1]) {
                throw new DocumentException("Page reordering requires no page repetition. Page " + n4 + " is repeated.");
            }
            blArray[n4 - 1] = true;
            ++n3;
        }
        ArrayList arrayList = this.kids.getArrayList();
        Object[] objectArray = arrayList.toArray();
        int n5 = 0;
        while (n5 < n2) {
            arrayList.set(n5, objectArray[nArray[n5] - 1]);
            ++n5;
        }
        return n2;
    }
}

