/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPRow;
import com.lowagie.text.pdf.PdfPTableEvent;
import java.util.ArrayList;

public class PdfPTable
implements Element {
    public static final int BASECANVAS = 0;
    public static final int BACKGROUNDCANVAS = 1;
    public static final int LINECANVAS = 2;
    public static final int TEXTCANVAS = 3;
    protected ArrayList rows = new ArrayList();
    protected float totalHeight = 0.0f;
    protected PdfPCell[] currentRow;
    protected int currentRowIdx = 0;
    protected PdfPCell defaultCell = new PdfPCell((Phrase)null);
    protected float totalWidth = 0.0f;
    protected float[] relativeWidths;
    protected float[] absoluteWidths;
    protected PdfPTableEvent tableEvent;
    protected int headerRows;
    protected float widthPercentage = 80.0f;
    private int horizontalAlignment = 1;
    private boolean skipFirstHeader = false;
    protected boolean isColspan = false;

    public PdfPTable(float[] fArray) {
        if (fArray == null) {
            throw new NullPointerException("The widths array in PdfPTable constructor can not be null.");
        }
        if (fArray.length == 0) {
            throw new IllegalArgumentException("The widths array in PdfPTable constructor can not have zero length.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
    }

    public PdfPTable(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("The number of columns in PdfPTable constructor must be greater than zero.");
        }
        this.relativeWidths = new float[n2];
        int n3 = 0;
        while (n3 < n2) {
            this.relativeWidths[n3] = 1.0f;
            ++n3;
        }
        this.absoluteWidths = new float[this.relativeWidths.length];
        this.calculateWidths();
        this.currentRow = new PdfPCell[this.absoluteWidths.length];
    }

    public PdfPTable(PdfPTable pdfPTable) {
        this.relativeWidths = new float[pdfPTable.relativeWidths.length];
        this.absoluteWidths = new float[pdfPTable.relativeWidths.length];
        System.arraycopy(pdfPTable.relativeWidths, 0, this.relativeWidths, 0, this.relativeWidths.length);
        System.arraycopy(pdfPTable.absoluteWidths, 0, this.absoluteWidths, 0, this.relativeWidths.length);
        this.totalWidth = pdfPTable.totalWidth;
        this.totalHeight = pdfPTable.totalHeight;
        this.currentRowIdx = pdfPTable.currentRowIdx;
        this.tableEvent = pdfPTable.tableEvent;
        this.defaultCell = new PdfPCell(pdfPTable.defaultCell);
        this.currentRow = new PdfPCell[pdfPTable.currentRow.length];
        this.isColspan = pdfPTable.isColspan;
        int n2 = 0;
        while (n2 < this.currentRow.length) {
            if (pdfPTable.currentRow[n2] == null) break;
            this.currentRow[n2] = new PdfPCell(pdfPTable.currentRow[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < pdfPTable.rows.size()) {
            this.rows.add(new PdfPRow((PdfPRow)pdfPTable.rows.get(n3)));
            ++n3;
        }
    }

    public void setWidths(float[] fArray) throws DocumentException {
        if (fArray.length != this.relativeWidths.length) {
            throw new DocumentException("Wrong number of columns.");
        }
        this.relativeWidths = new float[fArray.length];
        System.arraycopy(fArray, 0, this.relativeWidths, 0, fArray.length);
        this.absoluteWidths = new float[fArray.length];
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public void setWidths(int[] nArray) throws DocumentException {
        float[] fArray = new float[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            fArray[n2] = nArray[n2];
            ++n2;
        }
        this.setWidths(fArray);
    }

    private void calculateWidths() {
        if (this.totalWidth <= 0.0f) {
            return;
        }
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < this.absoluteWidths.length) {
            f2 += this.relativeWidths[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.absoluteWidths.length) {
            this.absoluteWidths[n3] = this.totalWidth * this.relativeWidths[n3] / f2;
            ++n3;
        }
    }

    public void setTotalWidth(float f2) {
        if (this.totalWidth == f2) {
            return;
        }
        this.totalWidth = f2;
        this.totalHeight = 0.0f;
        this.calculateWidths();
        this.calculateHeights();
    }

    public float getTotalWidth() {
        return this.totalWidth;
    }

    void calculateHeights() {
        if (this.totalWidth <= 0.0f) {
            return;
        }
        this.totalHeight = 0.0f;
        int n2 = 0;
        while (n2 < this.rows.size()) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
            pdfPRow.setWidths(this.absoluteWidths);
            this.totalHeight += pdfPRow.getMaxHeights();
            ++n2;
        }
    }

    public PdfPCell getDefaultCell() {
        return this.defaultCell;
    }

    public void addCell(PdfPCell pdfPCell) {
        PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
        int n2 = pdfPCell2.getColspan();
        n2 = Math.max(n2, 1);
        n2 = Math.min(n2, this.currentRow.length - this.currentRowIdx);
        pdfPCell2.setColspan(n2);
        if (n2 != 1) {
            this.isColspan = true;
        }
        this.currentRow[this.currentRowIdx] = pdfPCell2;
        this.currentRowIdx += n2;
        if (this.currentRowIdx >= this.currentRow.length) {
            PdfPRow pdfPRow = new PdfPRow(this.currentRow);
            if (this.totalWidth > 0.0f) {
                pdfPRow.setWidths(this.absoluteWidths);
                this.totalHeight += pdfPRow.getMaxHeights();
            }
            this.rows.add(pdfPRow);
            this.currentRow = new PdfPCell[this.absoluteWidths.length];
            this.currentRowIdx = 0;
        }
    }

    public void addCell(String string) {
        this.addCell(new Phrase(string));
    }

    public void addCell(PdfPTable pdfPTable) {
        this.defaultCell.setTable(pdfPTable);
        this.addCell(this.defaultCell);
        this.defaultCell.setTable(null);
    }

    public void addCell(Phrase phrase) {
        this.defaultCell.setPhrase(phrase);
        this.addCell(this.defaultCell);
        this.defaultCell.setPhrase(null);
    }

    public float writeSelectedRows(int n2, int n3, float f2, float f3, PdfContentByte[] pdfContentByteArray) {
        Object object;
        if (this.totalWidth <= 0.0f) {
            throw new RuntimeException("The table width must be greater than zero.");
        }
        int n4 = this.rows.size();
        if (n3 < 0) {
            n3 = n4;
        }
        if (n2 >= n4 || n2 >= n3) {
            return f3;
        }
        n3 = Math.min(n3, n4);
        float f4 = f3;
        int n5 = n2;
        while (n5 < n3) {
            object = (PdfPRow)this.rows.get(n5);
            ((PdfPRow)object).writeCells(f2, f3, pdfContentByteArray);
            f3 -= ((PdfPRow)object).getMaxHeights();
            ++n5;
        }
        if (this.tableEvent != null) {
            object = new float[n3 - n2 + 1];
            object[0] = f4;
            int n6 = n2;
            while (n6 < n3) {
                PdfPRow pdfPRow = (PdfPRow)this.rows.get(n6);
                object[n6 - n2 + 1] = object[n6 - n2] - pdfPRow.getMaxHeights();
                ++n6;
            }
            this.tableEvent.tableLayout(this, this.getEventWidths(f2, n2, n3, false), (float[])object, 0, n2, pdfContentByteArray);
        }
        return f3;
    }

    public float writeSelectedRows(int n2, int n3, float f2, float f3, PdfContentByte pdfContentByte) {
        PdfContentByte[] pdfContentByteArray = PdfPTable.beginWritingRows(pdfContentByte);
        float f4 = this.writeSelectedRows(n2, n3, f2, f3, pdfContentByteArray);
        PdfPTable.endWritingRows(pdfContentByteArray);
        return f4;
    }

    public static PdfContentByte[] beginWritingRows(PdfContentByte pdfContentByte) {
        return new PdfContentByte[]{pdfContentByte, pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate(), pdfContentByte.getDuplicate()};
    }

    public static void endWritingRows(PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[0];
        pdfContentByte.saveState();
        pdfContentByte.add(pdfContentByteArray[1]);
        pdfContentByte.restoreState();
        pdfContentByte.saveState();
        pdfContentByte.setLineCap(2);
        pdfContentByte.resetRGBColorStroke();
        pdfContentByte.add(pdfContentByteArray[2]);
        pdfContentByte.restoreState();
        pdfContentByte.add(pdfContentByteArray[3]);
    }

    public int size() {
        return this.rows.size();
    }

    public float getTotalHeight() {
        return this.totalHeight;
    }

    public float getRowHeight(int n2) {
        if (this.totalWidth <= 0.0f || n2 < 0 || n2 >= this.rows.size()) {
            return 0.0f;
        }
        PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
        return pdfPRow.getMaxHeights();
    }

    public float getHeaderHeight() {
        float f2 = 0.0f;
        int n2 = Math.min(this.rows.size(), this.headerRows);
        int n3 = 0;
        while (n3 < n2) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(n3);
            f2 += pdfPRow.getMaxHeights();
            ++n3;
        }
        return f2;
    }

    public boolean deleteRow(int n2) {
        if (n2 < 0 || n2 >= this.rows.size()) {
            return false;
        }
        if (this.totalWidth > 0.0f) {
            PdfPRow pdfPRow = (PdfPRow)this.rows.get(n2);
            this.totalHeight -= pdfPRow.getMaxHeights();
        }
        this.rows.remove(n2);
        return true;
    }

    public boolean deleteLastRow() {
        return this.deleteRow(this.rows.size() - 1);
    }

    public int getHeaderRows() {
        return this.headerRows;
    }

    public void setHeaderRows(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        this.headerRows = n2;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public int type() {
        return 23;
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public float getWidthPercentage() {
        return this.widthPercentage;
    }

    public void setWidthPercentage(float f2) {
        this.widthPercentage = f2;
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int n2) {
        this.horizontalAlignment = n2;
    }

    PdfPRow getRow(int n2) {
        return (PdfPRow)this.rows.get(n2);
    }

    public void setTableEvent(PdfPTableEvent pdfPTableEvent) {
        this.tableEvent = pdfPTableEvent;
    }

    public PdfPTableEvent getTableEvent() {
        return this.tableEvent;
    }

    public float[] getAbsoluteWidths() {
        return this.absoluteWidths;
    }

    float[][] getEventWidths(float f2, int n2, int n3, boolean bl) {
        float[][] fArrayArray = new float[(bl ? this.headerRows : 0) + n3 - n2][];
        if (this.isColspan) {
            int n4 = 0;
            if (bl) {
                int n5 = 0;
                while (n5 < this.headerRows) {
                    fArrayArray[n4++] = ((PdfPRow)this.rows.get(n5)).getEventWidth(f2);
                    ++n5;
                }
            }
            while (n2 < n3) {
                fArrayArray[n4++] = ((PdfPRow)this.rows.get(n2)).getEventWidth(f2);
                ++n2;
            }
        } else {
            float[] fArray = new float[this.absoluteWidths.length + 1];
            fArray[0] = f2;
            int n6 = 0;
            while (n6 < this.absoluteWidths.length) {
                fArray[n6 + 1] = fArray[n6] + this.absoluteWidths[n6];
                ++n6;
            }
            int n7 = 0;
            while (n7 < fArrayArray.length) {
                fArrayArray[n7] = fArray;
                ++n7;
            }
        }
        return fArrayArray;
    }

    public boolean getSkipFirstHeader() {
        return this.skipFirstHeader;
    }

    public void setSkipFirstHeader(boolean bl) {
        this.skipFirstHeader = bl;
    }
}

