/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfArray
extends PdfObject {
    protected ArrayList arrayList;

    public PdfArray() {
        super(5);
        this.arrayList = new ArrayList();
    }

    public PdfArray(PdfObject pdfObject) {
        super(5);
        this.arrayList = new ArrayList();
        this.arrayList.add(pdfObject);
    }

    public PdfArray(float[] fArray) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(fArray);
    }

    public PdfArray(int[] nArray) {
        super(5);
        this.arrayList = new ArrayList();
        this.add(nArray);
    }

    public PdfArray(PdfArray pdfArray) {
        super(5);
        this.arrayList = new ArrayList(pdfArray.getArrayList());
    }

    public byte[] toPdf(PdfWriter pdfWriter) {
        try {
            PdfObject pdfObject;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(91);
            Iterator iterator = ((AbstractList)this.arrayList).iterator();
            if (iterator.hasNext()) {
                pdfObject = (PdfObject)iterator.next();
                byteArrayOutputStream.write(pdfObject.toPdf(pdfWriter));
            }
            while (iterator.hasNext()) {
                pdfObject = (PdfObject)iterator.next();
                byteArrayOutputStream.write(32);
                byteArrayOutputStream.write(pdfObject.toPdf(pdfWriter));
            }
            byteArrayOutputStream.write(93);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public ArrayList getArrayList() {
        return this.arrayList;
    }

    public int size() {
        return this.arrayList.size();
    }

    public boolean add(PdfObject pdfObject) {
        return this.arrayList.add(pdfObject);
    }

    public boolean add(float[] fArray) {
        int n2 = 0;
        while (n2 < fArray.length) {
            this.arrayList.add(new PdfNumber(fArray[n2]));
            ++n2;
        }
        return true;
    }

    public boolean add(int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            this.arrayList.add(new PdfNumber(nArray[n2]));
            ++n2;
        }
        return true;
    }

    public void addFirst(PdfObject pdfObject) {
        this.arrayList.add(0, pdfObject);
    }

    public boolean contains(PdfObject pdfObject) {
        return this.arrayList.contains(pdfObject);
    }
}

