/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLiteral;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfWriter;
import java.net.URL;

public class PdfAction
extends PdfDictionary {
    public static final int FIRSTPAGE = 1;
    public static final int PREVPAGE = 2;
    public static final int NEXTPAGE = 3;
    public static final int LASTPAGE = 4;
    public static final int PRINTDIALOG = 5;
    public static final int SUBMIT_EXCLUDE = 1;
    public static final int SUBMIT_INCLUDE_NO_VALUE_FIELDS = 2;
    public static final int SUBMIT_HTML_FORMAT = 4;
    public static final int SUBMIT_HTML_GET = 8;
    public static final int SUBMIT_COORDINATES = 16;
    public static final int RESET_EXCLUDE = 1;

    PdfAction() {
    }

    public PdfAction(URL uRL) {
        this(uRL.toExternalForm());
    }

    public PdfAction(URL uRL, boolean bl) {
        this(uRL.toExternalForm(), bl);
    }

    public PdfAction(String string) {
        this(string, false);
    }

    public PdfAction(String string, boolean bl) {
        this.put(PdfName.S, PdfName.URI);
        this.put(PdfName.URI, new PdfString(string));
        if (bl) {
            this.put(PdfName.ISMAP, PdfBoolean.PDFTRUE);
        }
    }

    PdfAction(PdfIndirectReference pdfIndirectReference) {
        this.put(PdfName.S, PdfName.GOTO);
        this.put(PdfName.D, pdfIndirectReference);
    }

    public PdfAction(String string, String string2) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(string));
        this.put(PdfName.D, new PdfString(string2));
    }

    public PdfAction(String string, int n2) {
        this.put(PdfName.S, PdfName.GOTOR);
        this.put(PdfName.F, new PdfString(string));
        this.put(PdfName.D, new PdfLiteral("[" + (n2 - 1) + " /FitH 10000]"));
    }

    public PdfAction(int n2) {
        this.put(PdfName.S, PdfName.NAMED);
        switch (n2) {
            case 1: {
                this.put(PdfName.N, PdfName.FIRSTPAGE);
                break;
            }
            case 4: {
                this.put(PdfName.N, PdfName.LASTPAGE);
                break;
            }
            case 3: {
                this.put(PdfName.N, PdfName.NEXTPAGE);
                break;
            }
            case 2: {
                this.put(PdfName.N, PdfName.PREVPAGE);
                break;
            }
            case 5: {
                this.put(PdfName.S, PdfName.JAVASCRIPT);
                this.put(PdfName.JS, new PdfString("this.print(true);\r"));
            }
            default: {
                throw new RuntimeException("Invalid named action.");
            }
        }
    }

    public PdfAction(String string, String string2, String string3, String string4) {
        this.put(PdfName.S, PdfName.LAUNCH);
        if (string2 == null && string3 == null && string4 == null) {
            this.put(PdfName.F, new PdfString(string));
        } else {
            PdfDictionary pdfDictionary = new PdfDictionary();
            pdfDictionary.put(PdfName.F, new PdfString(string));
            if (string2 != null) {
                pdfDictionary.put(PdfName.P, new PdfString(string2));
            }
            if (string3 != null) {
                pdfDictionary.put(PdfName.O, new PdfString(string3));
            }
            if (string4 != null) {
                pdfDictionary.put(PdfName.D, new PdfString(string4));
            }
            this.put(PdfName.WIN, pdfDictionary);
        }
    }

    public static PdfAction javaScript(String string, PdfWriter pdfWriter, boolean bl) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.JAVASCRIPT);
        if (bl && string.length() < 50) {
            pdfAction.put(PdfName.JS, new PdfString(string, "UnicodeBig"));
        } else if (!bl && string.length() < 100) {
            pdfAction.put(PdfName.JS, new PdfString(string));
        } else {
            try {
                byte[] byArray = PdfEncodings.convertToBytes(string, bl ? "UnicodeBig" : "PDF");
                PdfStream pdfStream = new PdfStream(byArray);
                pdfStream.flateCompress();
                pdfAction.put(PdfName.JS, pdfWriter.addToBody(pdfStream).getIndirectReference());
            }
            catch (Exception exception) {
                throw new ExceptionConverter(exception);
            }
        }
        return pdfAction;
    }

    public static PdfAction javaScript(String string, PdfWriter pdfWriter) {
        return PdfAction.javaScript(string, pdfWriter, false);
    }

    static PdfAction createHide(PdfObject pdfObject, boolean bl) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.HIDE);
        pdfAction.put(PdfName.T, pdfObject);
        if (!bl) {
            pdfAction.put(PdfName.H, PdfBoolean.PDFFALSE);
        }
        return pdfAction;
    }

    public static PdfAction createHide(PdfAnnotation pdfAnnotation, boolean bl) {
        return PdfAction.createHide(pdfAnnotation.getIndirectReference(), bl);
    }

    public static PdfAction createHide(String string, boolean bl) {
        return PdfAction.createHide(new PdfString(string), bl);
    }

    static PdfArray buildArray(Object[] objectArray) {
        PdfArray pdfArray = new PdfArray();
        int n2 = 0;
        while (n2 < objectArray.length) {
            Object object = objectArray[n2];
            if (object instanceof String) {
                pdfArray.add(new PdfString((String)object));
            } else if (object instanceof PdfAnnotation) {
                pdfArray.add(((PdfAnnotation)object).getIndirectReference());
            } else {
                throw new RuntimeException("The array must contain String or PdfAnnotation.");
            }
            ++n2;
        }
        return pdfArray;
    }

    public static PdfAction createHide(Object[] objectArray, boolean bl) {
        return PdfAction.createHide(PdfAction.buildArray(objectArray), bl);
    }

    public static PdfAction createSubmitForm(String string, Object[] objectArray, int n2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.SUBMITFORM);
        PdfDictionary pdfDictionary = new PdfDictionary();
        pdfDictionary.put(PdfName.F, new PdfString(string));
        pdfDictionary.put(PdfName.FS, PdfName.URL);
        pdfAction.put(PdfName.F, pdfDictionary);
        if (objectArray != null) {
            pdfAction.put(PdfName.FIELDS, PdfAction.buildArray(objectArray));
        }
        pdfAction.put(PdfName.FLAGS, new PdfNumber(n2));
        return pdfAction;
    }

    public static PdfAction createResetForm(Object[] objectArray, int n2) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.RESETFORM);
        if (objectArray != null) {
            pdfAction.put(PdfName.FIELDS, PdfAction.buildArray(objectArray));
        }
        pdfAction.put(PdfName.FLAGS, new PdfNumber(n2));
        return pdfAction;
    }

    public static PdfAction createImportData(String string) {
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.IMPORTDATA);
        pdfAction.put(PdfName.F, new PdfString(string));
        return pdfAction;
    }

    public void next(PdfAction pdfAction) {
        PdfObject pdfObject = this.get(PdfName.NEXT);
        if (pdfObject == null) {
            this.put(PdfName.NEXT, pdfAction);
        } else if (pdfObject.type() == 6) {
            PdfArray pdfArray = new PdfArray(pdfObject);
            pdfArray.add(pdfAction);
            this.put(PdfName.NEXT, pdfArray);
        } else {
            ((PdfArray)pdfObject).add(pdfAction);
        }
    }

    public static PdfAction gotoLocalPage(int n2, PdfDestination pdfDestination, PdfWriter pdfWriter) {
        PdfIndirectReference pdfIndirectReference = pdfWriter.getPageReference(n2);
        pdfDestination.addPage(pdfIndirectReference);
        PdfAction pdfAction = new PdfAction();
        pdfAction.put(PdfName.S, PdfName.GOTO);
        pdfAction.put(PdfName.D, pdfDestination);
        return pdfAction;
    }
}

