/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.EnumerateTTC;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import com.lowagie.text.pdf.Type1Font;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.HashMap;

public abstract class BaseFont {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    public static final int ASCENT = 1;
    public static final int CAPHEIGHT = 2;
    public static final int DESCENT = 3;
    public static final int ITALICANGLE = 4;
    public static final int BBOXLLX = 5;
    public static final int BBOXLLY = 6;
    public static final int BBOXURX = 7;
    public static final int BBOXURY = 8;
    public static final int AWT_ASCENT = 9;
    public static final int AWT_DESCENT = 10;
    public static final int AWT_LEADING = 11;
    public static final int AWT_MAXADVANCE = 12;
    public static final int FONT_TYPE_T1 = 0;
    public static final int FONT_TYPE_TT = 1;
    public static final int FONT_TYPE_CJK = 2;
    public static final int FONT_TYPE_TTUNI = 3;
    public static final String IDENTITY_H = "Identity-H";
    public static final String IDENTITY_V = "Identity-V";
    public static final String CP1250 = "Cp1250";
    public static final String CP1252 = "Cp1252";
    public static final String CP1257 = "Cp1257";
    public static final String WINANSI = "Cp1252";
    public static final String MACROMAN = "MacRoman";
    public static final boolean EMBEDDED = true;
    public static final boolean NOT_EMBEDDED = false;
    public static final boolean CACHED = true;
    public static final boolean NOT_CACHED = false;
    int fontType;
    public static final String notdef = ".notdef";
    protected int[] widths = new int[256];
    protected String[] differences = new String[256];
    protected char[] unicodeDifferences = new char[256];
    protected String encoding;
    protected boolean embedded;
    protected boolean fontSpecific = true;
    protected static HashMap fontCache = new HashMap();
    protected static final HashMap BuiltinFonts14 = new HashMap();
    protected static char[] subsetPrefix = new char[]{'A', 'B', 'C', 'D', 'E', 'E', '+'};
    protected boolean forceWidthsOutput = false;
    protected boolean directTextToByte = false;
    protected boolean subset = true;
    protected boolean fastWinansi = false;
    static /* synthetic */ Class class$java$lang$Thread;
    static /* synthetic */ Class class$com$lowagie$text$pdf$BaseFont;

    protected BaseFont() {
    }

    public static BaseFont createFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, true, null, null);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) throws DocumentException, IOException {
        HashMap hashMap;
        boolean bl3;
        String string3 = BaseFont.getBaseName(string);
        string2 = BaseFont.normalizeEncoding(string2);
        boolean bl4 = BuiltinFonts14.containsKey(string);
        boolean bl5 = bl3 = bl4 ? false : CJKFont.isCJKFont(string3, string2);
        if (bl4 || bl3) {
            bl = false;
        } else if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
            bl = true;
        }
        BaseFont baseFont = null;
        BaseFont baseFont2 = null;
        String string4 = string + "\n" + string2 + "\n" + bl;
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
            }
            if (baseFont != null) {
                return baseFont;
            }
        }
        if (bl4 || string.toLowerCase().endsWith(".afm")) {
            baseFont2 = new Type1Font(string, string2, bl, byArray, byArray2);
            baseFont2.fastWinansi = string2.equals("Cp1252");
        } else if (string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().indexOf(".ttc,") > 0) {
            if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
                baseFont2 = new TrueTypeFontUnicode(string, string2, bl, byArray);
            } else {
                baseFont2 = new TrueTypeFont(string, string2, bl, byArray);
                baseFont2.fastWinansi = string2.equals("Cp1252");
            }
        } else if (string3.toLowerCase().endsWith(".otf")) {
            baseFont2 = new TrueTypeFont(string, string2, bl, byArray);
            baseFont2.fastWinansi = string2.equals("Cp1252");
        } else if (bl3) {
            baseFont2 = new CJKFont(string, string2, bl);
        } else {
            throw new DocumentException("Font '" + string + "' with '" + string2 + "' is not recognized.");
        }
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
                if (baseFont != null) {
                    BaseFont baseFont3 = baseFont;
                    return baseFont3;
                }
                fontCache.put(string4, baseFont2);
            }
        }
        return baseFont2;
    }

    protected static String getBaseName(String string) {
        if (string.endsWith(",Bold")) {
            return string.substring(0, string.length() - 5);
        }
        if (string.endsWith(",Italic")) {
            return string.substring(0, string.length() - 7);
        }
        if (string.endsWith(",BoldItalic")) {
            return string.substring(0, string.length() - 11);
        }
        return string;
    }

    protected static String normalizeEncoding(String string) {
        if (string.equals("winansi") || string.equals("")) {
            return "Cp1252";
        }
        if (string.equals("macroman")) {
            return MACROMAN;
        }
        return string;
    }

    protected void createEncoding() throws UnsupportedEncodingException {
        if (this.fontSpecific) {
            int n2 = 0;
            while (n2 < 256) {
                this.widths[n2] = this.getRawWidth(n2, null);
                ++n2;
            }
        } else {
            byte[] byArray = new byte[1];
            int n3 = 0;
            while (n3 < 256) {
                byArray[0] = (byte)n3;
                String string = new String(byArray, this.encoding);
                int n4 = string.length() > 0 ? (int)string.charAt(0) : 63;
                String string2 = GlyphList.unicodeToName(n4);
                if (string2 == null) {
                    string2 = notdef;
                }
                this.differences[n3] = string2;
                this.unicodeDifferences[n3] = n4;
                this.widths[n3] = this.getRawWidth(n4, string2);
                ++n3;
            }
        }
    }

    protected abstract int getRawWidth(int var1, String var2);

    public abstract int getKerning(char var1, char var2);

    public int getWidth(char c2) {
        if (this.fastWinansi) {
            if (c2 < '\u0080' || c2 >= '\u00a0' && c2 <= '\u00ff') {
                return this.widths[c2];
            }
            return this.widths[PdfEncodings.winansi.get(c2)];
        }
        return this.getWidth(new String(new char[]{c2}));
    }

    public int getWidth(String string) {
        int n2 = 0;
        if (this.fastWinansi) {
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                char c2 = string.charAt(n4);
                n2 = c2 < '\u0080' || c2 >= '\u00a0' && c2 <= '\u00ff' ? (n2 += this.widths[c2]) : (n2 += this.widths[PdfEncodings.winansi.get(c2)]);
                ++n4;
            }
            return n2;
        }
        byte[] byArray = this.convertToBytes(string);
        int n5 = 0;
        while (n5 < byArray.length) {
            n2 += this.widths[0xFF & byArray[n5]];
            ++n5;
        }
        return n2;
    }

    public float getWidthPoint(String string, float f2) {
        return (float)this.getWidth(string) * 0.001f * f2;
    }

    public float getWidthPoint(char c2, float f2) {
        return (float)this.getWidth(c2) * 0.001f * f2;
    }

    byte[] convertToBytes(String string) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes(string, null);
        }
        return PdfEncodings.convertToBytes(string, this.encoding);
    }

    abstract void writeFont(PdfWriter var1, PdfIndirectReference var2, Object[] var3) throws DocumentException, IOException;

    public String getEncoding() {
        return this.encoding;
    }

    public abstract float getFontDescriptor(int var1, float var2);

    public int getFontType() {
        return this.fontType;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isFontSpecific() {
        return this.fontSpecific;
    }

    String createSubsetPrefix() {
        char[] cArray = subsetPrefix;
        synchronized (cArray) {
            int n2 = 0;
            while (n2 < subsetPrefix.length - 1) {
                char c2 = subsetPrefix[n2];
                if (c2 != 'Z') {
                    BaseFont.subsetPrefix[n2] = (char)(c2 + '\u0001');
                    break;
                }
                BaseFont.subsetPrefix[n2] = 65;
                ++n2;
            }
            String string = new String(subsetPrefix);
            return string;
        }
    }

    char getUnicodeDifferences(int n2) {
        return this.unicodeDifferences[n2];
    }

    public abstract String getPostscriptFontName();

    public abstract String[][] getFullFontName();

    public static String[][] getFullFontName(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return ((BaseFont)baseFont).getFullFontName();
    }

    public abstract String[][] getFamilyFontName();

    public String[] getCodePagesSupported() {
        return new String[0];
    }

    public static String[] enumerateTTCNames(String string) throws DocumentException, IOException {
        return new EnumerateTTC(string).getNames();
    }

    public static String[] enumerateTTCNames(byte[] byArray) throws DocumentException, IOException {
        return new EnumerateTTC(byArray).getNames();
    }

    public int[] getWidths() {
        return this.widths;
    }

    public String[] getDifferences() {
        return this.differences;
    }

    public char[] getUnicodeDifferences() {
        return this.unicodeDifferences;
    }

    public boolean isForceWidthsOutput() {
        return this.forceWidthsOutput;
    }

    public void setForceWidthsOutput(boolean bl) {
        this.forceWidthsOutput = bl;
    }

    public boolean isDirectTextToByte() {
        return this.directTextToByte;
    }

    public void setDirectTextToByte(boolean bl) {
        this.directTextToByte = bl;
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl) {
        this.subset = bl;
    }

    public static InputStream getResourceStream(String string) {
        InputStream inputStream = null;
        try {
            Method method = (class$java$lang$Thread == null ? (class$java$lang$Thread = BaseFont.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            if (method != null) {
                ClassLoader classLoader = (ClassLoader)method.invoke((Object)Thread.currentThread(), new Object[0]);
                inputStream = classLoader.getResourceAsStream("fonts/" + string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = (class$com$lowagie$text$pdf$BaseFont == null ? (class$com$lowagie$text$pdf$BaseFont = BaseFont.class$("com.lowagie.text.pdf.BaseFont")) : class$com$lowagie$text$pdf$BaseFont).getResourceAsStream("fonts/" + string);
        }
        return inputStream;
    }

    public char getUnicodeEquivalent(char c2) {
        return c2;
    }

    public char getCidCode(char c2) {
        return c2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BuiltinFonts14.put(COURIER, PdfName.COURIER);
        BuiltinFonts14.put(COURIER_BOLD, PdfName.COURIER_BOLD);
        BuiltinFonts14.put(COURIER_BOLDOBLIQUE, PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put(COURIER_OBLIQUE, PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put(HELVETICA, PdfName.HELVETICA);
        BuiltinFonts14.put(HELVETICA_BOLD, PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put(HELVETICA_BOLDOBLIQUE, PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put(HELVETICA_OBLIQUE, PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put(SYMBOL, PdfName.SYMBOL);
        BuiltinFonts14.put(TIMES_ROMAN, PdfName.TIMES_ROMAN);
        BuiltinFonts14.put(TIMES_BOLD, PdfName.TIMES_BOLD);
        BuiltinFonts14.put(TIMES_BOLDITALIC, PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put(TIMES_ITALIC, PdfName.TIMES_ITALIC);
        BuiltinFonts14.put(ZAPFDINGBATS, PdfName.ZAPFDINGBATS);
    }

    class StreamFont
    extends PdfStream {
        public StreamFont(byte[] byArray, int[] nArray) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                int n2 = 0;
                while (n2 < nArray.length) {
                    this.put(new PdfName("Length" + (n2 + 1)), new PdfNumber(nArray[n2]));
                    ++n2;
                }
                this.flateCompress();
            }
            catch (Exception exception) {
                throw new DocumentException(exception.getMessage());
            }
        }

        public StreamFont(byte[] byArray, String string) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                if (string != null) {
                    this.put(PdfName.SUBTYPE, new PdfName(string));
                }
                this.flateCompress();
            }
            catch (Exception exception) {
                throw new DocumentException(exception.getMessage());
            }
        }
    }
}

