/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;

public class BarcodePostnet
extends Barcode {
    static byte[][] BARS = new byte[][]{{1, 1, 0, 0, 0}, {0, 0, 0, 1, 1}, {0, 0, 1, 0, 1}, {0, 0, 1, 1, 0}, {0, 1, 0, 0, 1}, {0, 1, 0, 1, 0}, {0, 1, 1, 0, 0}, {1, 0, 0, 0, 1}, {1, 0, 0, 1, 0}, {1, 0, 1, 0, 0}};

    public BarcodePostnet() {
        this.n = 3.2727273f;
        this.x = 1.4399999f;
        this.barHeight = 9.0f;
        this.size = 3.6000001f;
        this.codeType = 7;
    }

    public static byte[] getBarsPostnet(String string) {
        int n2 = 0;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            int n4 = string.charAt(n3) - 48;
            n2 += n4;
            --n3;
        }
        string = string + (char)((10 - n2 % 10) % 10 + 48);
        byte[] byArray = new byte[string.length() * 5 + 2];
        byArray[0] = 1;
        byArray[byArray.length - 1] = 1;
        int n5 = 0;
        while (n5 < string.length()) {
            int n6 = string.charAt(n5) - 48;
            System.arraycopy(BARS[n6], 0, byArray, n5 * 5 + 1, 5);
            ++n5;
        }
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        float f2 = (float)((this.code.length() + 1) * 5 + 1) * this.n + this.x;
        return new Rectangle(f2, this.barHeight);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        byte[] byArray = BarcodePostnet.getBarsPostnet(this.code);
        byte by = 1;
        if (this.codeType == 8) {
            by = 0;
            byArray[0] = 0;
            byArray[byArray.length - 1] = 0;
        }
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < byArray.length) {
            pdfContentByte.rectangle(f2, 0.0f, this.x, byArray[n2] == by ? this.barHeight : this.size);
            f2 += this.n;
            ++n2;
        }
        pdfContentByte.fill();
        return this.getBarcodeSize();
    }
}

