/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.Barcode;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import java.awt.Color;

public class Barcode128
extends Barcode {
    static byte[][] BARS = new byte[][]{{2, 1, 2, 2, 2, 2}, {2, 2, 2, 1, 2, 2}, {2, 2, 2, 2, 2, 1}, {1, 2, 1, 2, 2, 3}, {1, 2, 1, 3, 2, 2}, {1, 3, 1, 2, 2, 2}, {1, 2, 2, 2, 1, 3}, {1, 2, 2, 3, 1, 2}, {1, 3, 2, 2, 1, 2}, {2, 2, 1, 2, 1, 3}, {2, 2, 1, 3, 1, 2}, {2, 3, 1, 2, 1, 2}, {1, 1, 2, 2, 3, 2}, {1, 2, 2, 1, 3, 2}, {1, 2, 2, 2, 3, 1}, {1, 1, 3, 2, 2, 2}, {1, 2, 3, 1, 2, 2}, {1, 2, 3, 2, 2, 1}, {2, 2, 3, 2, 1, 1}, {2, 2, 1, 1, 3, 2}, {2, 2, 1, 2, 3, 1}, {2, 1, 3, 2, 1, 2}, {2, 2, 3, 1, 1, 2}, {3, 1, 2, 1, 3, 1}, {3, 1, 1, 2, 2, 2}, {3, 2, 1, 1, 2, 2}, {3, 2, 1, 2, 2, 1}, {3, 1, 2, 2, 1, 2}, {3, 2, 2, 1, 1, 2}, {3, 2, 2, 2, 1, 1}, {2, 1, 2, 1, 2, 3}, {2, 1, 2, 3, 2, 1}, {2, 3, 2, 1, 2, 1}, {1, 1, 1, 3, 2, 3}, {1, 3, 1, 1, 2, 3}, {1, 3, 1, 3, 2, 1}, {1, 1, 2, 3, 1, 3}, {1, 3, 2, 1, 1, 3}, {1, 3, 2, 3, 1, 1}, {2, 1, 1, 3, 1, 3}, {2, 3, 1, 1, 1, 3}, {2, 3, 1, 3, 1, 1}, {1, 1, 2, 1, 3, 3}, {1, 1, 2, 3, 3, 1}, {1, 3, 2, 1, 3, 1}, {1, 1, 3, 1, 2, 3}, {1, 1, 3, 3, 2, 1}, {1, 3, 3, 1, 2, 1}, {3, 1, 3, 1, 2, 1}, {2, 1, 1, 3, 3, 1}, {2, 3, 1, 1, 3, 1}, {2, 1, 3, 1, 1, 3}, {2, 1, 3, 3, 1, 1}, {2, 1, 3, 1, 3, 1}, {3, 1, 1, 1, 2, 3}, {3, 1, 1, 3, 2, 1}, {3, 3, 1, 1, 2, 1}, {3, 1, 2, 1, 1, 3}, {3, 1, 2, 3, 1, 1}, {3, 3, 2, 1, 1, 1}, {3, 1, 4, 1, 1, 1}, {2, 2, 1, 4, 1, 1}, {4, 3, 1, 1, 1, 1}, {1, 1, 1, 2, 2, 4}, {1, 1, 1, 4, 2, 2}, {1, 2, 1, 1, 2, 4}, {1, 2, 1, 4, 2, 1}, {1, 4, 1, 1, 2, 2}, {1, 4, 1, 2, 2, 1}, {1, 1, 2, 2, 1, 4}, {1, 1, 2, 4, 1, 2}, {1, 2, 2, 1, 1, 4}, {1, 2, 2, 4, 1, 1}, {1, 4, 2, 1, 1, 2}, {1, 4, 2, 2, 1, 1}, {2, 4, 1, 2, 1, 1}, {2, 2, 1, 1, 1, 4}, {4, 1, 3, 1, 1, 1}, {2, 4, 1, 1, 1, 2}, {1, 3, 4, 1, 1, 1}, {1, 1, 1, 2, 4, 2}, {1, 2, 1, 1, 4, 2}, {1, 2, 1, 2, 4, 1}, {1, 1, 4, 2, 1, 2}, {1, 2, 4, 1, 1, 2}, {1, 2, 4, 2, 1, 1}, {4, 1, 1, 2, 1, 2}, {4, 2, 1, 1, 1, 2}, {4, 2, 1, 2, 1, 1}, {2, 1, 2, 1, 4, 1}, {2, 1, 4, 1, 2, 1}, {4, 1, 2, 1, 2, 1}, {1, 1, 1, 1, 4, 3}, {1, 1, 1, 3, 4, 1}, {1, 3, 1, 1, 4, 1}, {1, 1, 4, 1, 1, 3}, {1, 1, 4, 3, 1, 1}, {4, 1, 1, 1, 1, 3}, {4, 1, 1, 3, 1, 1}, {1, 1, 3, 1, 4, 1}, {1, 1, 4, 1, 3, 1}, {3, 1, 1, 1, 4, 1}, {4, 1, 1, 1, 3, 1}, {2, 1, 1, 4, 1, 2}, {2, 1, 1, 2, 1, 4}, {2, 1, 1, 2, 3, 2}};
    static byte[] BARS_STOP = new byte[]{2, 3, 3, 1, 1, 1, 2};
    public static final char CODE_AB_TO_C = 'c';
    public static final char CODE_AC_TO_B = 'd';
    public static final char CODE_BC_TO_A = 'e';
    public static final char FNC1 = 'f';
    public static final char START_A = 'g';
    public static final char START_B = 'h';
    public static final char START_C = 'i';

    public Barcode128() {
        try {
            this.x = 0.8f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.codeType = 9;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    /*
     * Unable to fully structure code
     */
    static boolean isNextDigits(String var0, int var1_1, int var2_2) {
        if (var1_1 + var2_2 <= var0.length()) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if ((var3_3 = var0.charAt(var1_1++)) >= '0' && var3_3 <= '9') continue;
            return false;
lbl5:
            // 2 sources

            ** while (var2_2-- > 0)
        }
lbl6:
        // 1 sources

        return true;
    }

    static String getPackedRawDigits(String string, int n2, int n3) {
        String string2 = "";
        while (n3 > 0) {
            n3 -= 2;
            int n4 = string.charAt(n2++) - 48;
            int n5 = string.charAt(n2++) - 48;
            string2 = string2 + (char)(n4 * 10 + n5);
        }
        return string2;
    }

    public static String getRawText(String string, boolean bl) {
        String string2 = "";
        int n2 = string.length();
        if (n2 == 0) {
            string2 = string2 + 'h';
            if (bl) {
                string2 = string2 + 'f';
            }
            return string2;
        }
        char c2 = '\u0000';
        int n3 = 0;
        while (n3 < n2) {
            c2 = string.charAt(n3);
            if (c2 > '\u007f') {
                throw new RuntimeException("There are illegal characters for barcode 128 in '" + string + "'.");
            }
            ++n3;
        }
        c2 = string.charAt(0);
        int n4 = 104;
        int n5 = 0;
        if (Barcode128.isNextDigits(string, n5, 2)) {
            n4 = 105;
            string2 = string2 + (char)n4;
            if (bl) {
                string2 = string2 + 'f';
            }
            string2 = string2 + Barcode128.getPackedRawDigits(string, n5, 2);
            n5 += 2;
        } else if (c2 < ' ') {
            n4 = 103;
            string2 = string2 + (char)n4;
            if (bl) {
                string2 = string2 + 'f';
            }
            string2 = string2 + (char)(c2 + 64);
            ++n5;
        } else {
            string2 = string2 + (char)n4;
            if (bl) {
                string2 = string2 + 'f';
            }
            string2 = string2 + (char)(c2 - 32);
            ++n5;
        }
        while (n5 < n2) {
            switch (n4) {
                case 103: {
                    if (Barcode128.isNextDigits(string, n5, 4)) {
                        n4 = 105;
                        string2 = string2 + 'c';
                        string2 = string2 + Barcode128.getPackedRawDigits(string, n5, 4);
                        n5 += 4;
                        break;
                    }
                    if ((c2 = string.charAt(n5++)) > '_') {
                        n4 = 104;
                        string2 = string2 + 'd';
                        string2 = string2 + (char)(c2 - 32);
                        break;
                    }
                    if (c2 < ' ') {
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    string2 = string2 + (char)(c2 - 32);
                    break;
                }
                case 104: {
                    if (Barcode128.isNextDigits(string, n5, 4)) {
                        n4 = 105;
                        string2 = string2 + 'c';
                        string2 = string2 + Barcode128.getPackedRawDigits(string, n5, 4);
                        n5 += 4;
                        break;
                    }
                    if ((c2 = string.charAt(n5++)) < ' ') {
                        n4 = 103;
                        string2 = string2 + 'e';
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    string2 = string2 + (char)(c2 - 32);
                    break;
                }
                case 105: {
                    if (Barcode128.isNextDigits(string, n5, 2)) {
                        string2 = string2 + Barcode128.getPackedRawDigits(string, n5, 2);
                        n5 += 2;
                        break;
                    }
                    if ((c2 = string.charAt(n5++)) < ' ') {
                        n4 = 103;
                        string2 = string2 + 'e';
                        string2 = string2 + (char)(c2 + 64);
                        break;
                    }
                    n4 = 104;
                    string2 = string2 + 'd';
                    string2 = string2 + (char)(c2 - 32);
                }
            }
        }
        return string2;
    }

    public static byte[] getBarsCode128Raw(String string) {
        int n2 = string.indexOf(65535);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        int n3 = string.charAt(0);
        int n4 = 1;
        while (n4 < string.length()) {
            n3 += n4 * string.charAt(n4);
            ++n4;
        }
        string = string + (char)(n3 %= 103);
        byte[] byArray = new byte[(string.length() + 1) * 6 + 7];
        int n5 = 0;
        while (n5 < string.length()) {
            System.arraycopy(BARS[string.charAt(n5)], 0, byArray, n5 * 6, 6);
            ++n5;
        }
        System.arraycopy(BARS_STOP, 0, byArray, n5 * 6, 7);
        return byArray;
    }

    public Rectangle getBarcodeSize() {
        int n2;
        String string;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (this.font != null) {
            f3 = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            string = this.code;
            if (this.codeType == 10) {
                n2 = this.code.indexOf(65535);
                string = n2 < 0 ? "" : this.code.substring(n2 + 1);
            }
            f2 = this.font.getWidthPoint(string, this.size);
        }
        string = this.codeType == 10 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = string.length();
        float f4 = (float)((n2 + 2) * 11) * this.x + 2.0f * this.x;
        f4 = Math.max(f4, f2);
        float f5 = this.barHeight + f3;
        return new Rectangle(f4, f5);
    }

    public Rectangle placeBarcode(PdfContentByte pdfContentByte, Color color, Color color2) {
        int n2;
        String string = this.code;
        if (this.codeType == 10) {
            int n3 = this.code.indexOf(65535);
            string = n3 < 0 ? "" : this.code.substring(n3 + 1);
        }
        float f2 = 0.0f;
        if (this.font != null) {
            f2 = this.font.getWidthPoint(string, this.size);
        }
        String string2 = this.codeType == 10 ? ((n2 = this.code.indexOf(65535)) >= 0 ? this.code.substring(0, n2) : this.code) : Barcode128.getRawText(this.code, this.codeType == 10);
        n2 = string2.length();
        float f3 = (float)((n2 + 2) * 11) * this.x + 2.0f * this.x;
        float f4 = 0.0f;
        float f5 = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (f2 > f3) {
                    f4 = f2 - f3;
                    break;
                }
                f5 = f3 - f2;
                break;
            }
            default: {
                if (f2 > f3) {
                    f4 = (f2 - f3) / 2.0f;
                    break;
                }
                f5 = (f3 - f2) / 2.0f;
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                f7 = this.barHeight - this.baseline;
            } else {
                f7 = -this.font.getFontDescriptor(3, this.size);
                f6 = f7 + this.baseline;
            }
        }
        byte[] byArray = Barcode128.getBarsCode128Raw(string2);
        boolean bl = true;
        if (color != null) {
            pdfContentByte.setColorFill(color);
        }
        int n4 = 0;
        while (n4 < byArray.length) {
            float f8 = (float)byArray[n4] * this.x;
            if (bl) {
                pdfContentByte.rectangle(f4, f6, f8, this.barHeight);
            }
            bl = !bl;
            f4 += f8;
            ++n4;
        }
        pdfContentByte.fill();
        if (this.font != null) {
            if (color2 != null) {
                pdfContentByte.setColorFill(color2);
            }
            pdfContentByte.beginText();
            pdfContentByte.setFontAndSize(this.font, this.size);
            pdfContentByte.setTextMatrix(f5, f7);
            pdfContentByte.showText(string);
            pdfContentByte.endText();
        }
        return this.getBarcodeSize();
    }
}

