import Sav.Z.*;
import java.io.*;
/**
 * Following is a complete simple example of using Z request and
 * Z description. If request has been unsuccessful, program
 * initiates description. Database schema is formed automatically.
 */
public class SessionDemo extends Session {
  public static void main(String arg[]) {
    SessionDemo ss = new SessionDemo("Users");
    System.out.println("Requesting...");
    String result = ss.request("User:ann1");
    if (result.length() == 0) {
      System.out.println("Describing...");
      ss.describe("User:ann1", "Password:111111");
      result = ss.request("User:ann1");
    }
    System.out.println(result);
  }
  SessionDemo(String dbPath) {
    super();
    z("$base \"" + dbPath + "\"");
  }
  String request(String object) {
    String sQuery = "= " + object + ";";
    z(sQuery);
    String result = report();
    return result;
  }
  void describe(String object, String attributes) {
    String sUpdate = object + "(" + attributes + ");";
    z(sUpdate);
  }
}